<?php

use App\Http\Controllers\CustomersAdvanced;
use App\Http\Controllers\VatController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\BillSubjectController;
use App\Http\Controllers\DepartmentController;
use App\Http\Controllers\GlHeadController;
use App\Http\Controllers\UserDeptController;
use App\Http\Controllers\DepositoryBankController;
use App\Http\Controllers\CustomerBankController;
use App\Http\Controllers\ConfigurationController;
use App\Http\Controllers\BillController;
use App\Http\Controllers\BillProcessController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\CollectionController;
use App\Http\Controllers\InstantInvoiceController;
use App\Http\Controllers\BillDashboardController;
use App\Http\Controllers\SettingsController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\PagePermissionController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\FixingController;
use Illuminate\Support\Facades\Artisan;

Auth::routes();

Route::get('/', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
Route::get('/dashboard', [App\Http\Controllers\HomeController::class, 'index'])->name('dashboard');
Route::get('/deal-details', [App\Http\Controllers\HomeController::class, 'dealDetails'])->name('deal.details');
Route::get('/deal-details-project/{id}', [App\Http\Controllers\HomeController::class, 'dealDetailsProject'])->name('deal.details.project');

Route::get('authenticate', [UserController::class, 'authenticate']);

Route::get('token', function(){
    return session('api_token');
});

Route::get('symlink', function () {
    Artisan::call('storage:link');
    return 'Symlink process successfully completed';
});

Route::get('cache-clear', function () {
    Artisan::call('optimize:clear');
    return redirect()->back()->with('success', 'Cache cleared successfully.');
})->name('cache.clear');

Route::middleware(['auth'])->group(function () {
    Route::resource('users', UserController::class);
    Route::resource('bill-subject', BillSubjectController::class);
    Route::resource('department', DepartmentController::class);
    Route::resource('gl-head', GlHeadController::class);
    Route::resource('user-dept', UserDeptController::class);
    Route::resource('depository-bank', DepositoryBankController::class);
    Route::resource('customer-bank', CustomerBankController::class);
    Route::resource('configuration', ConfigurationController::class);
    Route::resource('bills', BillController::class);
    Route::resource('roles', RoleController::class);
    Route::resource('customers', CustomerController::class);
    Route::resource('settings', SettingsController::class);
    Route::resource('bill-process', BillProcessController::class);

    Route::post('/get-order-sl-no', [BillController::class, 'getOrderSlNo'])->name('getOrderSlNo');
    Route::get('get-dept-users/{deptId}', [BillController::class, 'getDeptUsers'])->name('get.dept.users');


    Route::get('awaiting-bills', [BillController::class, 'awaitingBills'])->name('bills.awaiting');
    Route::get('proposal-info', [BillController::class, 'proposalInfo'])->name('bills.proposal-info');
    Route::get('proposal-info-edit/{id}', [BillController::class, 'proposalInfoEdit'])->name('bills.proposal-info-edit');
    Route::post('proposal-info-update/{id}', [BillController::class, 'proposalInfoUpdate'])->name('bills.proposal-info-update');
    Route::post('proposal-info-delete', [BillController::class, 'proposalInfoDelete'])->name('bills.proposal-info-delete');
    Route::get('proposal-info-show/{id}', [BillController::class, 'proposalInfoShow'])->name('bills.proposal-info-show');
    Route::get('awaiting-edit/{id}', [BillController::class, 'awaitingEdit'])->name('bills.awaiting.edit');
    Route::get('awaiting-status-change/{id}/{status}', [BillController::class, 'changeStatusAwaiting'])->name('bills.awaiting.statusChange');
    Route::post('awaiting-status-change-batch', [BillController::class, 'changeStatusAwaitingBatch'])->name('bills.awaiting.statusChangeBatch');


    Route::get('pending-bills', [BillController::class, 'pendingBills'])->name('bills.pending');
    Route::get('rejected-bills', [BillController::class, 'rejectedBills'])->name('bills.rejected');
    Route::get('show-reject-note/{id}', [BillController::class, 'showRejectNote'])->name('bills.reject.note');
    Route::get('bill-status-change/{id}/{status}', [BillController::class, 'changeStatus'])->name('bills.statusChange');
    Route::get('request-approval/{id}', [BillController::class, 'requestApproval'])->name('bills.request');
    Route::get('show-bill-note/{id}', [BillController::class, 'showBillNote'])->name('bills.show.note');
    Route::post('bill-status-rejected-batch', [BillController::class, 'changeRejectedBatch'])->name('bills.rejectedBatch');
    Route::post('bill-status-pending-batch', [BillController::class, 'changePendingBatch'])->name('bills.pendingBatch');
    Route::get('bill-delete/{id}/{type}', [BillController::class, 'billDelete'])->name('bills.single.delete');
    Route::post('bill-back-from-edit/{id}', [BillController::class, 'billEditBack'])->name('bills.edit.back');
    Route::post('bill-back-from-edit-editor/{id}', [BillController::class, 'billEditBackEditor'])->name('bills.edit.backEditor');
    Route::get('active-inactive-bills/{id?}', [BillController::class, 'activeInactiveBills'])->name('active.inactive.bills');
    Route::get('active-inactive-status/{id}/{type}', [BillController::class, 'billActiveStatus'])->name('active.inactive.status');

    Route::get('billFixingFind/{type?}/{id?}', [BillController::class, 'billFixingFind'])->name('billFixingFind');
    Route::post('billFixingStore/{bill_id?}', [BillController::class, 'billFixingStore'])->name('billFixingStore');

    // Bill Ending
    Route::get('report/ending-bills/{month?}/{customer_id?}', [BillController::class, 'endingBills'])->name('report.endingBills');

    Route::get('invoices', [BillProcessController::class, 'invoices'])->name('invoices.index');
    Route::get('invoice/{id}', [BillProcessController::class, 'showInvoice'])->name('invoices.show');
    Route::post('all-invoices', [BillProcessController::class, 'allInvoices'])->name('invoices.all');
    Route::post('bill-process/find', [BillProcessController::class,'findBills'])->name('bill-process.find');
    Route::get('bill-posting-unposting', [ReportController::class, 'postingUnpostingBill'])->name('post-unpost-bill');
    Route::get('bill-proccess-view/{id}', [BillProcessController::class, 'showBillView'])->name('bill.process.view');

    Route::get('bill-process-unposted', [BillProcessController::class, 'billProcessUnpostedForm'])->name('bill-process-unposted');
    Route::post('bill-process-unposted/find', [BillProcessController::class,'findBillsUnposted'])->name('bill-process-unposted.find');
    Route::post('bill-proccess-single-post', [BillProcessController::class, 'singleBillProcess'])->name('single.bill.process');
    Route::post('bill-proccess-pdf-unposted', [BillProcessController::class, 'billProcessPdfUnposted'])->name('bill-process-pdf-unposted');


    Route::get('vat-challan-list', [BillProcessController::class, 'vatChallanList'])->name('bill-process.vat-challan-list');
    Route::get('vat-challan-generate', [BillProcessController::class, 'vatChallanGenerate'])->name('bill-process.vat-challan-generate');
    Route::post('vat-challan-store', [BillProcessController::class, 'vatChallanStore'])->name('bill-process.vat-challan-store');
    Route::get('vat-challan-view/{challanRefNo}', [BillProcessController::class, 'vatChallanView'])->name('bill-process.vat-challan-view');
    Route::get('vat-challan-view-pdf/{challanRefNo}', [BillProcessController::class, 'vatChallanViewPdf'])->name('bill-process.vat-challan-view-pdf');


    //groupby invoice
    Route::get('/invoices/grouped', [BillProcessController::class, 'showGrouped'])->name('invoices.grouped');
    Route::post('invoices/all', [BillProcessController::class, 'invoicesAllGroupbywise'])->name('all.invoices.groupbywise');
    Route::get('invoices/all/show', [BillProcessController::class, 'invoicesAllGroupbywiseshow'])->name('all.invoices.groupbywise.allshow');
    Route::get('bill-pre-invoice/{id}', [BillProcessController::class, 'preInvoice'])->name('unposting.invoice');
    Route::get('duplicate-invoice', [BillProcessController::class, 'duplicateInvoice'])->name('duplicate.invoice');
    Route::get('duplicate-invoice-view', [BillProcessController::class, 'duplicateInvoiceView'])->name('duplicate.invoice.view');
    Route::get('set-invoice-print-flag/{invoiceNo}', [BillProcessController::class, 'setPrintFlag'])->name('invoice.print.flag');
    Route::get('set-invoice-print-count/{invoiceNo}', [BillProcessController::class, 'setPrintCount'])->name('invoice.print.count');


    Route::post('invoice-pdf/{type}', [BillProcessController::class, 'invoicePdf'])->name('invoice-pdf');
    Route::post('invoice-pdf-duplicate/{type}', [BillProcessController::class, 'invoicePdfDuplicate'])->name('invoice-pdf-duplicate');
    Route::post('invoice-pdf-pre/{type}', [BillProcessController::class, 'invoicePdfPre'])->name('invoice-pdf-pre');


    Route::get('/profile', [UserController::class, 'showProfile'])->name('profile');
    Route::post('/profile/update', [UserController::class, 'updateProfile'])->name('profile.update');
    Route::post('/profile/changePassword', [UserController::class, 'changePassword'])->name('profile.changePassword');

    // Check customer
    Route::get('checkAccountCustomer/{id}/{autoAcNo}', [CustomerController::class, 'checkAccountCustomer'])->name('check.account.customer');
    Route::post('add-new-attention', [CustomerController::class, 'addNewAttention'])->name('add-new-attention');
    Route::get('get-attention-list/{autoAC}', [CustomerController::class, 'getAttentionList'])->name('get-attention-list');

    // Customer name fixing
    Route::get('customer-name-fixing', [CustomerController::class, 'customerNameFixing'])->name('customer-name-fixing');
    Route::post('customer-name-fixing-update', [CustomerController::class, 'customerNameFixingUpdate'])->name('customer-name-fixing-update');


    Route::get('report/customer-bill-summary', [ReportController::class, 'customerBillSummary'])->name('report.customer-bill-summary');
    Route::get('report/customer-wise-bill', [ReportController::class, 'customerWiseBill'])->name('report.customer-wise-bill');
    Route::get('report/customer-collection-bill-summary', [ReportController::class, 'customerCollectionBillSummary'])->name('report.customer-collection-bill-summary');
    Route::get('report/customer-outstanding-ageing-bill', [ReportController::class, 'customerOutstandingAgeingBill'])->name('report.customer-outstanding-ageing-bill');
    Route::get('report/customer-outstanding-ageing-bill-contact', [ReportController::class, 'customerOutstandingAgeingBillContact'])->name('report.customer-outstanding-ageing-bill-contact');
    Route::get('report/customer-outstanding-ageing-bill-dept', [ReportController::class, 'customerOutstandingAgeingBillDept'])->name('report.customer-outstanding-ageing-bill-dept');
    Route::get('report/customer-bill-outstanding', [ReportController::class, 'customerBillOutstanding'])->name('report.customer-bill-outstanding');
    Route::get('report/dept-wise-monthly-sales', [ReportController::class, 'deptWiseMonthlySales'])->name('report.dept-wise-monthly-sales');
    Route::get('report/customer-due-report', [ReportController::class, 'customerDueReport'])->name('report.customer-due-report');
    Route::get('report/customer-ledger', [ReportController::class, 'customerLedger'])->name('report.customer-ledger');
    Route::get('report/process-bill-report', [ReportController::class, 'processBillReport'])->name('report.process-bill-report');
    Route::get('report/process-bill-report-view/{processNo}', [ReportController::class, 'processBillReportView'])->name('report.process-bill-report.view');
    Route::get('report/process-bill-report-pdf/{processNo}', [ReportController::class, 'processBillReportPdf'])->name('process-bill-report-pdf');

    Route::get('report/customer-bill-particular', [ReportController::class, 'customerBillParticular'])->name('report.customer-bill-particular');
    Route::post('customer-bill-particular/export/{type}', [ReportController::class, 'customerBillParticularExport'])->name('customer-bill-particular.export');

    Route::get('customer-bill-summary/export', [ReportController::class, 'CustomerBillSummaryExport'])->name('customer-bill-summary.export');
    Route::get('customer-wise-bill-NA/export', [ReportController::class, 'customerWiseBillExport333'])->name('customer-wise-bill-na.export');
    // Route::get('customer-collection-bill/export', [ReportController::class, 'customerCollectionBillExport'])->name('customer-collection-bill.export');

    Route::post('customer-wise-bill/export/{type}', [ReportController::class, 'customerWiseBillExport'])->name('customer-wise-bill.export');
    Route::post('customer-collection-summary/export/{type}', [ReportController::class, 'customerCollectionSummaryExport'])->name('customer-collection-summary.export');

    // Bill revision history
    Route::get('report/bill-revision-history', [ReportController::class, 'billRevisionHistory'])->name('report.bill-revision-history');

    // Bill increasing warning report
    Route::get('report/bill-increase-warning-report', [ReportController::class, 'billIncreaseWarningReport'])->name('report.bill-increase-warning-report');
    Route::post('bill-increase-warning-report/export/{type}', [ReportController::class, 'billIncreaseWarningReportExport'])->name('bill-increase-warning-report.export');
    Route::get('report/bill-increase-warning-count/{date}', [ReportController::class, 'billIncreaseWarningCount'])->name('report.bill-increase-warning-count');

    // Collection & Receive
    Route::resource('collection', CollectionController::class);
    Route::get('collection-list', [CollectionController::class, 'collectionList'])->name('collection.index');
    // Route::get('collection/create/{id}', [CollectionController::class, 'create'])->name('coll.create');
    Route::get('collection-entry', [CollectionController::class, 'collEntry'])->name('coll.entry');
    Route::get('user-bill-list-by-id/{id}', [CollectionController::class, 'collSearch'])->name('coll.search');
    Route::get('user-advance-amount/{id}', [CollectionController::class, 'userAdvanceAmount'])->name('user.advance.amount');
    Route::get('collection-ait-vds', [CollectionController::class, 'vdsList'])->name('collection.ait');
    Route::get('vds-upload-page/{id}', [CollectionController::class, 'vdsUploadPage'])->name('vds.upload.page');
    Route::post('vds-upload', [CollectionController::class, 'vdsUpload'])->name('vds.upload');


    //Advanced Collection
    Route::get('advanced-collection/index', [CollectionController::class, 'advancedCollection'])->name('advanced.collection');
    Route::get('advanced-collection/create', [CollectionController::class, 'advancedcollectionCreate'])->name('advanced.collection.create');
    Route::post('advanced-collection/store', [CollectionController::class, 'advancedcollectionStore'])->name('advanced.collection.store');
    Route::get('advanced-collection/view/{id}', [CollectionController::class, 'advancedcollectionView'])->name('advanced.collection.view');
    Route::get('advanced-collection/edit/{id}', [CollectionController::class, 'advancedcollectionEdit'])->name('advanced.collection.edit');
    Route::put('advanced-collection/update/{id}', [CollectionController::class, 'advancedcollectionUpdate'])->name('advanced.collection.update');
    Route::get('advanced-collection/delete/{id}', [CollectionController::class, 'advancedcollectionDelete'])->name('advanced.collection.delete');


    //VAT Setup
    Route::get('vat/index', [VatController::class, 'index'])->name('vat.index');
    Route::get('vat/create', [VatController::class, 'create'])->name('vat.create');
    Route::post('vat/store', [VatController::class, 'store'])->name('vat.store');
    Route::get('vat/view/{id}', [VatController::class, 'view'])->name('vat.view');
    Route::get('vat/edit/{id}', [VatController::class, 'edit'])->name('vat.edit');
    Route::put('vat/update/{id}', [VatController::class, 'update'])->name('vat.update');
    Route::get('vat/delete/{id}', [VatController::class, 'delete'])->name('vat.delete');


    //Customer Advanced Setup
    Route::get('advanced-customer/index', [CustomersAdvanced::class, 'index'])->name('advancedcustomer.index');
    Route::get('advanced-customer/create', [CustomersAdvanced::class, 'create'])->name('advancedcustomer.create');
    Route::post('advanced-customer/store', [CustomersAdvanced::class, 'store'])->name('advancedcustomer.store');
    Route::get('advanced-customer/edit/{id}', [CustomersAdvanced::class, 'edit'])->name('advancedcustomer.edit');
    Route::post('advanced-customer/update/{id}', [CustomersAdvanced::class, 'update'])->name('advancedcustomer.update');
    Route::get('advanced-customer/delete/{id}', [CustomersAdvanced::class, 'delete'])->name('advancedcustomer.delete');


    // Invoice
    Route::resource('instantInvoice', InstantInvoiceController::class);
    // Customer Bill Dashboard/Details
    Route::get('bill-dashboard', [BillDashboardController::class, 'index'])->name('bill.dashboard');
    Route::post('bill-dashboard', [BillDashboardController::class, 'billSearch'])->name('bill.dashboard.search');
    Route::get('bill-dashboard-address/{id}', [BillDashboardController::class, 'customerAddress'])->name('bill.dashboard.address');
    Route::get('bill-dashboard/show/{id}', [BillDashboardController::class, 'show'])->name('bill.details.show');


    // Cancellation
    Route::get('cancel-collection-preview', [CollectionController::class, 'cancelCollPreview'])->name('cancel.coll.preview');
    Route::get('cancel-collection-details/{id}', [CollectionController::class, 'cancelCollDetails'])->name('cancel.coll.details');

    Route::get('cancel-invoice-preview', [BillProcessController::class, 'cancelInvoicePreview'])->name('cancel.invoice.preview');
    Route::get('cancel-invoice-details/{invoiceNo}', [BillProcessController::class, 'cancelInvoiceDetails'])->name('cancel.invoice.details');


    // Permissions
    Route::get('permissions', [RoleController::class, 'permissionList'])->name('permissions.index');
    Route::get('permissions/create', [RoleController::class, 'permissionAdd'])->name('permissions.create');
    Route::post('permissions/store', [RoleController::class, 'storePermissions'])->name('permissions.store');
    Route::get('permissions/edit/{role_id}', [RoleController::class, 'permissionEdit'])->name('permissions.edit');
    Route::put('permissions/update/{role_id}', [RoleController::class, 'updatePermission'])->name('permissions.update');
    Route::delete('permissions/delete/{role_id}', [RoleController::class, 'deletePermission'])->name('permissions.delete');

    Route::post('page/getPagePermission', [RoleController::class, 'getPagePermission'])->name('page/getPagePermission');

    // Bill Subject
    Route::get('income-list-by-divcode/{code}', [BillSubjectController::class, 'incomeListByDivCode'])->name('subject.income.list');

    Route::get('coll-migration', [CollectionController::class, 'collMigration'])->name('coll.migration');
    Route::get('coll-migration-store', [CollectionController::class, 'collMigrationStore'])->name('coll.migration.store');
    Route::get('attentionStoreToChild', [CollectionController::class, 'attentionStoreToChild'])->name('attentionStoreToChild');
    Route::get('attentionStoreToBill', [CollectionController::class, 'attentionStoreToBill'])->name('attentionStoreToBill');
    Route::match(['get', 'post'], 'deleteVoucherRange', [CollectionController::class, 'deleteVoucherRange'])->name('deleteVoucherRange');


});


Route::middleware(['auth'])->group(function () {
    Route::get('uploadFilesToServer', [FixingController::class, 'uploadFilesToServer'])->name('uploadFilesToServer');
    Route::post('uploadFilesToServerStore', [FixingController::class, 'uploadFilesToServerStore'])->name('uploadFilesToServerStore');
    Route::post('uploadFilesToServerStorage', [FixingController::class, 'uploadFilesToServerStorage'])->name('uploadFilesToServerStorage');
    Route::post('runDatabaseQuery', [FixingController::class, 'runDatabaseQuery'])->name('runDatabaseQuery');
    Route::post('showDatabaseConnection', [FixingController::class, 'showDatabaseConnection'])->name('showDatabaseConnection');
    Route::post('downloadDB', [FixingController::class, 'downloadDB'])->name('downloadDB');
    Route::post('downloadDBTwo', [FixingController::class, 'downloadDBTwo'])->name('downloadDBTwo');
    Route::post('downloadStorageFolder', [FixingController::class, 'downloadStorageFolder'])->name('downloadStorageFolder');
    Route::post('downloadAppResRouteFolder', [FixingController::class, 'downloadAppResRouteFolder'])->name('downloadAppResRouteFolder');
    Route::post('deleteFileFromServer', [FixingController::class, 'deleteFileFromServer'])->name('deleteFileFromServer');
    Route::get('serverinfo', [FixingController::class, 'serverinfo'])->name('serverinfo');
});




