@if ($paginator->hasPages())
  <nav>
      <ul class="pagination mb-0">
          {{-- Previous Page Link --}}
          <li class="page-item {{ $paginator->onFirstPage() ? 'disabled' : '' }}">
              <a class="page-link" href="{{ $paginator->previousPageUrl() }}" rel="prev">Previous</a>
          </li>

          {{-- Page Numbers --}}
          @php
              $currentPage = $paginator->currentPage();
              $totalPages = $paginator->lastPage();
              $pagesToShow = 3;
              $start = max(1, $currentPage - floor($pagesToShow / 2));
              $end = min($totalPages, $currentPage + floor($pagesToShow / 2));

              if ($end - $start < $pagesToShow - 1) {
                  $start = max(1, $end - $pagesToShow + 1);
              }
          @endphp

          @if ($start > 1)
              <li class="page-item">
                  <a class="page-link" href="{{ $paginator->url(1) }}">1</a>
              </li>
              @if ($start > 2)
                  <li class="page-item disabled"><span class="page-link">...</span></li>
              @endif
          @endif

          @for ($i = $start; $i <= $end; $i++)
              <li class="page-item {{ $i == $currentPage ? 'active' : '' }}">
                  <a class="page-link" href="{{ $paginator->url($i) }}">{{ $i }}</a>
              </li>
          @endfor

          @if ($end < $totalPages)
              @if ($end < $totalPages - 1)
                  <li class="page-item disabled"><span class="page-link">...</span></li>
              @endif
              <li class="page-item">
                  <a class="page-link" href="{{ $paginator->url($totalPages) }}">{{ $totalPages }}</a>
              </li>
          @endif

          {{-- Next Page Link --}}
          <li class="page-item {{ !$paginator->hasMorePages() ? 'disabled' : '' }}">
              <a class="page-link" href="{{ $paginator->nextPageUrl() }}" rel="next">Next</a>
          </li>
      </ul>
  </nav>
@endif
