@extends('layouts.app')

@section('title')
    Users
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Manage Users</h4>
        </div>
        <div class="col-md-6 text-right">
            @can('Create User')
                <a href="{{ route('users.create') }}" class="btn btn-primary">Add New</a>
            @endcan
        </div>
    </div>

    <div class="row">
        <table id="datatable-buttons" class="table table-striped table-bordered" style="width:100%">
            <thead>
                <tr>
                    <th>Sl No</th>
                    <th>Emp ID</th>
                    <th>Name</th>
                    <th>E-mail</th>
                    <th>Phone</th>
                    <th>Role</th>
                    <th>Avatar</th>
                    <th>Created</th>
                    <th>Action</th>
                </tr>
            </thead>

            <tbody>
                @foreach ($users as $row)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $row->employee_id ? $row->employee_id : '-' }}</td>
                        <td>{{ $row->name }}</td>
                        <td>{{ $row->email }}</td>
                        <td>{{ $row->phone }}</td>
                        <td>
                            @if ($row->getRoleNames()->isEmpty())
                                -
                            @else
                                @foreach ($row->getRoleNames() as $role)
                                    <span class="badge badge-info" style="font-size: 13px;">{{ $role }}</span>
                                @endforeach
                            @endif
                        </td>
                        <td style="text-align: center">
                            @php
                                $avatarPath = 'storage/avatar/' . $row->avatar;
                            @endphp
                            <img class="" style="border-radius: 50%; border: 1.5px solid #fff"
                                src="{{ $row->avatar && file_exists(public_path($avatarPath)) ? asset($avatarPath) : asset('images/user.png') }}"
                                height="32px" width="32px" style="object-fit: cover;" alt="user-image"></td>
                        <td>{{ \Carbon\Carbon::parse($row->created_at)->format('d/m/Y') }}</td>
                        <td>
                            @if (!$row->getRoleNames()->isEmpty())
                                @can('Manage Role')
                                    {{-- <button type="button" class="btn btn-warning btn-sm update_permission" data-toggle="modal"
                                        data-user_id="{{ $row->id }}" data-target=".bs-example-modal-sm">
                                        Permissions
                                    </button> --}}
                                @endcan
                            @endif

                            @if ($row->id == 1 && auth()->id() == 1)
                                @can('Edit User')
                                    <a href="{{ route('users.edit', ['user' => $row->id]) }}"
                                        class="btn btn-success btn-sm">Edit</a>
                                @endcan
                            @endif

                            @if ($row->id != 1)
                                @can('Edit User')
                                    <a href="{{ route('users.edit', ['user' => $row->id]) }}"
                                        class="btn btn-success btn-sm">Edit</a>
                                @endcan

                                @can('Delete User')
                                    {{-- <form id="delete-form-{{ $row->id }}" class="d-inline"
                                        action="{{ route('users.destroy', $row->id) }}" method="POST">
                                        @csrf
                                        @method('DELETE')
                                        <a class="btn btn-danger btn-sm alert-btn text-light cursor-pointer">Delete</a>
                                    </form> --}}
                                @endcan
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <div class="modal fade bs-example-modal-sm" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title text-primary" id="myModalLabel2">Page Permission</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                            aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="row-fluid">
                            <div id="res_type"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        $(document).ready(function() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $(document).on('click', '.update_permission', function(e) {
                e.preventDefault();
                var user_id = $(this).data('user_id'); // Get the user ID from the data attribute
                let csrf = '{{ csrf_token() }}';

                $.ajax({
                    url: '{{ route('page/getPagePermission') }}',
                    method: 'POST',
                    data: {
                        id: user_id, // Pass the actual value
                        _token: csrf // Use the CSRF token you've defined
                    },
                    dataType: 'html',
                    success: function(result) {
                        $("#res_type").html(result);
                    }
                });
            });
        });
    </script>
@endsection
