@extends('layouts.app')
@section('title')
Upload Files
@endsection

@section('content')
    {{-- <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Upload Files</h4>
        </div>
    </div> --}}

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_content" style="padding:0">
                    <h4 class="text-primary mb-0">Upload Files</h4>
                    <form action="{{ route('uploadFilesToServerStore') }}" method="POST" enctype="multipart/form-data"
                        autocomplete="off">
                        @csrf

                        <div class="row">
                            <div class="col-md-4">
                                <label for="code">Security Code :</label>
                                <input type="text" id="code" class="form-control" name="code" required/>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <label for="path">Path : (app/Http/Test just like that)</label>
                                <input type="text" id="path" class="form-control" name="path" required/>
                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-4">
                                <label for="work_order">Files :</label>
                                <input type="file" id="work_order" name="work_order" class="form-control" required >
                                {{-- <input type="file" id="work_order" name="work_order[]" class="form-control" multiple required> --}}
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <br />
                                <a href="{{ route('uploadFilesToServer') }}" class="btn btn-info btnCancel">Cancel</a>
                                <button type="submit" id="btnSubmit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </form>
                    <br>
                    <hr>
                    <br>

                    <h4 class="text-primary mb-0">Upload Files To Storage Folder</h4>
                    <form action="{{ route('uploadFilesToServerStorage') }}" method="POST" enctype="multipart/form-data"
                        autocomplete="off">
                        @csrf

                        <div class="row">
                            <div class="col-md-4">
                                <label for="code">Security Code :</label>
                                <input type="text" id="code" class="form-control" name="code" required/>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <label for="path">Path(storage) : (items/subitems just like that)</label>
                                <input type="text" id="path" class="form-control" name="path" required/>
                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-4">
                                <label for="work_order">Files :</label>
                                <input type="file" id="work_order" name="work_order" class="form-control" required >
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <br />
                                <a href="{{ route('uploadFilesToServer') }}" class="btn btn-info btnCancel">Cancel</a>
                                <button type="submit" id="btnSubmit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </form>
                    <br>
                    <hr>
                    <br>

                    <h4 class="text-primary mb-0">Run Query</h4>
                    <form action="{{ route('runDatabaseQuery') }}" method="POST" enctype="multipart/form-data"
                        autocomplete="off">
                        @csrf

                        <div class="row">
                            <div class="col-md-4">
                                <label for="code">Security Code :</label>
                                <input type="text" id="code" class="form-control" name="code" required/>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <label for="path">Raw Query :</label><br>
                                <textarea name="queryline" id="queryline" cols="60" rows="7" class="form-control" required></textarea>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <br />
                                <a href="{{ route('uploadFilesToServer') }}" class="btn btn-info btnCancel">Cancel</a>
                                <button type="submit" id="btnSubmit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </form>
                    <br>
                    <hr>
                    <br>

                    <h4 class="text-primary mb-0">Show Database Connection</h4>
                    <form action="{{ route('showDatabaseConnection') }}" method="POST"
                        autocomplete="off">
                        @csrf

                        <div class="row">
                            <div class="col-md-4">
                                <label for="code">Security Code :</label>
                                <input type="text" id="code" class="form-control" name="code" required/>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <br />
                                <a href="{{ route('uploadFilesToServer') }}" class="btn btn-info btnCancel">Cancel</a>
                                <button type="submit" id="btnSubmit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </form>
                    <br>
                    <hr>
                    <br>

                    <h4 class="text-primary mb-0">Download Database (Table Read Method)</h4>
                    <form action="{{ route('downloadDB') }}" method="POST"
                        autocomplete="off">
                        @csrf

                        <div class="row">
                            <div class="col-md-4">
                                <label for="code">Security Code :</label>
                                <input type="text" id="code" class="form-control" name="code" required/>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <br />
                                <a href="{{ route('uploadFilesToServer') }}" class="btn btn-info btnCancel">Cancel</a>
                                <button type="submit" id="btnSubmit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </form>
                    </form>
                    <br>
                    <hr>
                    <br>

                    <h4 class="text-primary mb-0">Download Database (Mysqldump Method)</h4>
                    <form action="{{ route('downloadDBTwo') }}" method="POST"
                        autocomplete="off">
                        @csrf

                        <div class="row">
                            <div class="col-md-4">
                                <label for="code">Security Code :</label>
                                <input type="text" id="code" class="form-control" name="code" required/>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <br />
                                <a href="{{ route('uploadFilesToServer') }}" class="btn btn-info btnCancel">Cancel</a>
                                <button type="submit" id="btnSubmit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </form>
                    <br>
                    <hr>
                    <br>

                    <h4 class="text-primary mb-0">Download Storage Folder</h4>
                    <form action="{{ route('downloadStorageFolder') }}" method="POST"
                        autocomplete="off">
                        @csrf

                        <div class="row">
                            <div class="col-md-4">
                                <label for="code">Security Code :</label>
                                <input type="text" id="code" class="form-control" name="code" required/>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <br />
                                <a href="{{ route('uploadFilesToServer') }}" class="btn btn-info btnCancel">Cancel</a>
                                <button type="submit" id="btnSubmit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </form>
                    <br>
                    <hr>
                    <br>

                    <h4 class="text-primary mb-0">Download App/Resources/Route Folders</h4>
                    <form action="{{ route('downloadAppResRouteFolder') }}" method="POST"
                        autocomplete="off">
                        @csrf

                        <div class="row">
                            <div class="col-md-4">
                                <label for="code">Security Code :</label>
                                <input type="text" id="code" class="form-control" name="code" required/>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <br />
                                <a href="{{ route('uploadFilesToServer') }}" class="btn btn-info btnCancel">Cancel</a>
                                <button type="submit" id="btnSubmit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </form>
                    <br>
                    <hr>
                    <br>

                    <div class="d-none">
                        <h4 class="text-primary mb-0">Delete a File</h4>
                        <form action="{{ route('deleteFileFromServer') }}" method="POST" enctype="multipart/form-data"
                            autocomplete="off">
                            @csrf

                            <div class="row">
                                <div class="col-md-4">
                                    <label for="code">Security Code :</label>
                                    <input type="text" id="code" class="form-control" name="code" required/>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-4">
                                    <label for="path">Path & File : (app/Http/Test/abc.jpg just like that)</label>
                                    <input type="text" id="path" class="form-control" name="path" required/>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12">
                                    <br />
                                    <a href="{{ route('uploadFilesToServer') }}" class="btn btn-info btnCancel">Cancel</a>
                                    <button type="submit" id="btnSubmit" class="btn btn-primary">Submit</button>
                                </div>
                            </div>
                        </form>
                    </div>


                </div>
            </div>
        </div>
    </div>
    <style>
        form label {
            margin-bottom: 2px;
            margin-top: 8px;
        }
    </style>
@endsection
