@extends('layouts.app')

@section('title')
    Roles
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Manage Roles</h4>
        </div>
        <div class="col-md-6 text-right">
            <a class="btn btn-primary text-light cursor-pointer" data-url="{{ route('roles.create') }}" data-ajax-popup="true"
                data-title="Create Role" data-bs-toggle="tooltip" title="Create" data-original-title="Create">Add New</a>
        </div>
    </div>

    <div class="row">
        <table id="datatable-buttons" class="table table-striped table-bordered" style="width:100%">
            <thead>
                <tr>
                    <th>Sl No</th>
                    <th>Role Name</th>
                    <th>Action</th>
                </tr>
            </thead>

            <tbody>
                @foreach ($roles as $role)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $role->name }}</td>
                        <td>
                            <a href="{{ route('permissions.edit', $role->id) }}"
                                class="btn btn-warning btn-sm text-dark">Permissions</a>

                            <a class="btn btn-success btn-sm text-white cursor-pointer"
                                data-url="{{ route('roles.edit', $role->id) }}" data-ajax-popup="true"
                                data-title="Edit Role" data-bs-toggle="tooltip" title="Edit"
                                data-original-title="Edit">Edit</a>

                            <form id="delete-form-{{ $role->id }}" class="d-inline"
                                action="{{ route('roles.destroy', $role->id) }}" method="POST">
                                @csrf
                                @method('DELETE')
                                <a class="btn btn-danger btn-sm alert-btn text-white cursor-pointer">Delete</a>
                            </form>

                        </td>
                    </tr>
                @endforeach

            </tbody>
        </table>
    </div>
@endsection
