<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Billing Particulars</title>
</head>
<body>

    <div class="row mt-2">
        <div class="col-md-12">
            <div class="row">
                <div class="col-12 mb-2 heading-box" style="text-align: center; color:#000">
                    <p style="font-size: 20px !important;font-style:italic">SQUARE INFORMATIX LIMITED</p>
                    <p style="font-size: 17px !important;">ACCOUNTS DEPARTMENT</p>
                    <p style="font-size: 17px !important;">Billing Particulars for
                        {{ ($customer=='')? 'All Customer': $bills[0]->customer_name??'' }}
                        ({{ $status }})</p>
                </div>
            </div>

            <div class="date-stamp">Printing Date: {{date('d/m/Y')}}</div>
            <table class="table table-bordered invoice-table mt-1" style="width:100%">
                <thead>
                    <tr>
                        <th>Sl.</th>
                        <th>Bill No</th>
                        <th>Customer</th>
                        <th>Dept</th>
                        <th>Bill Subject</th>
                        <th>Particulars</th>
                        <th>Ref. No.</th>
                        <th>Ref. Date</th>
                        <th>Qty</th>
                        <th>Unit Price</th>
                        <th>VAT<br>Status</th>
                        <th>VAT</th>
                        <th>Date of Inst.</th>
                        <th>Billing<br>Type</th>
                        <th>Bill<br>Start Date</th>
                        <th>Yearly Inc.</th>
                        <th>Inc. Date</th>
                        <th>Bill<br>End Date</th>
                        <th>Bill<br>Group</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($bills as $bill)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>{{ $bill->bill_no }}</td>
                            <td style="width:120px;">{{ $bill->customer_name }} <br> ({{ $bill->customer_id }})</td>
                            <td>{{ $bill->billDivName }}</td>
                            <td style="width:80px;">
                                @php
                                    $string = $bill->billSubject->bill_subject ?? '';
                                    $formattedString = preg_replace('/([\/_])/', '$1 ', $string);
                                @endphp
                                {{ $formattedString }}
                            </td>
                            <td style="width:100px;">
                                @php
                                    $string = $bill->particulars;
                                    $formattedString = preg_replace('/([\/_])/', '$1 ', $string);
                                @endphp
                                {{ $formattedString }}
                            </td>
                            <td style="width:90px;">
                                @php
                                    $string = $bill->ref_no;
                                    $formattedString = preg_replace('/([\/_])/', '$1 ', $string);
                                @endphp
                                {{ $formattedString }}
                            </td>
                            <td  class="text-center" style="width:50px;">{{ $bill->ref_date }}</td>
                            <td class="text-right">{{ $bill->qty }}</td>
                            <td class="text-right">{{ priceFormat($bill->unit_price_vat) }}</td>
                            <td class="text-center">{{ ($bill->vat_status=='1')? 'Y':'N' }}</td>
                            <td class="text-right">{{ priceFormat($bill->vat_percent) }}</td>
                            <td class="text-center">{{ $bill->installation_date }}</td>
                            <td>{{ $bill->bill_type }}</td>
                            <td class="text-center">{{ $bill->start_date }}</td>
                            <td class="text-right">{{ priceFormat($bill->yearly_increase_percent) }}</td>
                            <td class="text-center">{{ $bill->increase_start_date }}</td>
                            <td class="text-center">{{ $bill->end_date }}</td>
                            <td class="text-center">{{ $bill->bill_group }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    <style>
        .x_content{
            font-family: arial !important;
            color:#000 !important;
            font-size:13px;
        }
        .table {
            width: 100%;
            margin-bottom: 1rem;
            color: #212529;
        }
        .invoice-table, .invoice-table th, .invoice-table td {
            border: 0.5px solid #000 !important;
            border-collapse: collapse !important;
            font-size: 12px !important;
        }
        .invoice-table th {
            text-align: left;
            background-color: white;
            color: black;
            font-weight: bold;
            padding:2px !important;
            text-align: center;
        }
        .invoice-table td {
            padding:2px 4px !important;
        }
        h1, h2, h3, h4, h5, h6, p, .black{
            color: #000 !important;
            font-size: 13px !important;
        }
        /* p{
            margin-bottom: 1px
        } */
        .text-right{
            text-align: right;
        }
        .text-center{
            text-align: center;
        }
.p-2 {
    padding: .5rem !important;
}
.mb-2, .my-2 {
    margin-bottom: .5rem !important;
}
.pl-3, .px-3 {
    padding-left: 1rem !important;
}
.pr-3, .px-3 {
    padding-right: 1rem !important;
}
.pb-2, .py-2 {
    padding-bottom: .5rem !important;
}
.pt-2, .py-2 {
    padding-top: .5rem !important;
}
.mb-0, .my-0 {
    margin-bottom: 0 !important;
}
.mt-1, .my-1 {
    margin-top: .25rem !important;
}
.mt-2, .my-2 {
    margin-top: .5rem !important;
}
.mt-3, .my-3 {
    margin-top: 1rem !important;
}
.d-inline-block {
    display: inline-block !important;
}
.border {
    border: 1px solid #b9b6b6 !important;
}
h1, h2, h3, h4, h5, h6, p, .black {
    color: #000 !important;
    font-size: 13px !important;
}
.h6, h6 {
    font-size: 1rem;
}
.h1, .h2, .h3, .h4, .h5, .h6, h1, h2, h3, h4, h5, h6 {
    margin-bottom: .5rem;
    font-weight: 500;
    line-height: 1.2;
}
h1, h2, h3, h4, h5, h6 {
    margin-top: 0;
    margin-bottom: .5rem;
}
p{
    margin-top: 0px;
    margin-bottom: 2px;
}
.row{
    width:100%;
    /* border:1px solid green; */
}
.col-md-6{
    width:50%;
}
.float-left{
    float: left;
}
.clearfix{
    clear: both;
}
.customer-tag{
    padding: 5px 8px;
}
.date-stamp{
    font-size: 14px;
}
    </style>

<style>
</style>
</body>
</html>
