@if($isSearch)
    <a href="{{ route('customer-collection-bill.export', ['customer' => $customer_id]) }}">Download Excel</a>
@endif

<select name="customer" id="customerSelect">
    <option value="">All Customers</option>
    @foreach($customers as $customer)
        <option value="{{ $customer->id }}" {{ request('customer') == $customer->id ? 'selected' : '' }}>
            {{ $customer->customer_name }}
        </option>
    @endforeach
</select>

<table id="customer-row">
    <thead>
        <tr>
            <th colspan="10" align="center" bgcolor="#112f6f" style="font-weight: bold; color: #ffffff;">Customer Collection Bill Summary</th>
        </tr>
        <tr>
            <th>Sl No</th>
            <th>Customer</th>
            <th>Collection Ref. No</th>
            <th>Collection Date</th>
            <th>Collection Mode</th>
            <th>Collection Amount</th>
            <th>VAT Deduction Amount</th>
            <th>TDS Amount</th>
            <th>Adjust Amount</th>
            <th>Total Collection Amount</th>
        </tr>
    </thead>

   <tbody>
        @foreach ($collections as $collection)
            <tr class="customer-row" data-customer="{{ $collection->customer ? $collection->customer->id : 'N/A' }}">
                <td>{{ $loop->iteration }}</td>
                <td>{{ $collection->customer ? $collection->customer->customer_name : 'N/A' }}</td>
                <td>{{ $collection->ref_no }}</td>
                <td>{{ $collection->coll_date }}</td>
                <td>{{ $collection->instrument_mode }}</td>
                <td>{{ $collection->received_amount }}</td>
                <td>{{ $collection->vat_amount }}</td>
                <td>{{ $collection->tds_amount }}</td>
                <td>{{ $collection->adjust_amount }}</td>
                <td>{{ $collection->total_coll_amount }}</td>
            </tr>
        @endforeach
    </tbody>
</table>

<script>
    // JavaScript to toggle visibility based on clicked customer
    document.querySelectorAll('.customer-row').forEach(function(row) {
        row.addEventListener('click', function() {
            var customerId = row.getAttribute('data-customer');
            if (customerId !== 'N/A') {
                document.querySelectorAll('.customer-row').forEach(function(r) {
                    if (r.getAttribute('data-customer') === customerId) {
                        r.style.display = 'table-row';
                    } else {
                        r.style.display = 'none';
                    }
                });
            }
        });
    });

    // JavaScript to handle search button click
    document.getElementById('customerSelect').addEventListener('change', function() {
        var customerId = this.value;
        if (customerId !== '') {
            window.location.href = "{{ route('customer-collection-bill.export') }}?customer=" + customerId;
        }
    });
</script>
