<table>
    <thead>
        <tr>
            <th colspan="7" align="center" bgcolor="#fff" style="font-weight: bold; color: #000;">Customer Bill
                Summary</th>
        </tr>
        <tr>
            <th style="font-weight: bold;">Customer ID</th>
            <th style="font-weight: bold;">Customer Name</th>
            <th style="font-weight: bold;">Total Bill</th>
            <th style="font-weight: bold;">Paid Invoice</th>
            <th style="font-weight: bold;">Unpaid Invoice</th>
            <th style="font-weight: bold;">Paid Amount</th>
            <th style="font-weight: bold;">Unpaid Amount</th>
        </tr>
    </thead>
    <tbody>
        @php
            $totalPaidAmount = 0;
            $totalUnpaidAmount = 0;
        @endphp
        @foreach ($data as $row)
            @php
                $totalPaidAmount += $row['paid_amount'];
                $totalUnpaidAmount += $row['unpaid_amount'];
            @endphp
            <tr>
                <td>{{ str_pad($row['customer_id'], 5, '0', STR_PAD_LEFT) }}</td>
                <td>{{ $row['customer_name'] }}</td>
                <td>{{ $row['total_bill'] }}</td>
                <td>{{ $row['paid_invoice'] }}</td>
                <td>{{ $row['unpaid_invoice'] }}</td>
                <td>{{ \App\Models\Settings::priceFormat($row['paid_amount']) }}</td>
                <td>{{ \App\Models\Settings::priceFormat($row['unpaid_amount']) }}</td>
            </tr>
        @endforeach
        <tr>
            <td colspan="5" style="text-align: center;"><b>Total:</b></td>
            <td><b>{{ \App\Models\Settings::priceFormat($totalPaidAmount) }}</b></td>
            <td><b>{{ \App\Models\Settings::priceFormat($totalUnpaidAmount) }}</b></td>
        </tr>
    </tbody>
</table>
