<table>
    <thead>
        <tr>
            <th>Sl.</th>
            <th>Ref. No.</th>
            <th>Ref. Date</th>
            <th>Customer</th>
            <th>Particulars</th>
            <th>Start Date</th>
            <th>End Date</th>
            <th>Increase Period (Month)</th>
            <th>Increase Date</th>
            <th>Increase %</th>
            {{-- <th>Old Bill No.</th> --}}
            <th>Bill No.</th>
            <th>Bill Group</th>
        </tr>
    </thead>
    <tbody>
        @foreach ($bills as $bill)
            <tr>
                <td>{{ $loop->iteration }}</td>
                <td>
                    @php
                        $formattedRef = preg_replace('/([\/_])/', '$1 ', $bill->ref_no);
                    @endphp
                    {{ $formattedRef }}
                </td>
                <td>{{ $bill->ref_date }}</td>
                <td>{{ $bill->customer_name }}</td>
                <td>
                    @php
                        $formattedParticulars = preg_replace('/([\/_])/', '$1 ', $bill->particulars);
                    @endphp
                    {{ $formattedParticulars }}
                </td>
                <td>{{ $bill->start_date }}</td>
                <td>{{ $bill->end_date }}</td>
                <td>{{ $bill->increase_period }}</td>
                <td>{{ $bill->increase_start_date }}</td>
                <td>
                    @php
                        $percent = trim($bill->yearly_increase_percent);
                    @endphp
                    {{ is_numeric($percent) ? number_format((float)$percent, 2) : '0.00' }} %
                </td>
                {{-- <td>{{ $bill->OLD_BILL_NO }}</td> --}}
                <td>{{ $bill->BILL_NO }}</td>
                <td>{{ $bill->bill_group }}</td>
            </tr>
        @endforeach
    </tbody>
</table>
