@extends('layouts.app')

{{-- @php
    $settings = App\Models\Settings::get_settings();
@endphp --}}

@section('title')
    Customer Wise Bill Outstanding
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Customer Wise Bill Outstanding</h4>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <div class="mt-2" id="multiCollapseExample1">
                <div class="card">
                    <div class="card-body">
                        <form id="reportForm" action="{{ route('report.customer-bill-outstanding') }}" method="GET">
                            <div class="row align-items-center justify-content-end">
                                <div class="col-md-12">
                                    <div class="row align-items-end">

                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="start_date">As on Date*</label>
                                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                                    <input type="text"
                                                        class="form-control has-feedback-left custom-datepicker"
                                                        name="start_date" id="start_date"
                                                        value="{{ request('start_date') }}" placeholder="dd/mm/yyyy"
                                                        autocomplete="off" required>
                                                    <span class="fa fa-calendar-o form-control-feedback left"
                                                        aria-hidden="true"></span>
                                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-5">
                                            <div class="form-group">
                                                <label for="customer_id">Customer*</label>
                                                <select id="customer_id" name="customer_id" class="form-control select2" required>
                                                    <option value="">--Select Customer--</option>
                                                    @foreach ($allCustomers as $row)
                                                    <option value="{{$row->id}}" {{ (request('customer_id') == $row->id ? 'selected' : '') }}>{{$row->customer_name}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-1 px-1">
                                            <div class="form-group">
                                                <button class="btn btn-primary btn-block process-btn" type="submit"
                                                    name="search_buttonn">
                                                    Filter
                                                </button>
                                            </div>
                                        </div>

                                        <div class="col-md-1 px-1">
                                            <div class="form-group">
                                                <a href="{{ route('report.customer-bill-outstanding') }}"
                                                    class="btn btn-danger btn-block">
                                                    Clear
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <br>



    @if(isset($result) && count($result) > 0)

    <div class="row">

        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div id="printableArea" class="x_content" style="padding:0;overflow:auto">
                    <div style="color: #000;text-align: right;position: absolute;width: 100%;">Printing Date: {{date('d/m/Y')}}</div>
                    <div class="row">
                        <div class="col-12 mb-2 heading-box" style="text-align: center; color:#000">
                            <h3 style="font-size: 20px;font-style:italic">SQUARE INFORMATIX LIMITED</h3>
                            <h3 style="font-size: 18px;">ACCOUNTS DEPARTMENT</h3>
                            <h3 style="font-size: 18px;">CUSTOMER WISE BILL OUTSTANDING</h3>
                            <h3 style="font-size: 16px;">As on: {{ request('start_date') }}</h3>
                        </div>
                    </div>
                    <div class="row">

                        <table class="table table-bordered tbl-result">
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Customer</th>
                                    <th>Invoice<br>No</th>
                                    <th>Bill<br>Date</th>
                                    <th>Bill<br>Type</th>
                                    <th>Subject</th>
                                    <th class="text-right">Net Bill<br>Amount</th>
                                    <th class="text-right">Collection<br>Amount</th>
                                    <th class="text-right">Adjustment<br>Amount</th>
                                    <th class="text-right">Outstanding<br>Amount</th>
                                    <th class="text-right">Outstanding<br>(Row)</th>
                                </tr>
                            </thead>
                            <tbody>
                                @php
                                    $grand_total_amount_vat = 0;
                                    $grand_total_collection_amount = 0;
                                    $grand_total_adjustment = 0;
                                    $grand_total_due = 0;
                                    $grand_total_due_row = 0;
                                    $sl = 1;
                                @endphp
                                @foreach ($result as $customerId => $data)
                                    @foreach ($data['rows'] as $row)

                                        @php
                                            $dueCalc = $row->total_amount_vat - ($row->total_collection_amount + $row->total_adjustment)
                                        @endphp
                                        <tr>
                                            <td class="text-right">{{ $sl }}</td>
                                            <td>{{ $data['customer_name'] }}</td>
                                            <td>{{ $row->invoice_no }}</td>
                                            <td>{{ $row->invoice_date }}</td>
                                            <td>{{ $row->billDivName }}</td>
                                            <td>{{ $row->bill_subject_desc }}</td>
                                            <td class="text-right">{{ priceFormat($row->total_amount_vat) }}</td>
                                            <td class="text-right">{{ priceFormat($row->total_collection_amount) }}</td>
                                            <td class="text-right">{{ priceFormat($row->total_adjustment) }}</td>
                                            <td class="text-right">{{ priceFormat($dueCalc) }}</td>
                                            <td class="text-right">{{ priceFormat($row->total_due) }}</td>
                                        </tr>
                                        @php
                                            $sl = $sl + 1;
                                            $grand_total_amount_vat = $grand_total_amount_vat + $row->total_amount_vat;
                                            $grand_total_collection_amount = $grand_total_collection_amount + $row->total_collection_amount;
                                            $grand_total_adjustment = $grand_total_adjustment + $row->total_adjustment;
                                            $grand_total_due = $grand_total_due + $dueCalc;
                                            $grand_total_due_row = $grand_total_due_row + $row->total_due;
                                        @endphp
                                    @endforeach
                                    <tr class="final-row">
                                        <td class="text-right" colspan="6" style="padding-right10px">Total: </td>
                                        <td class="text-right">{{ priceFormat($grand_total_amount_vat) }}</td>
                                        <td class="text-right">{{ priceFormat($grand_total_collection_amount) }}</td>
                                        <td class="text-right">{{ priceFormat($grand_total_adjustment) }}</td>
                                        <td class="text-right">{{ priceFormat($grand_total_due) }}</td>
                                        <td class="text-right">{{ priceFormat($grand_total_due_row) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

    </div>

    <style>
        .tbl-result th, .tbl-result td{
            font-size: 12px;
            padding: 3px 2px !important;
            border-color: #000 !important;
        }
        .tbl-result th{
            color: #000;
            background-color: #fff;
            text-align: left;
        }
        .tbl-result td, .tbl-result th{
            text-align: left;
        }
        .heading-box h3{
            margin: 4px;
        }
        .final-row td{
            font-weight: bold;
        }
    </style>

@endif



@endsection

@section('script')
    <script>
        function saveAsPDF() {
            $('table').addClass('custom-print');
            $('.print-header').removeClass('d-none');

            var printableArea = $('#printableArea').html();

            var opt = {
                margin: 0.1,
                filename: "Customer-wise-outstanding-ageing-(all)",
                image: {
                    type: 'jpeg',
                    quality: 0.8
                },
                html2canvas: {
                    scale: 3,
                    dpi: 150,
                    letterRendering: true
                },
                jsPDF: {
                    unit: 'in',
                    format: 'legal',
                    orientation: 'landscape'
                }
            };
            html2pdf().set(opt).from(printableArea).save();

            setTimeout(() => {
                $('table').removeClass('custom-print');
                $('.print-header').addClass('d-none');
            }, 100);
        }
    </script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.0/xlsx.full.min.js"></script>

    <script>
        function saveAsExcel() {
            var table = document.querySelector('table');

            var workbook = XLSX.utils.book_new();
            var worksheet = XLSX.utils.aoa_to_sheet([
                ["SQUARE INFORMATIX LIMITED"]
            ]);

            worksheet["A2"] = { v: "ACCOUNTS DEPARTMENT" };
            worksheet["A3"] = { v: "CUSTOMER WISE OUTSTANDING AGEING (ALL)" };
            worksheet["A4"] = { v: "As on: {{ request('start_date') }}" };
            worksheet["A5"] = { v: "Printing Date: {{ date('d/m/Y') }}" };

            var tableCols = table.querySelectorAll('th').length;
            var merge = [{
                s: {
                    r: 0,
                    c: 0
                },
                e: {
                    r: 0,
                    c: tableCols - 1
                }
            }];
            if (!worksheet['!merges']) worksheet['!merges'] = [];
            worksheet['!merges'] = worksheet['!merges'].concat(merge);

            var headingCell = worksheet['A1'];
            headingCell.s = {
                fill: {
                    fgColor: {
                        rgb: "112f6f"
                    }
                },
                font: {
                    bold: true,
                    color: {
                        rgb: "FFFFFF"
                    }
                },
                alignment: {
                    horizontal: "center",
                    vertical: "center"
                }
            };

            XLSX.utils.sheet_add_dom(worksheet, table, {
                origin: 'A6',
                raw: true
            });

            var columnWidths = [];
            table.querySelectorAll('tr').forEach(function(row) {
                row.querySelectorAll('td, th').forEach(function(cell, columnIndex) {
                    var cellContent = cell.textContent || '';
                    var cellWidth = cellContent.length + 2;
                    if (!columnWidths[columnIndex] || cellWidth > columnWidths[columnIndex]) {
                        columnWidths[columnIndex] = cellWidth;
                    }
                });
            });
            worksheet['!cols'] = columnWidths.map(function(width) {
                return {
                    width: width
                };
            });

            XLSX.utils.book_append_sheet(workbook, worksheet, "Sheet1");

            var excelFile = XLSX.write(workbook, {
                bookType: 'xlsx',
                type: 'binary'
            });

            function s2ab(s) {
                var buf = new ArrayBuffer(s.length);
                var view = new Uint8Array(buf);
                for (var i = 0; i < s.length; i++) view[i] = s.charCodeAt(i) & 0xFF;
                return buf;
            }
            var blob = new Blob([s2ab(excelFile)], {
                type: "application/octet-stream"
            });
            var link = document.createElement('a');
            link.href = URL.createObjectURL(blob);
            link.download = "Customer Wise Outstanding Ageing.xlsx";
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
        }
    </script>

    <script>
        $(document).ready(function () {
            $(".custom-datepicker2").each(function () {
                $(this).datepicker({
                    format: "mm/yyyy",
                    startView: "months",
                    minViewMode: "months",
                    autoclose: true,
                    templates: {
                        leftArrow: '<i class="fa fa-chevron-left"></i>',
                        rightArrow: '<i class="fa fa-chevron-right"></i>',
                    },
                });
            });
        });
    </script>


    <script>
        $('#customer_id').select2({
            placeholder: "--Select Customer--",
            allowClear: true
        });
    </script>
    <script>
        $('.process-btn').click(function () {
            const form = $('#reportForm')[0];
            if (!form.checkValidity()) {
                form.reportValidity();
                return;
            }
            $('.ajaxLoaderFormLoad').show();
            form.submit();
        });
    </script>

@endsection

