@extends('layouts.app')

@php
    $settings = App\Models\Settings::get_settings();
@endphp

@section('title')
    Customer Due Report
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Customer Due Report</h4>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <div class="mt-2" id="multiCollapseExample1">
                <div class="card">
                    <div class="card-body">
                        <form id="reportForm" action="{{ route('report.customer-due-report') }}" method="GET">
                            <div class="row align-items-center justify-content-end">
                                <div class="col-md-12">
                                    <div class="row align-items-end">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="start_date">Start Date</label>
                                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                                    <input type="text"
                                                        class="form-control has-feedback-left custom-datepicker"
                                                        name="start_date" id="start_date"
                                                        value="{{ request('start_date') }}" placeholder="dd/mm/yyyy"
                                                        autocomplete="off">
                                                    <span class="fa fa-calendar-o form-control-feedback left"
                                                        aria-hidden="true"></span>
                                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="end_date">End Date</label>
                                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                                    <input type="text"
                                                        class="form-control has-feedback-left custom-datepicker"
                                                        name="end_date" id="end_date" value="{{ request('end_date') }}"
                                                        placeholder="dd/mm/yyyy" autocomplete="off">
                                                    <span class="fa fa-calendar-o form-control-feedback left"
                                                        aria-hidden="true"></span>
                                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="customer" class="form-label">Customer*</label>
                                                <select name="customer" id="customer" class="form-control select2" required>
                                                    <option value="">Select customer</option>
                                                    @foreach ($customers as $customer)
                                                        <option value="{{ $customer->id }}"
                                                            {{ request('customer') == $customer->id ? 'selected' : '' }}>
                                                            {{ $customer->customer_name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                        <div class="col-md-1 px-1">
                                            <div class="form-group">
                                                <button class="btn btn-primary btn-block process-btn" type="submit"
                                                    name="search_buttonn">
                                                    Filter
                                                </button>
                                            </div>
                                        </div>

                                        <div class="col-md-1 px-1">
                                            <div class="form-group">
                                                <a href="{{ route('report.customer-due-report') }}"
                                                    class="btn btn-danger btn-block">
                                                    Clear
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <br>

    @if(request('customer')!='')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h6 class="text-primary mb-0"></h6>
        </div>
        <div class="col-md-6 text-right">
            <button class="btn btn-warning" onclick="saveAsPDF()">
                <i class="fa fa-print" aria-hidden="true"></i> Print</button>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_content" style="padding:0" id="printableArea">
                    <div class="row d-flex align-items-center">
                        <div class="col-6">
                        </div>
                        <div class="col-6 d-flex justify-content-end">
                            <p class="mb-1"><strong class="text-dark">Printed Date:</strong>
                                {{ date('d/m/Y') }}</p>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12 mb-2 heading-box" style="text-align: center; color:#000">
                            <p style="font-size: 20px !important;font-style:italic">SQUARE INFORMATIX LIMITED</p>
                            <p style="font-size: 18px !important;">ACCOUNTS DEPARTMENT</p>
                            <p style="font-size: 18px !important;">DUE REPORT</p>
                            {{-- <p style="font-size: 16px !important;">{{$dateRange}}</p> --}}
                        </div>
                    </div>

                    <div class="row" style="margin-top: 60px;">
                        <div class="col-md-6">
                            <h4 style="font-weight:bold;font-size:15px !important;">
                                Customer: {{ $customerInfo ? $customerInfo->customer_name : '' }}</h4>
                            <p class="mb-1">Address: {{ $customerInfo ? $customerInfo->address : '' }}</p>
                            <p class="mb-1">Phone: {{ $customerInfo ? $customerInfo->phone : '' }}</p>
                            <p class="mb-1">BIN: {{ $customerInfo ? $customerInfo->bin_no : '' }}</p>
                        </div>
                        @if(request('start_date')!='')
                        <div class="col-md-6 text-right">
                            <p class="mb-1"><strong class="text-primary">From Date:</strong>
                                {{ request('start_date') }}</p>
                            <p class="mb-1"><strong class="text-primary">To Date:</strong>
                                {{ (request('end_date')!='')? request('end_date'): date('d/m/Y') }}</p>
                        </div>
                        @endif
                    </div>
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <table class="table table-bordered mt-1 invoice-table">
                                <thead>
                                    <tr>
                                        <th class="text-center">Invoice No</th>
                                        <th class="text-center">Invoice Date</th>
                                        <th class="text-center">Due Amount (in {{ $currency }})</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @if(count($bills)>0)
                                    @foreach ($bills as $bill)
                                    <tr>
                                        <td class="text-center">{{ $bill->invoice_no }}</td>
                                        <td class="text-center">{{ $bill->invoice_date }}</td>
                                        <td class="text-right" style="padding-right:20px !important;">
                                            {{ \App\Models\Settings::priceFormat($bill->total_due) }}
                                        </td>
                                    </tr>
                                    @endforeach
                                    <tr>
                                        <td colspan="2" class="text-right"><b>Total :</b>&nbsp;&nbsp;&nbsp;</td>
                                        <td class="text-right" style="padding-right:20px !important;">
                                            <b>{{ \App\Models\Settings::priceFormat($totalDue) }}</b>
                                        </td>
                                    </tr>
                                    @else
                                    <tr>
                                        <td colspan="3" class="text-center">No dues found</td>
                                    </tr>
                                    @endif
                                </tbody>
                            </table>
                            <p><strong> Due Total (In Word):
                            </strong>{{ ucwords(\App\Models\Settings::convertToWords((int)$totalDue)) . ' ' . $currency }}
                            Only</p>
                        </div>
                    </div>
                    <div class="row" style="margin-top: 100px;">
                        <div class="col-md-12">
                            <p style="display: inline-block; margin-left: 20px;">
                                <b>........................................</b>
                                </br>
                                <b>Authorized Signature</b>
                            </p>
                            <p style="display: inline-block; margin-right: 20px; float: right;">
                                <b>........................................</b>
                                <br>
                                <b>Authorized Signature</b>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endif

    <style>
        .x_content{
            font-family: arial !important;
            color:#000 !important;
            font-size:13px;
        }
        .invoice-table, .invoice-table th, .invoice-table td{
            border-collapse: collapse !important;
            font-size:13px !important;
        }
        .invoice-table th {
            background-color: white;
            color: black;
            font-weight: bold;
            border: 1px solid #000 !important;
            border-bottom: 1px solid #000 !important;
            padding:2px !important;
        }
        .invoice-table td {
            border: 1px solid #000 !important;
            border-top: 1px solid #000 !important;
            padding:2px !important;
        }
        h1, h2, h3, h4, h5, h6, p, .black{
            color: #000 !important;
            /* font-size: 13px !important; */
        }
        p{
            margin-bottom: 1px;
            font-size: 13px;
        }
    </style>


@endsection

@section('script')
    <script>
        function saveAsPDF() {
            $('table').addClass('custom-print');
            $('.print-header').removeClass('d-none');

            var printableArea = $('#printableArea').html();

            var opt = {
                margin: 0.3,
                filename: "Customer-Due-Report-{{date('Y-m-d')}}",
                image: {
                    type: 'jpeg',
                    quality: 0.8
                },
                html2canvas: {
                    scale: 3,
                    dpi: 150,
                    letterRendering: true
                },
                jsPDF: {
                    unit: 'in',
                    format: 'A4'
                }
            };
            html2pdf().set(opt).from(printableArea).save();

            setTimeout(() => {
                $('table').removeClass('custom-print');
                $('.print-header').addClass('d-none');
            }, 100);
        }
    </script>
    <script>
        $('.process-btn').click(function () {
            const form = $('#reportForm')[0];
            if (!form.checkValidity()) {
                form.reportValidity();
                return;
            }
            $('.ajaxLoaderFormLoad').show();
            form.submit();
        });
    </script>
@endsection
