<div class="col-md-3 left_col menu_fixed">
    <div class="left_col scroll-view">
        <script>
            @if (!empty($settings['company_logo_light']))
                const logoUrl = "{{ asset('storage/logo/' . $settings['company_logo_light']) }}";
            @else
                const logoUrl = "{{ asset('images/logo_placeholder.png') }}";
            @endif

            @if (!empty($settings['company_favicon']))
                const faviconUrl = "{{ asset('storage/logo/' . $settings['company_favicon']) }}";
            @else
                const faviconUrl = "{{ asset('images/logo_placeholder.png') }}";
            @endif
        </script>

        <div class="navbar nav_title" style="border: 0;">
            <a href="{{ route('home') }}" class="site_title"><img width="95%" height="100%" style="object-fit: contain;"
                    src="{{ !empty($settings['company_logo_light']) ? asset('storage/logo/' . $settings['company_logo_light']) : asset('images/logo_placeholder.png') }}"
                    alt="logo"></a>
        </div>

        <div class="clearfix"></div>

        <!-- sidebar menu -->
        <div id="sidebar-menu" class="main_menu_side hidden-print main_menu">
            <div class="menu_section">
                <ul class="nav side-menu">
                    <li class="{{ request()->routeIs('dashboard') || request()->routeIs('home') ? 'active' : '' }}"><a
                            href="{{ route('dashboard') }}"><i class="fa fa-home"
                                style="font-size: 20px;"></i>Dashboard</a></li>

                    @can('View Customer')
                        <li class="{{ request()->routeIs('customers.*') ? 'active' : '' }}"><a
                                href="{{ route('customers.index') }}"><i class="fa fa-users"></i>Customers</a>
                        </li>
                    @endcan

                    @canany(['Create Bill','View Bill','Proposal Info', 'Process Bill', 'Approve Department Bill', 'Edit Bill','Pending Bill','Rejected Bill'])
                        <li
                            class="{{ request()->routeIs('bills.*') || request()->routeIs('bill-process.*') ? 'active' : '' }}">
                            <a><i class="fa fa-money"></i>Bills <span class="fa fa-chevron-down"></span></a>
                            <ul class="nav child_menu"
                                style="{{ request()->routeIs('bills.*') || request()->routeIs('bill-process.*') ? 'display: block;' : '' }}">
                                @can('Approve Department Bill')
                                <li><a href="{{ route('bills.awaiting') }}">Awaiting Bills</a></li>
                                @endcan
                                @can('Create Bill')
                                    <li><a href="{{ route('bills.create') }}">Create Proposal</a></li>
                                    {{-- <li><a href="{{ route('bill.dashboard') }}">Customer Bill Details</a></li> --}}
                                @endcan
                                @can('Proposal Info')
                                    <li><a href="{{ route('bills.proposal-info') }}">Proposal Info</a></li>
                                @endcan
                                @can('View Bill')
                                    <li><a href="{{ route('bills.index') }}">Bill Info</a></li>
                                    {{-- <li><a href="{{ route('bill.dashboard') }}">Customer Bill Details</a></li> --}}
                                @endcan
                                @can('Pending Bill')
                                    <li><a href="{{ route('bills.pending') }}">Pending Bills</a></li>
                                @endcan
                                @can('Rejected Bill')
                                    <li><a href="{{ route('bills.rejected') }}">Rejected Bills</a></li>
                                @endcan
                                @can('Process Bill')
                                    <li><a href="{{ route('bill-process.index') }}">Bill Process</a></li>
                                    <li><a href="{{ route('bill-process-unposted') }}">Unposted Bill Process</a></li>
                                    <li><a href="{{ route('bill-process.vat-challan-list') }}">Generate VAT Challan</a></li>
                                @endcan
                            </ul>
                        </li>

                    @endcanany


                    @can('Show Invoice')
                        <li class="{{ request()->routeIs('invoices.*') ? 'active' : '' }}"><a
                                href="{{ route('invoices.index') }}"><i class="fa fa-file-text"></i>Invoices</a>
                        </li>
                    @endcan

                    @can('Show Instant Invoice')
                        {{-- <li class="{{ request()->routeIs('instantInvoice.*') ? 'active' : '' }}"><a
                                href="{{ route('instantInvoice.index') }}"><i class="fa fa-pencil-square-o"
                                    aria-hidden="true"></i>Instant Invoice</a></li> --}}
                    @endcan

                    @can('View Collection')
                        <li class="{{ Route::is('collection.index', 'advanced.collection', 'advanced.collection.*', 'coll.entry','collection.ait','report.customer-due-report') ? 'active' : '' }}">
                            <a>
                                <i class="fa fa-usd" aria-hidden="true"></i>Collection
                                <span class="fa fa-chevron-down"></span>
                            </a>
                            <ul class="nav child_menu" style="{{ Route::is('collection.index', 'advanced.collection', 'advanced.collection.*', 'coll.entry') ? 'display: block;' : '' }}">
                                <li class="{{ Route::is('coll.entry') ? 'current-page' : '' }}">
                                    <a href="{{ route('coll.entry') }}">Collection & Receive</a>
                                </li>
                                <li class="{{ Route::is('collection.index') ? 'current-page' : '' }}">
                                    <a href="{{ route('collection.index') }}">Collection List</a>
                                </li>
                                <li class="{{ Route::is('collection.ait') ? 'current-page' : '' }}">
                                    <a href="{{ route('collection.ait') }}">AIT/VDS List</a>
                                </li>
                                <li class="{{ Route::is('advanced.collection', 'advanced.collection.*') ? 'current-page' : '' }}">
                                    <a href="{{ route('advanced.collection') }}">Advanced Collection</a>
                                </li>
                                <li class="{{ Route::is('advancedcustomer.index') ? 'current-page' : '' }}">
                                    <a href="{{ route('advancedcustomer.index') }}">Customer Advanced Setup</a>
                                </li>
                                <li class="{{ Route::is('report.customer-due-report', 'report.customer-due-report') ? 'current-page' : '' }}">
                                    <a href="{{ route('report.customer-due-report') }}">Customer Due Report</a>
                                </li>
                            </ul>
                        </li>
                    @endcan



                    @can('View Report')
                        <li>
                            <a><i class="fa fa-book" aria-hidden="true"></i>Reports <span
                                    class="fa fa-chevron-down"></span></a>
                            <ul class="nav child_menu">
                                {{-- <li><a href="{{ route('report.customer-bill-summary') }}">Customer Bill Summary</a></li> --}}
                                <li><a href="{{ route('report.customer-bill-particular') }}">Customer Bill Particulars</a></li>
                                <li><a href="{{ route('report.customer-wise-bill') }}">Customer Wise Bill</a></li>
                                <li><a href="{{ route('report.customer-collection-bill-summary') }}">Collection Register</a></li>
                                <li><a href="{{ route('report.customer-outstanding-ageing-bill') }}">Customer Outstanding Ageing-1</a></li>
                                <li><a href="{{ route('report.customer-outstanding-ageing-bill-contact') }}">Customer Outstanding Ageing Contact-2</a></li>
                                <li><a href="{{ route('report.customer-outstanding-ageing-bill-dept') }}">Customer Outstanding Ageing Dept-3</a></li>
                                <li><a href="{{ route('report.dept-wise-monthly-sales') }}">Dept. Wise Monthly Sales</a></li>
                                <li><a href="{{ route('report.process-bill-report') }}">Process Bill Report</a></li>
                                <div style="padding-left: 46px;color: #F1C40F;">EXTRA REPORT</div>
                                {{-- <li><a href="{{ route('report.customer-ledger') }}">Customer Ledger</a></li> --}}
                                <li><a href="{{ route('report.customer-bill-outstanding') }}">Customer Bill Outstanding</a></li>
                                <li class="{{ Route::is('report.endingBills') ? 'current-page' : '' }}">
                                    <a href="{{ route('report.endingBills') }}">Bill Ending Warning Report</a>
                                </li>
                                <li><a href="{{ route('report.bill-increase-warning-report') }}">Bill Increase Warning Report</a></li>

                            </ul>
                        </li>
                    @endcan

                    @can('Manage Cancellation')
                        <li class="{{ Route::is('cancel.invoice.preview', 'cancel.coll.preview') ? 'active' : '' }}">
                            <a>
                                <i class="fa fa-life-ring" aria-hidden="true"></i>Cancellation
                                <span class="fa fa-chevron-down"></span>
                            </a>
                            <ul class="nav child_menu" style="{{ Route::is('cancel.invoice.preview', 'cancel.coll.preview','active.inactive.bills') ? 'display: block;' : '' }}">
                                <li class="{{ Route::is('cancel.invoice.preview') ? 'current-page' : '' }}">
                                    <a href="{{ route('cancel.invoice.preview') }}">Invoice Cancellation</a>
                                </li>
                                <li class="{{ Route::is('cancel.coll.preview') ? 'current-page' : '' }}">
                                    <a href="{{ route('cancel.coll.preview') }}">Collection Cancellation</a>
                                </li>
                                <li class="{{ Route::is('active.inactive.bills') ? 'current-page' : '' }}">
                                    <a href="{{ route('active.inactive.bills') }}">Do Bill Active/Inactive</a>
                                </li>
                                <li class="{{ Route::is('billFixingFind') ? 'current-page' : '' }}">
                                    <a href="{{ route('billFixingFind') }}">Master Bill Edit</a>
                                </li>
                                <li class="{{ Route::is('report.bill-revision-history') ? 'current-page' : '' }}">
                                    <a href="{{ route('report.bill-revision-history') }}">Bill Revision History</a>
                                </li>
                            </ul>
                        </li>
                        <li class="{{ request()->routeIs('duplicate.invoice') ? 'active' : '' }}"><a
                                href="{{ route('duplicate.invoice') }}"><i class="fa fa-file-text"></i>Duplicate Invoices</a>
                        </li>
                    @endcan

                    @canany(['View User', 'Manage Role'])
                        <li
                            class="{{ request()->routeIs('users.*') || request()->routeIs('permissions.*') ? 'active' : '' }}">
                            <a><i class="fa fa-users"></i>User
                                Management <span class="fa fa-chevron-down"></span></a>
                            <ul class="nav child_menu"
                                style="{{ request()->routeIs('users.*') || request()->routeIs('permissions.*') ? 'display: block;' : '' }}">
                                @can('View User')
                                    <li><a href="{{ route('users.index') }}">Users</a></li>
                                @endcan
                                {{-- @can('Manage Role') --}}
                                    <li><a href="{{ route('roles.index') }}">Roles</a></li>
                                    <li><a href="{{ route('permissions.index') }}">Permissions</a></li>
                                {{-- @endcan --}}
                            </ul>
                        </li>
                    @endcanany

                    @can('Manage Setup')
                        <li><a><i class="fa fa-wrench" style="font-size: 20px;"></i> Setup <span
                                    class="fa fa-chevron-down"></span></a>
                            <ul class="nav child_menu">
                                {{-- <li><a href="{{ route('depository-bank.index') }}">Depository Bank Setup</a></li> --}}
                                <li><a href="{{ route('customer-bank.index') }}">Customer Bank Setup</a></li>
                                <li><a href="{{ route('gl-head.index') }}">GL Head Setup</a></li>
                                <li><a href="{{ route('bill-subject.index') }}">Bill Subject Setup</a></li>
                                {{-- <li><a href="{{ route('department.index') }}">Department Info Setup</a></li> --}}
                                <li><a href="{{ route('user-dept.index') }}">Department Head Setup</a></li>
                                <li><a href="{{ route('vat.index') }}">VAT Setup</a></li>
                                {{-- <li><a href="{{ route('configuration.index') }}">Configuration</a></li> --}}
                            </ul>
                        </li>
                    @endcan

                    @can('Manage Settings')
                        <li class="{{ request()->routeIs('settings.*') ? 'active' : '' }}"><a
                                href="{{ route('settings.index') }}"><i class="fa fa-gear"></i>Settings</a></li>
                    @endcan

                </ul>
            </div>

        </div>
        <!-- /sidebar menu -->

        <!-- /menu footer buttons -->
        {{-- <div class="sidebar-footer hidden-small">
            <a href="{{ route('settings.index') }}" class="{{ request()->routeIs('settings.index') ? 'active' : '' }}"
                data-toggle="tooltip" data-placement="top" title="Settings">
                <span class="glyphicon glyphicon-cog" aria-hidden="true"></span>
            </a>
            <a id="toggleFullscreen" class="cursor-pointer" data-toggle="tooltip" data-placement="top"
                title="FullScreen">
                <span class="glyphicon glyphicon-fullscreen" aria-hidden="true"></span>
            </a>
            <a href="{{ route('profile') }}" class="{{ request()->routeIs('profile') ? 'active' : '' }}"
                data-toggle="tooltip" data-placement="top" title="Profile">
                <span class="glyphicon glyphicon-user" aria-hidden="true"></span>
            </a>
            <a data-toggle="tooltip" data-placement="top" title="Logout" href="{{ route('logout') }}"
                onclick="event.preventDefault();
            document.getElementById('logout-form').submit();">
                <span class="glyphicon glyphicon-off" aria-hidden="true"></span>
            </a>
        </div> --}}
        <!-- /menu footer buttons -->
    </div>
</div>

<form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
    @csrf
</form>
