@extends('layouts.app')

@php
    $settings = App\Models\Settings::get_settings();
@endphp

@section('title')
    Invoice
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-4">
            <h4 class="text-primary mb-0">Invoice</h4>
        </div>
        <div class="col-md-4 text-center">
            @can('Print Invoice')
                <button class="btn btn-warning print-btn" onclick="saveAsPDF()"><i class="fa fa-print" aria-hidden="true"></i>
                    Print</button>
            @endcan
        </div>
        <div class="col-md-4 text-right">
            <a href="{{ route('invoices.index') }}" class="btn btn-primary">Invoices</a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_content" style="padding:0" id="printableArea1">
                    <div class="row d-flex align-items-center">
                        <div class="col-6">

                        </div>
                        <div class="col-6 d-flex justify-content-end">
                            <h6 class="text-right border d-inline-block px-3 py-2 mb-0">Customer Copy</h6>
                        </div>
                    </div>
                    <h3 class="text-center text-primary"> <strong>INVOICE</strong></h3>
                    <hr>
                    <div class="row">
                        <div class="col-md-6">
                            <h4 style="font-size: 1.5rem;" class="text-primary">
                                {{ $invoice->customer ? $invoice->customer->customer_name : '' }}</h4>
                            <p class="mb-2">{{ $invoice->customer ? $invoice->customer->address : '' }}</p>
                            <p class="mb-1">BIN - {{ $settings['company_bin'] }}</p>
                        </div>
                        <div class="col-md-6 text-right">
                            <p class="mb-1"><strong class="text-primary">Invoice No: </strong>{{ $invoice->invoice_no }}
                            </p>
                            <p class="mb-1"><strong class="text-primary">Invoice Date:</strong>
                                {{ $invoice->invoice_date }}</p>
                        </div>
                    </div>
                    <div class="row mt-2">
                        <div class="col-md-12">
                            <p><strong class="text-primary">Attention:</strong></p>
                            <table class="table table-bordered mt-3 invoice-table">
                                <thead>
                                    <tr>
                                        <th class="text-center">Sl.</th>
                                        <th class="text-center">Description</th>
                                        <th class="text-center">Amount (in {{ $settings['currency'] }})</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td class="text-center">1</td>
                                        <td>{{ $invoice->billSubject ? $invoice->billSubject->bill_subject : '-' }}</td>
                                        <td class="text-right">
                                            {{ \App\Models\Settings::priceFormat($invoice->total_amount) }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-center">2</td>
                                        <td>Value Added Tax</td>
                                        <td class="text-right">
                                            {{ \App\Models\Settings::priceFormat($invoice->vat_status == 1 ? ($invoice->total_amount * $invoice->vat_percent) / 100 : 0) }}
                                        </td>
                                    </tr>
                                    <tr>
                                        <td class="text-center">3</td>
                                        <td>Payment Terms:
                                            </br>
                                            100% of the invoice is payable by A/C
                                            </br>
                                            Payee Cheque/Pay Order favoring "{{ $settings['company_name'] }}"
                                            </br>
                                            BIN - {{ $settings['company_bin'] }} & TIN - {{ $settings['company_tin'] }}
                                        </td>
                                        <td></td>
                                    </tr>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="2" class="text-right"><strong>Total:</strong></td>
                                        <td class="text-right">
                                            <strong>{{ $invoice->total_amount_vat ? \App\Models\Settings::priceFormat($invoice->total_amount_vat) : '-' }}</strong>
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                            <p><strong class="text-primary"> Total (In Word):
                                </strong>{{ ucwords(\App\Models\Settings::convertToWords($invoice->total_amount_vat)) . ' ' . $settings['currency'] }}
                                Only</p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <p class="mb-2"><strong class="text-primary">For Bank Transfer:</strong></p>
                            <div class="border p-2">
                                <strong>Account Name:</strong> {{ $settings['bank_account_name'] }}
                                </br>
                                <strong>Account No:</strong> {{ $settings['bank_account_no'] }}
                                </br>
                                <strong>Bank Name:</strong> {{ $settings['bank_name'] }}
                                </br>
                                <strong>Branch Name:</strong> {{ $settings['branch_name'] }}
                                </br>
                                <strong>Routing No:</strong> {{ $settings['routing_no'] }}
                            </div>
                        </div>
                    </div>
                    <div class="row" style="margin-top: 90px;">
                        <div class="col-md-12">
                            <p style="display: inline-block; margin-left: 20px;">
                                <b>........................................</b>
                                </br>
                                <b>Authorized Signature</b>
                            </p>
                            <p style="display: inline-block; margin-right: 20px; float: right;">
                                <b>........................................</b>
                                <br>
                                <b>Authorized Signature</b>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_content" style="padding:0" id="printableArea2">
                    <div class="row d-flex align-items-center">
                        <div class="col-6">
                            <!-- <img height="60PX"
                                src="{{ !empty($settings['company_logo_dark']) ? asset('storage/logo/' . $settings['company_logo_dark']) : asset('images/logo_placeholder.png') }}"> -->
                        </div>
                        <div class="col-6 d-flex justify-content-end">
                            <h6 class="text-right border d-inline-block px-3 py-2 mb-0">Customer Copy</h6>
                        </div>
                    </div>
                    <h3 class="text-center text-primary"> <strong>INVOICE</strong></h3>
                    <hr>
                    <div class="row">
                        <div class="col-md-6">
                            <h4 style="font-size: 1.5rem;" class="text-primary">
                                {{ $invoice->customer ? $invoice->customer->customer_name : '' }}</h4>
                            <p class="mb-2">{{ $invoice->customer ? $invoice->customer->address : '' }}</p>
                            <p class="mb-1">BIN - {{ $settings['company_bin'] }}</p>
                        </div>
                        <div class="col-md-6 text-right">
                            <p class="mb-1"><strong class="text-primary">Invoice No: </strong>{{ $invoice->invoice_no }}
                            </p>
                            <p class="mb-1"><strong class="text-primary">Invoice Date:</strong>
                                {{ $invoice->invoice_date }}</p>
                        </div>
                    </div>
                    <div class="row mt-2">
                        <div class="col-md-12">
                            <p><strong class="text-primary">Subject: </strong>
                                {{ $invoice->billSubject ? $invoice->billSubject->bill_subject : '-' }}</p>
                            <table class="table table-bordered mt-3 invoice-table">
                                <thead>
                                    <tr>
                                        <th class="text-center">Sl.</th>
                                        <th class="text-center">Particulars</th>
                                        <th class="text-center">D.O.I.</th>
                                        <th class="text-center">Ref No</th>
                                        <th class="text-center">Ref Date</th>
                                        <th class="text-center">Qty</th>
                                        <th class="text-center">VAT</th>
                                        <th class="text-center">Unit Price</th>
                                        <th class="text-center">Total Unit Price Net</th>
                                        <th class="text-center">VAT Amount</th>
                                        <th class="text-center">Total Price</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td class="text-center">1</td>
                                        <td>{{ $invoice->particulars }}</td>
                                        <td>{{ $invoice->invoice_date }}</td>
                                        <td>{{ $invoice->ref_no }}</td>
                                        <td>{{ $invoice->ref_date }}</td>
                                        <td class="text-center">{{ $invoice->qty }}</td>
                                        <td class="text-center"> {{ $invoice->vat_status == 1 ? ($invoice->vat_percent ? $invoice->vat_percent : 0) : 0 }}%
                                        <td class="text-right">{{ \App\Models\Settings::priceFormat($invoice->unit_price_vat) }}</td>
                                        <td class="text-right">{{ \App\Models\Settings::priceFormat($invoice->total_amount) }}</td>
                                        <td class="text-right">{{ \App\Models\Settings::priceFormat(($invoice->total_amount * ($invoice->vat_status == 1 ? ($invoice->vat_percent ? $invoice->vat_percent : 0) : 0)) / 100) }}</td>
                                        </td>
                                        <td class="text-right">{{ \App\Models\Settings::priceFormat($invoice->total_amount_vat) }}</td>
                                    </tr>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td class="text-right" colspan="8"><strong>Total:</strong></td>
                                        <td class="text-right"> <strong>{{ \App\Models\Settings::priceFormat($invoice->total_amount) }}</strong>
                                        </td>
                                        <td class="text-right"> <strong> {{ \App\Models\Settings::priceFormat(($invoice->total_amount * ($invoice->vat_status == 1 ? ($invoice->vat_percent ? $invoice->vat_percent : 0) : 0)) / 100) }} </strong>
                                        </td>
                                        <td class="text-right"><strong>{{ \App\Models\Settings::priceFormat($invoice->total_amount_vat) }}</strong>
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                            <p class="mb-1"><strong class="text-primary"> Total (In Word):
                                </strong>{{ ucwords(\App\Models\Settings::convertToWords($invoice->total_amount_vat)) . ' ' . $settings['currency'] }}
                                Only</p>
                        </div>
                    </div>
                    <div class="row" style="margin-top: 80px;">
                        <div class="col-md-12">
                            <p style="display: inline-block; margin-left: 20px;">
                                <b>........................................</b>
                                </br>
                                <b>Authorized Signature</b>
                            </p>
                            <p style="display: inline-block; margin-right: 20px; float: right;">
                                <b>........................................</b>
                                <br>
                                <b>Authorized Signature</b>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<style>
    .invoice-table th {
        background-color: white;
        color: black;
        font-weight: bold;
    }
</style>

@endsection

@section('script')
    <script>
        function saveAsPDF() {
            $('.print-btn').html(
                '<span class="spinner-border spinner-border-sm mb-1" role="status" aria-hidden="true"></span> Downloading...'
            );
            $('table').addClass('custom-print');

            var printableArea1 = $('#printableArea1').html();
            var printableArea2 = $('#printableArea2').html();

            var element = printableArea1 + '<div style="page-break-before: always;"></div>' + printableArea2;

            var opt = {
                margin: 0.3,
                filename: "Invoice_{{ $invoice->invoice_no }}",
                image: {
                    type: 'jpeg',
                    quality: 0.8
                },
                html2canvas: {
                    scale: 3,
                    dpi: 150,
                    letterRendering: true
                },
                jsPDF: {
                    unit: 'in',
                    format: 'A4'
                }
            };
            html2pdf().set(opt).from(element).save().then(() => {
                $('.print-btn').html('<i class="fa fa-print" aria-hidden="true"></i> Print');
            })

            setTimeout(() => {
                $('table').removeClass('custom-print');
            }, 100);

        }
    </script>
@endsection
