
@extends('layouts.app')

@php
    $settings = App\Models\Settings::get_settings();
@endphp

@section('title')
    Invoice
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-4">
            <div class=" mb-0 text-primary" style="font-size:24px;">Invoice</div>
        </div>
        <div class="col-md-4 text-center">
            @can('Print Invoice')
                {{-- <button class="btn btn-warning print-btn" onclick="saveAsPDF()"><i class="fa fa-print" aria-hidden="true"></i>
                    Print
                </button> --}}

                <form action="{{url("invoice-pdf","list")}}" method="post">
                    @csrf
                    @foreach ($invoiceDetails as $invoice)
                        <input type="hidden" class="INVOICE_NO" name="INVOICE_NO[]" value="{{ $invoice['invoice_no'] }}">
                    @endforeach

                    <button type="submit" class="btn btn-warning print-btn" id="myButton">
                        <i class="fa fa-print" aria-hidden="true"></i> Print
                    </button>
                </form>
            @endcan
        </div>
        <div class="col-md-4 text-right">
            <a href="{{ route('invoices.index') }}" class="btn btn-primary">Back</a>
        </div>

    </div>

        @foreach ($invoiceDetails as $invoice)

            @php
                $bills = \App\Models\BillProcess::where('invoice_no', $invoice['invoice_no'])->get();

                $currencyInfo = \App\Models\BillProcess::where('invoice_no', $invoice['invoice_no'])->first();
                $currency = $currencyInfo->currency;

                $totalAmountWholeValue = $bills->sum('total_amount');
                $totalVatWholeValue = $bills->sum('vat_amount');
                $alltotalammount = $bills->sum('total_amount_vat');

                $newInvoiceNo = str_replace("/", "_", $invoice['invoice_no']);
            @endphp


    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_content" style="padding:0" id="printableArea1_{{ $newInvoiceNo }}">
                    <div class="row d-flex align-items-center">
                        <div style="position: absolute;color: #b9b6b6;font-size: 30px;text-align:right;width: 100%;padding-top:60px;">
                            <h6>যৌতুক দেয়া-নেয়া শাস্তিযোগ্য অপরাধ</h6>
                        </div>

                        <div class="col-6">
                        </div>
                        <div class="col-6 justify-content-end">
                            <div style="text-align: right;margin-bottom: -30px;margin-top: 70px;">
                                {{-- <h6>যৌতুক দেয়া-নেয়া শাস্তিযোগ্য অপরাধ</h6> --}}
                                <h6 class="text-right border d-inline-block px-3 py-2 mb-0">Customer Copy</h6>
                            </div>
                        </div>
                    </div>
                    <h5 class="text-center" style="font-size: 15px !important"> <strong>INVOICE</strong></h5>
                    <hr>
                    <div class="row">
                        <div class="col-md-6">
                        <h4 style="font-weight:bold;">{{ $invoice['customer_name'] }}</h4>
                        <p>{{ $invoice['address'] }}</p>
                            <p class="mb-1">BIN - {{ $invoice['customer_bin_no'] }}</p>
                        </div>
                        <div class="col-md-6 text-right">
                        <p class=""><strong class=""> Invoice No: </strong> {{ $invoice['invoice_no'] }} </p>
                        <p class=""><strong class=""> Invoice Date: </strong> {{ $invoice['invoice_date'] }} </p>
                        </div>
                    </div>

                    <div class="row mt-2">
                        <div class="col-md-12">
                            <p><strong class="">Attention:</strong> {{$bills[0]->attention_person}}</p>
                            <table class="table table-bordered mt-3 invoice-table">
                                <thead>
                                    <tr>
                                        <th class="text-center">Sl.</th>
                                        <th class="text-center">Description</th>
                                        <th class="text-center">Amount (in {{ $currency }})</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td class="text-center">1</td>
                                        <td> {{ $invoice['bill_subject'] }} </td>
                                        <td class="text-right">{{ priceFormat($totalAmountWholeValue) }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-center">2</td>
                                        <td>Value Added Tax</td>
                                        <td class="text-right">{{ priceFormat($totalVatWholeValue) }}</td>
                                    </tr>
                                    <tr>
                                        <td class="text-center">3</td>
                                        <td>Payment Terms:
                                            </br>
                                            100% of the invoice is payable by A/C
                                            </br>
                                            Payee Cheque/Pay Order favoring "{{ $settings['company_name'] }}"
                                            </br>
                                            BIN - {{ $settings['company_bin'] }} & TIN - {{ $settings['company_tin'] }}
                                        </td>
                                        <td></td>
                                    </tr>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="2" class="text-right"><strong>Total:</strong></td>

                                        <td class="text-right"><strong> {{ priceFormat($alltotalammount) }} </strong></td>
                                    </tr>
                                </tfoot>
                            </table>
                            <p><strong class=""> Total (In Word):</strong>
                                </strong>{{ ucwords(\App\Models\Settings::convertToWords((int)$alltotalammount)) . ' ' . $currency }}
                                Only</p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <p class="mb-2"><strong class="">For Bank Transfer:</strong></p>
                            <div class="border p-2 black">
                                <strong>Account Name:</strong> {{ $settings['bank_account_name'] }}
                                </br>
                                <strong>Account No:</strong> {{ $settings['bank_account_no'] }}
                                </br>
                                <strong>Bank Name:</strong> {{ $settings['bank_name'] }}
                                </br>
                                <strong>Branch Name:</strong> {{ $settings['branch_name'] }}
                                </br>
                                <strong>Routing No:</strong> {{ $settings['routing_no'] }}
                            </div>
                        </div>
                    </div>
                    <div class="row" style="margin-top: 90px;">
                        <div class="col-md-12">
                            <p style="display: inline-block; margin-left: 20px;">
                                <b>........................................</b>
                                </br>
                                <b>Authorized Signature</b>
                            </p>
                            <p style="display: inline-block; margin-right: 20px; float: right;">
                                <b>........................................</b>
                                <br>
                                <b>Authorized Signature</b>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_content" style="padding:0" id="printableArea2_{{ $newInvoiceNo }}">
                    <div class="row d-flex align-items-center">
                        <div style="position: absolute;color: #b9b6b6;font-size: 30px;text-align:right;width: 100%;padding-top:20px">
                            <h6>যৌতুক দেয়া-নেয়া শাস্তিযোগ্য অপরাধ</h6>
                        </div>

                        <div class="col-6">
                        </div>
                        <div class="col-6 justify-content-end">
                            <div style="text-align: right;margin-bottom: -30px;margin-top: 70px;">
                                {{-- <h6>যৌতুক দেয়া-নেয়া শাস্তিযোগ্য অপরাধ</h6> --}}
                                <h6 class="text-right border d-inline-block px-3 py-2 mb-0">Customer Copy</h6>
                            </div>
                        </div>
                    </div>
                    <h5 class="text-center" style="font-size: 15px !important"> <strong>INVOICE</strong></h5>
                    <hr>

                    <div class="row">
                        <div class="col-md-6">
                        <h4 style="font-weight:bold;">{{ $invoice['customer_name'] }}</h4>
                        <p>{{ $invoice['address'] }}</p>
                            <p class="mb-1">BIN - {{ $invoice['customer_bin_no'] }}</p>
                        </div>
                        <div class="col-md-6 text-right">
                        <p class=""><strong class=""> Invoice No: </strong> {{ $invoice['invoice_no'] }} </p>
                        <p class=""><strong class=""> Invoice Date: </strong> {{ $invoice['invoice_date'] }} </p>
                        </div>
                    </div>

                    <div class="row mt-2">
                        <div class="col-md-12">
                            <p><strong class=""></strong> {{ $invoice['bill_subject'] }} </p>

                            <table class="table table-bordered mt-1 invoice-table">
                                <thead>
                                    <tr>
                                        <th class="text-center">Sl.</th>
                                        <th class="text-center">Particulars</th>
                                        <th class="text-center">Date of<br>Installation</th>
                                        <th class="text-center">Ref No</th>
                                        <th class="text-center">Ref Date</th>
                                        <th class="text-center">Qty</th>
                                        <th class="text-center">VAT (%)</th>
                                        <th class="text-center">Unit Price</th>
                                        <th class="text-center">Total<br>Unit Price</th>
                                        <th class="text-center">VAT<br>Amount</th>
                                        <th class="text-center">Total Price</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @php
                                        $gTotal = 0;
                                        $gVAT = 0;
                                    @endphp
                                    @php
                                        $invoices = \App\Models\BillProcess::where('invoice_no', $invoice)->get();
                                    @endphp

                                    @foreach($invoices as $invoice)
                                        @php
                                            // $billInfo = \App\Models\Bill::find($invoice->bill_id);
                                            $vatRate = $invoice->vat_status ? ($invoice->vat_percent ?: 0) : 0;

                                            $gTotal = $gTotal + $invoice->total_amount;
                                            $gVAT = $gVAT + $invoice->vat_amount;
                                        @endphp

                                        <tr>
                                            <td class="text-center">{{ $loop->iteration }}</td>
                                            <td style="width:210px;">{{ $invoice->particulars }}</td>
                                            <td class="text-center">{{ $invoice->installation_date }}</td>
                                            <td class="text-center">{{ $invoice->ref_no }}</td>
                                            <td class="text-center">{{ $invoice->ref_date }}</td>
                                            <td class="text-center">{{ $invoice->qty }}</td>
                                            <td class="text-center">{{ priceFormat($vatRate) }}%</td>
                                            <td class="text-right">{{ priceFormat($invoice->unit_price_vat) }}</td>
                                            <td class="text-right">{{ priceFormat($invoice->total_amount) }}</td>
                                            <td class="text-right">{{ priceFormat($invoice->vat_amount) }}</td>
                                            <td class="text-right">{{ priceFormat($invoice->total_amount_vat) }}</td>
                                        </tr>
                                    @endforeach

                                </tbody>
                                <tfoot>
                                    @php

                                        $totalVatAmount = 0;
                                        $totalAmountVat = $invoices->sum('total_amount_vat');

                                    @endphp

                                    <tr>
                                        <td class="text-right" colspan="8"><strong>Total:</strong></td>
                                        <td class="text-right">
                                            <strong>{{ priceFormat($gTotal) }}</strong>
                                        </td>
                                        <td class="text-right">
                                            <strong>{{ priceFormat($gVAT) }}</strong>
                                        </td>
                                        <td class="text-right">
                                            <strong>{{ priceFormat($totalAmountVat) }}</strong>
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>

                            <p class=""><strong class=""> Total (In Word):
                                </strong>{{ ucwords(\App\Models\Settings::convertToWords((int)$totalAmountVat)) . ' ' . $currency }}
                                Only</p>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <p class="mb-1"><strong class="">For Bank Transfer:</strong></p>
                            <div class="border p-2 black">
                                <strong>Account Name:</strong> {{ $settings['bank_account_name'] }}
                                </br>
                                <strong>Account No:</strong> {{ $settings['bank_account_no'] }}
                                </br>
                                <strong>Bank Name:</strong> {{ $settings['bank_name'] }}
                                </br>
                                <strong>Branch Name:</strong> {{ $settings['branch_name'] }}
                                </br>
                                <strong>Routing No:</strong> {{ $settings['routing_no'] }}
                            </div>

                            <div class="mt-2">
                                <strong class="">Payment Terms:</strong> <br>
                                1. 100% of the invoice is payable by A/C <br>
                                2. Payee Cheque/Pay Order favoring "{{ $settings['company_name'] }}" <br>
                                3. BIN - {{ $settings['company_bin'] }} & TIN - {{ $settings['company_tin'] }}
                            </div>
                        </div>
                    </div>
                    <div class="row" style="margin-top: 80px;">
                        <div class="col-md-12">
                            <p style="display: inline-block; margin-left: 20px;">
                                <b>........................................</b>
                                </br>
                                <b>Authorized Signature</b>
                            </p>
                            <p style="display: inline-block; margin-right: 20px; float: right;">
                                <b>........................................</b>
                                <br>
                                <b>Authorized Signature</b>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


   @endforeach

   <style>
    .x_content{
        font-family: arial !important;
        color:#000 !important;
        font-size:13px;
    }
    .invoice-table, .invoice-table th, .invoice-table td{
        border-collapse: collapse !important;
        font-size:12px !important;
    }
    .invoice-table th {
        background-color: white;
        color: black;
        font-weight: bold;
        border: 1px solid #000 !important;
        border-bottom: 1px solid #000 !important;
        padding:2px !important;
    }
    .invoice-table td {
        border: 1px solid #000 !important;
        border-top: 1px solid #000 !important;
        padding:2px !important;
    }
    h1, h2, h3, h4, h5, h6, p, .black{
        color: #000 !important;
        font-size: 13px !important;
    }
    p{
        margin-bottom: 1px
    }
</style>
<style>
    /* Custom style for 1px borders when printing to PDF */
    /* .custom-print table, .custom-print th, .custom-print td {
        border: 1px solid black !important;
        border-collapse: collapse;
    } */

     /* .page-break{
        page-break-before: always;
     } */
</style>

@endsection



@section('script')
    <script>
        // function setPrintFlag(invoiceNo){
        //     let str = invoiceNo;
        //     let newStr = str.replace(/\//g, "_");
        //     // $.ajax({
        //     //     type: 'GET',
        //     //     url: '{{url("set-invoice-print-flag")}}/'+newStr,
        //     //     success: function (data) {}
        //     // });
        // }
        // function saveAsPDF() {
        //     $('.print-btn').html(
        //         '<span class="spinner-border spinner-border-sm mb-1" role="status" aria-hidden="true"></span> Downloading...'
        //     );
        //     $('table').addClass('custom-print');

        //     var elements = '';
        //     @foreach ($invoiceDetails as $invoicenoalls)
        //         @php
        //             $newInvoiceNo = str_replace("/", "_", $invoicenoalls['invoice_no']);
        //         @endphp
        //         var printableArea1 = $('#printableArea1_{{ $newInvoiceNo }}').html();
        //         var printableArea2 = $('#printableArea2_{{ $newInvoiceNo }}').html();
        //         elements += printableArea1 + '<div style="page-break-before: always;"></div>' + printableArea2 +
        //             '<div style="page-break-before: always;"></div>';

        //         setPrintFlag("{{ $invoicenoalls['invoice_no'] }}");
        //     @endforeach

        //     var opt = {
        //         // margin: 0.3,
        //         margin: [1.1, 0.3, 0.9, 0.3], // Top, Right, Bottom, Left
        //         filename: "Invoices",
        //         image: {
        //             type: 'jpeg',
        //             quality: 1
        //         },
        //         html2canvas: {
        //             scale: 3,
        //             dpi: 150,
        //             letterRendering: true
        //         },
        //         jsPDF: {
        //             unit: 'in',
        //             format: 'A4'
        //         }
        //     };

        //     html2pdf().set(opt).from(elements).save().then(() => {
        //         $('.print-btn').html('<i class="fa fa-print" aria-hidden="true"></i> Print All Invoice');
        //     })

        //     setTimeout(() => {
        //         $('table').removeClass('custom-print');
        //     }, 100);

        // }
    </script>
@endsection
