
@extends('layouts.app')

@php
    $settings = App\Models\Settings::get_settings();
@endphp

@section('title')
    Duplicate Invoice
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-4">
            <div class=" mb-0 text-primary" style="font-size:24px;">Invoice</div>
        </div>
        <div class="col-md-4 text-center">
            @can('Print Invoice')
                {{-- <button class="btn btn-warning print-btn" onclick="saveAsPDF()"><i class="fa fa-print" aria-hidden="true"></i>
                    Print</button> --}}

                <form action="{{url("invoice-pdf-duplicate","single")}}" method="post">
                    @csrf
                    @foreach ($invoices as $invoice)
                        <input type="hidden" class="INVOICE_NO" name="INVOICE_NO[]" value="{{ $invoice['invoice_no'] }}">
                    @endforeach

                    <button type="submit" class="btn btn-warning print-btn" id="myButton">
                        <i class="fa fa-print" aria-hidden="true"></i> Print
                    </button>
                </form>
            @endcan
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_content" style="padding:0" id="printableArea1">
                    <div style="position: absolute;color: #b9b6b6;font-size: 30px;">
                        Duplicate
                    </div>
                    <div class="row d-flex align-items-center">
                        <div class="col-6">
                        </div>
                        <div class="col-6 justify-content-end">
                            <div style="text-align: right;margin-bottom: -30px;padding-top:4px">
                                <h6>যৌতুক দেয়া-নেয়া শাস্তিযোগ্য অপরাধ</h6>
                                <h6 class="text-right border d-inline-block px-3 py-2 mb-0">Customer Copy</h6>
                            </div>
                        </div>
                    </div>
                    <h5 class="text-center" style="font-size: 15px !important"> <strong>INVOICE</strong></h5>
                    <hr>
                    <div class="row">
                        <div class="col-md-6">
                            <h4 style="font-weight:bold;">
                                {{ $firstCustomerName ?? '' }}</h4>

                            <p class=""> {{ $address }} </p>
                            <p class="">BIN - {{ $firstCustomerBinNo }}</p>
                        </div>
                        <div class="col-md-6 text-right">
                            <p class="">
                                <strong class="">Invoice No: </strong>{{ $invoiceNo }}
                            </p>
                            <p class="">
                                <strong class="">Invoice Date: </strong>{{ $invoiceDate }}
                            </p>
                        </div>
                    </div>
                    <div class="row mt-2">
                        <div class="col-md-12">
                            <p><strong class="">Attention:</strong> {{$attentionPerson}}</p>
                            <table class="table table-bordered mt-1 invoice-table">
                                <thead>
                                    <tr>
                                        <th class="text-center">Sl.</th>
                                        <th class="text-center">Description</th>
                                        <th class="text-center">Amount (in {{ $currency }})</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td class="text-center">1</td>
                                        <td>{{ $firstBillSubject }}</td>
                                        @php
                                            $totalAmount = $invoices->sum('total_amount');
                                            $gVATFirst = $invoices->sum('vat_amount');
                                        @endphp

                                        <td class="text-right"> {{ priceFormat($totalAmount) }} </td>
                                    </tr>
                                    <tr>
                                        <td class="text-center">2</td>
                                        <td>Value Added Tax</td>
                                        <td class="text-right"> {{ priceFormat($gVATFirst) }} </td>
                                    </tr>
                                    <tr>
                                        <td class="text-center">3</td>
                                        <td>Payment Terms:
                                            </br>
                                            100% of the invoice is payable by A/C
                                            </br>
                                            Payee Cheque/Pay Order favoring "{{ $settings['company_name'] }}"
                                            </br>
                                            BIN - {{ $settings['company_bin'] }} & TIN - {{ $settings['company_tin'] }}
                                        </td>
                                        <td></td>
                                    </tr>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td colspan="2" class="text-right"><strong>Total:</strong></td>
                                            @php
                                                $totalAmountVat = $invoices->sum('total_amount_vat');
                                            @endphp
                                        <td class="text-right">
                                            <strong>{{ priceFormat($totalAmountVat) }}</strong>
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                            <p><strong class=""> Total (In Word):</strong>
                                </strong>{{ ucwords(\App\Models\Settings::convertToWords((int)$totalAmountVat)) . ' ' . $currency }}
                                Only</p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <p class="mb-1"><strong class="">For Bank Transfer:</strong></p>
                            <div class="border p-2 black">
                                <strong>Account Name:</strong> {{ $settings['bank_account_name'] }}
                                </br>
                                <strong>Account No:</strong> {{ $settings['bank_account_no'] }}
                                </br>
                                <strong>Bank Name:</strong> {{ $settings['bank_name'] }}
                                </br>
                                <strong>Branch Name:</strong> {{ $settings['branch_name'] }}
                                </br>
                                <strong>Routing No:</strong> {{ $settings['routing_no'] }}
                                </br>
                                <strong>Swift Code:</strong> {{ $settings['swift_code'] }}
                            </div>
                        </div>
                    </div>
                    <div class="row" style="margin-top: 90px;">
                        <div class="col-md-12">
                            <p style="display: inline-block; margin-left: 20px;">
                                <b>........................................</b>
                                </br>
                                <b>Authorized Signature</b>
                            </p>
                            <p style="display: inline-block; margin-right: 20px; float: right;">
                                <b>........................................</b>
                                <br>
                                <b>Authorized Signature</b>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_content" style="padding:0" id="printableArea2">
                    <div style="position: absolute;color: #b9b6b6;font-size: 30px;">
                        Duplicate
                    </div>
                    <div class="row d-flex align-items-center">
                        <div class="col-6">
                        </div>
                        <div class="col-6 justify-content-end">
                            <div style="text-align: right;margin-bottom: -30px;padding-top:4px">
                                <h6>যৌতুক দেয়া-নেয়া শাস্তিযোগ্য অপরাধ</h6>
                                <h6 class="text-right border d-inline-block px-3 py-2 mb-0">Customer Copy</h6>
                            </div>
                        </div>
                    </div>
                    <h5 class="text-center" style="font-size: 15px !important"> <strong>INVOICE</strong></h5>
                    <hr>


                    <div class="row">
                        <div class="col-md-6">
                            <h4 style="font-weight:bold;">
                                {{ $firstCustomerName ?? '' }}</h4>

                            <p class=""> {{ $address }} </p>
                            <p class="">BIN - {{ $firstCustomerBinNo }}</p>
                        </div>
                        <div class="col-md-6 text-right">
                            <p class="">
                                <strong class="">Invoice No: </strong>{{ $invoiceNo }}
                            </p>
                            <p class="">
                                <strong class="">Invoice Date: </strong>{{ $invoiceDate }}
                            </p>
                        </div>
                    </div>

                    <div class="row mt-2">
                        <div class="col-md-12">
                            <p><strong class="">Subject: </strong>
                                {{ $firstBillSubject }}</p>

                            <table class="table table-bordered mt-1 invoice-table">
                                <thead>
                                    <tr>
                                        <th class="text-center">Sl.</th>
                                        <th class="text-center">Particulars</th>
                                        <th class="text-center">Date of<br>Installation</th>
                                        <th class="text-center">Ref No</th>
                                        <th class="text-center">Ref Date</th>
                                        <th class="text-center">Qty</th>
                                        <th class="text-center">VAT (%)</th>
                                        <th class="text-center">Unit Price</th>
                                        <th class="text-center">Total<br>Unit Price</th>
                                        <th class="text-center">VAT<br>Amount</th>
                                        <th class="text-center">Total Price</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @foreach($invoices as $invoice)

                                        @php
                                            $vatRate = $invoice->vat_status ? ($invoice->vat_percent ?: 0) : 0;
                                        @endphp

                                        <tr>
                                            <td class="text-center">{{ $loop->iteration }}</td>
                                            <td style="width:210px;">{{ $invoice->particulars }}</td>
                                            <td class="text-center">{{ $invoice->installation_date }}</td>
                                            <td class="text-center">{{ $invoice->ref_no }}</td>
                                            <td class="text-center">{{ $invoice->ref_date }}</td>
                                            <td class="text-center">{{ $invoice->qty }}</td>
                                            <td class="text-right">{{ priceFormat($vatRate) }}%</td>
                                            <td class="text-right">{{ priceFormat($invoice->unit_price_vat) }}</td>
                                            <td class="text-right">{{ priceFormat($invoice->total_amount) }}</td>
                                            <td class="text-right">{{ priceFormat($invoice->vat_amount) }}</td>
                                            <td class="text-right">{{ priceFormat($invoice->total_amount_vat) }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    @php
                                        $totalAmount = $invoices->sum('total_amount');
                                        $vatAmount = $invoices->sum('vat_amount');
                                        $totalAmountVat = $invoices->sum('total_amount_vat');
                                    @endphp
                                    <tr>
                                        <td class="text-right" colspan="8"><strong>Total:</strong></td>
                                        <td class="text-right">
                                            <strong>{{ priceFormat($totalAmount) }}</strong>
                                        </td>
                                        <td class="text-right">
                                            <strong>{{ priceFormat($vatAmount) }}</strong>
                                        </td>
                                        <td class="text-right">
                                            <strong>{{ priceFormat($totalAmountVat) }}</strong>
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>


                            <p class=""><strong class=""> Total (In Word):
                                </strong>{{ ucwords(\App\Models\Settings::convertToWords((int)$totalAmountVat)) . ' ' . $currency }}
                                Only</p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-12">
                            <p class="mb-1"><strong class="">For Bank Transfer:</strong></p>
                            <div class="border p-2 black">
                                <strong>Account Name:</strong> {{ $settings['bank_account_name'] }}
                                </br>
                                <strong>Account No:</strong> {{ $settings['bank_account_no'] }}
                                </br>
                                <strong>Bank Name:</strong> {{ $settings['bank_name'] }}
                                </br>
                                <strong>Branch Name:</strong> {{ $settings['branch_name'] }}
                                </br>
                                <strong>Routing No:</strong> {{ $settings['routing_no'] }}
                                </br>
                                <strong>Swift Code:</strong> {{ $settings['swift_code'] }}
                            </div>

                            <div class="mt-2">
                                <strong class="">Payment Terms:</strong> <br>
                                1. 100% of the invoice is payable by A/C <br>
                                2. Payee Cheque/Pay Order favoring "{{ $settings['company_name'] }}" <br>
                                3. BIN - {{ $settings['company_bin'] }} & TIN - {{ $settings['company_tin'] }}
                            </div>
                        </div>
                    </div>
                    <div class="row" style="margin-top: 80px;">
                        <div class="col-md-12">
                            <p style="display: inline-block; margin-left: 20px;">
                                <b>........................................</b>
                                </br>
                                <b>Authorized Signature</b>
                            </p>
                            <p style="display: inline-block; margin-right: 20px; float: right;">
                                <b>........................................</b>
                                <br>
                                <b>Authorized Signature</b>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

<style>
    .x_content{
        font-family: arial !important;
        color:#000 !important;
        font-size:13px;
    }
    .invoice-table, .invoice-table th, .invoice-table td{
        border-collapse: collapse !important;
        font-size:12px !important;
    }
    .invoice-table th {
        background-color: white;
        color: black;
        font-weight: bold;
        border: 1px solid #000 !important;
        border-bottom: 1px solid #000 !important;
        padding:2px !important;
    }
    .invoice-table td {
        border: 1px solid #000 !important;
        border-top: 1px solid #000 !important;
        padding:2px !important;
    }
    h1, h2, h3, h4, h5, h6, p, .black{
        color: #000 !important;
        font-size: 13px !important;
    }
    p{
        margin-bottom: 1px
    }
</style>
<style>
    /* Custom style for 1px borders when printing to PDF */
    /* .custom-print table, .custom-print th, .custom-print td {
        border: 1px solid black !important;
        border-collapse: collapse;
    } */
</style>

@endsection

@section('script')
    <script>
        // function setPrintFlag(invoiceNo){
        //     let str = invoiceNo;
        //     let newStr = str.replace(/\//g, "_");
        //     $.ajax({
        //         type: 'GET',
        //         url: '{{url("set-invoice-print-count")}}/'+newStr,
        //         success: function (data) {}
        //     });
        // }
        // function saveAsPDF() {
        //     $('.print-btn').html(
        //         '<span class="spinner-border spinner-border-sm " role="status" aria-hidden="true"></span> Downloading...'
        //     );
        //     $('table').addClass('custom-print');

        //     var printableArea1 = $('#printableArea1').html();
        //     var printableArea2 = $('#printableArea2').html();

        //     var element = printableArea1 + '<div style="page-break-before: always;"></div>' + printableArea2;
        //     setPrintFlag("{{ $invoice->invoice_no }}");

        //     var opt = {
        //         // margin: 0.3,
        //         margin: [1.1, 0.3, 0.9, 0.3], // Top, Right, Bottom, Left
        //         filename: "Invoice_{{ $invoice->invoice_no }}",
        //         image: {
        //             type: 'jpeg',
        //             quality: 0.8
        //         },
        //         html2canvas: {
        //             scale: 3,
        //             dpi: 150,
        //             letterRendering: true
        //         },
        //         jsPDF: {
        //             unit: 'in',
        //             format: 'A4'
        //         }
        //     };
        //     html2pdf().set(opt).from(element).save().then(() => {
        //         $('.print-btn').html('<i class="fa fa-print" aria-hidden="true"></i> Print');
        //     })

        //     setTimeout(() => {
        //         $('table').removeClass('custom-print');
        //     }, 100);

        // }
    </script>
@endsection
