@extends('layouts.app')

@php
    $settings = App\Models\Settings::get_settings();
@endphp

@section('title')
Invoice Cancellation
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Invoice Cancellation</h4>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-12">
            <div class="mt-2" id="multiCollapseExample1">
                <div class="card">
                    <div class="card-body">
                        <form action="{{ route('cancel.invoice.preview') }}" method="get" autocomplete="off">
                            <div class="row align-items-center justify-content-end">
                                <div class="col-md-12">
                                    <div class="row align-items-end">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="start_date">Invoice No</label>
                                                <input type="text" id="invoice_no" name="invoice_no" class="form-control" value="{{request('invoice_no')}}" required>
                                            </div>
                                        </div>
                                        <div class="col-md-1 px-1">
                                            <div class="form-group">
                                                <button class="btn btn-primary btn-block" type="submit"
                                                    name="search_buttonn">
                                                    Filter
                                                </button>
                                            </div>
                                        </div>

                                        <div class="col-md-1 px-1">
                                            <div class="form-group">
                                                <a href="{{ route('cancel.invoice.preview') }}"
                                                    class="btn btn-danger btn-block">
                                                    Clear
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <br>


    @if(request('invoice_no')!='' && count($billData)>0)

<style>
    h1, h2, h3, p{
        color:black;
    }
</style>
    {{-- FROM GROUPED INVOICE BLADE --}}
    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_content" style="padding:0" id="printableArea2">
                    <div class="row d-flex align-items-center" style="font-size: 17px;color:#000">
                        @if($collectionList)
                        N.B. To cancel this invoice please delete collection no:{{$collectionList}} first from collection cancellation menu.
                        @endif
                    </div>
                    <h3 class="text-center" style="font-size: 18px"> <strong>INVOICE</strong></h3>
                    <hr>

                    <div class="row">
                        <div class="col-md-6">
                            <h4 style="font-size: 15px;color:#000;">
                                <b>{{ $firstCustomerName ?? '' }}</b></h4>
                            <p class="mb-2"> {{ $address }} </p>
                            <p class="mb-1">BIN - {{ $firstCustomerBinNo }}</p>
                        </div>
                        <div class="col-md-6 text-right">
                            <p class="mb-1">
                                <strong>Invoice No: </strong>{{ $invoiceNo }}
                            </p>
                            <p class="mb-1">
                                <strong>Invoice Date: </strong>{{ \Carbon\Carbon::createFromFormat('d/m/Y', $invoiceDate)->format('d/m/Y') }}
                            </p>
                        </div>
                    </div>

                    <div class="row mt-2">
                        <div class="col-md-12">
                            <p><strong>Subject: </strong>
                                {{ $firstBillSubject ? $firstBillSubject->bill_subject : '-' }}</p>

                            <table class="table table-bordered mt-3 invoice-table">
                                <thead>
                                    <tr>
                                        <th class="text-center">Sl.</th>
                                        <th class="text-center">Particulars</th>
                                        <th class="text-center">D.O.I.</th>
                                        <th class="text-center">Ref No</th>
                                        <th class="text-center">Ref Date</th>
                                        <th class="text-center">Qty</th>
                                        <th class="text-center">VAT (%)</th>
                                        <th class="text-center">Unit Price</th>
                                        <th class="text-center">Total Unit Price</th>
                                        <th class="text-center">VAT Amount</th>
                                        <th class="text-center">Total Price</th>
                                    </tr>
                                </thead>
                                <tbody>

                                    @php
                                        $gTotal = 0;
                                        $gVAT = 0;
                                    @endphp
                                    @foreach($invoices as $invoice)

                                        @php
                                            $billInfo = \App\Models\Bill::find($invoice->bill_id);
                                            $vatRate = $invoice->vat_status ? ($invoice->vat_percent ?: 0) : 0;

                                            $gTotal = $gTotal + $invoice->total_amount;
                                            $gVAT = $gVAT + $invoice->vat_amount;
                                        @endphp

                                        <tr>
                                            <td class="text-center">{{ $loop->iteration }}</td>
                                            <td>{{ $invoice->particulars }}</td>
                                            <td>{{ $invoice->invoice_date }}</td>
                                            <td>{{ $invoice->ref_no }}</td>
                                            <td>{{ $invoice->ref_date }}</td>
                                            <td class="text-center">{{ $invoice->qty }}</td>
                                            <td class="text-center">{{ $vatRate }}%</td>
                                            <td class="text-right">{{ \App\Models\Settings::priceFormat($invoice->unit_price_vat) }}</td>
                                            <td class="text-right">{{ \App\Models\Settings::priceFormat($invoice->total_amount) }}</td>
                                            <td class="text-right">{{ \App\Models\Settings::priceFormat($invoice->vat_amount) }}</td>
                                            <td class="text-right">{{ \App\Models\Settings::priceFormat($invoice->total_amount_vat) }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                                <tfoot>
                                    @php
                                        $totalVatAmount = 0;
                                        $totalAmountVat = $invoices->sum('total_amount_vat');
                                    @endphp
                                    <tr>
                                        <td class="text-right" colspan="8"><strong>Total:</strong></td>
                                        <td class="text-right">
                                            <strong>{{ \App\Models\Settings::priceFormat($gTotal) }}</strong>
                                        </td>
                                        <td class="text-right">
                                            <strong>{{ \App\Models\Settings::priceFormat($gVAT) }}</strong>
                                        </td>
                                        <td class="text-right">
                                            <strong>{{ \App\Models\Settings::priceFormat($totalAmountVat) }}</strong>
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>


                            <p class="mb-1"><strong> Total (In Word):
                                </strong>{{ ucwords(\App\Models\Settings::convertToWords($totalAmountVat)) . ' ' . $currency }}
                                Only</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .invoice-table th {
            background-color: white;
            color: black;
            font-weight: bold;
        }
    </style>


        @if($collectionList=='')
        <div class="row button-bar">
            <div class="col-md-12 text-center">
                <a data="{{ route('cancel.invoice.details', $invoiceNo) }}"
                    class="btn btn-warning delete-btn text-dark cursor-pointer">Cancel Invoice</a>
            </div>
        </div>
        @endif

        @if($billData[0]->challan_sl > 0)
            <div class="error-text-custom">Sorry, Invoice cannot be cancelled because VAT has already been stamped.</div>
            <script>
                $('.button-bar').addClass('d-none');
            </script>
        @endif

    @else
        @if(request('invoice_no')!='')
        <div class="error-text-custom">Sorry, Invoice data not found.</div>
        @endif
    @endif



    <script>
        $(document).on("click", ".delete-btn", function () {
            var hrefValue = $(this).attr('data');
            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: "btn btn-success",
                    cancelButton: "btn btn-danger",
                },
                buttonsStyling: false,
            });
            swalWithBootstrapButtons
                .fire({
                    title: "Are you sure to cancel this invoice?",
                    text: "Invoice data also delete from accounts!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonText: "Yes, Cancel Invoice",
                    cancelButtonText: "No, Do Not Cancel",
                    reverseButtons: true,
                })
                .then((result) => {
                    if (result.isConfirmed) {
                        window.location.replace(hrefValue);
                    } else if (result.dismiss === Swal.DismissReason.cancel) {
                    }
                });
        });
    </script>

    <style>
        .error-text-custom{
            text-align: center;
            color:red;
            font-weight: bold;
            font-size: 20px
        }
    </style>
@endsection




