<div class="modal-body">
    <div class="row">
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Invoice No:</b></div>
            <p class="text-muted mb-3">{{ $bill->invoice_no ? $bill->invoice_no : '-' }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Customer:</b></div>
            <p class="text-muted mb-3">{{ $bill->customer ? $bill->customer->customer_name : '-' }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Particulars:</b></div>
            <p class="text-muted mb-3">{{ $bill->particulars ? $bill->particulars : '-' }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Quantity:</b></div>
            <p class="text-muted mb-3">{{ $bill->qty ? $bill->qty : '-' }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Unit Price:</b></div>
            <p class="text-muted mb-3">{{ $bill->unit_price_vat ? \App\Models\Settings::priceFormat($bill->unit_price_vat) : '-' }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Total Amount:</b></div>
            <p class="text-muted mb-3">{{ $bill->total_amount ? \App\Models\Settings::priceFormat($bill->total_amount) : '-' }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Bill Subject:</b></div>
            <p class="text-muted mb-3">{{ $bill->billSubject ? $bill->billSubject->bill_subject : '-' }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Ref No:</b></div>
            <p class="text-muted mb-3">{{ $bill->ref_no ? $bill->ref_no : '-' }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Ref Date:</b></div>
            <p class="text-muted mb-3">{{ $bill->ref_date ? $bill->ref_date : '-' }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Installation Date:</b></div>
            <p class="text-muted mb-3">{{ $bill->installation_date ? $bill->installation_date : '-' }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Activation Date:</b></div>
            <p class="text-muted mb-3">{{ $bill->activation_date ? $bill->activation_date : '-' }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Start Date:</b></div>
            <p class="text-muted mb-3">{{ $bill->start_date ? $bill->start_date : '-' }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>End Date:</b></div>
            <p class="text-muted mb-3">{{ $bill->end_date ? $bill->end_date : '-' }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Department:</b></div>
            <p class="text-muted mb-3 departmentVal"> - </p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Bill Group:</b></div>
            <p class="text-muted mb-3">{{ $bill->bill_group ? $bill->bill_group : '-' }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Bill Type:</b></div>
            <p class="text-muted mb-3">{{ $bill->bill_type ? $bill->bill_type : '-' }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Payment Type:</b></div>
            <p class="text-muted mb-3">{{ $bill->payment_type ? $bill->payment_type : '-' }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>VAT Percent:</b></div>
            <p class="text-muted mb-3">{{ $bill->vat_percent ? $bill->vat_percent.'%' : '-' }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>VAT Status:</b></div>
            <p class="text-muted mb-3">{{ $bill->vat_status ? 'Yes' : 'No' }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Yearly Increase Percent:</b></div>
            <p class="text-muted mb-3">{{ $bill->yearly_increase_percent ? $bill->yearly_increase_percent : '-' }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Increase Start Date:</b></div>
            <p class="text-muted mb-3">{{ $bill->increase_start_date ? $bill->increase_start_date : '-' }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Order SL No:</b></div>
            <p class="text-muted mb-3">{{ $bill->order_sl_no ? $bill->order_sl_no : '-' }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Status:</b></div>
            <p class="text-muted mb-3">{{ $bill->status ? $bill->status : '-' }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Created at:</b></div>
            <p class="text-muted mb-3">{{ $bill->created_at ? \Carbon\Carbon::parse($bill->created_at)->format('d-m-Y') : '-' }}</p>
        </div>
    </div>
</div>

<div class="modal-footer">
    <input type="button" value="Close" class="btn btn-danger" data-dismiss="modal">
</div>

<script>

    getDeptResult("{{$bill->department_id}}")

    // Get department name by key value - salaquzzaman @ 05-06-2024
    function getDeptResult(targetDept){
        // The encoded JSON string
        var depts = "{{ $departments }}";

        var decodedDepts = decodeHtmlEntities(depts);
        var json = JSON.parse(decodedDepts);

        var divInfo = getDataByKeyValue(json,"divCode", targetDept);
        if(divInfo!=null){
            $('.departmentVal').text(divInfo["divName"]);
        }
    }

    // Function to decode HTML entities
    function decodeHtmlEntities(text) {
        var parser = new DOMParser();
        var dom = parser.parseFromString('<!doctype html><body>' + text, 'text/html');
        return dom.body.textContent;
    }

    // Function to get data by key-value
    function getDataByKeyValue(list,key, value) {
        var result = null;
        $.each(list, function(index, product) {
            if (product[key] === value) {
            result = product;
            return false;
            }
        });
        return result;
    }

</script>
