@extends('layouts.app')

@section('title')
    Instant Bill
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">One Time Instant Bill</h4>
        </div>
        <div class="col-md-6 text-right">
            @can('Create Instant Invoice')
                <a href="{{ route('instantInvoice.create') }}" class="btn btn-primary">Add New</a>
            @endcan
        </div>
    </div>


            <form action="{{ route('instantInvoice.index') }}" method="GET" class="num_filter px-4">
                <label for="per_page">Show</label>
                <select name="per_page" id="per_page" onchange="this.form.submit()" style="height: 40px; width: 70px; border: 1px solid #ced4da; border-radius: 4px">
                    <option value="25" {{ $perPage == 25 ? 'selected' : '' }}>25</option>
                    <option value="50" {{ $perPage == 50 ? 'selected' : '' }}>50</option>
                    <option value="100" {{ $perPage == 100 ? 'selected' : '' }}>100</option>
                    <option value="{{ $bills->total() }}" {{ $perPage == $bills->total() ? 'selected' : '' }}>All</option>
                </select>
                Entries
            </form>

    <div class="row">
        <table id="datatable-buttons" class="table table-striped table-bordered" style="width:100%">
            <thead>
                <tr>
                    <th>Sl No</th>
                    <th>Invoice No</th>
                    <th>Customer</th>
                    <th>Quantity</th>
                    <th>Unit Price</th>
                    <th>VAT(%)</th>
                    <th>Total Amount</th>
                    <th>Bill Type</th>
                    <th>Action</th>
                </tr>
            </thead>

            <tbody>
                @foreach ($bills as $row)
                    <tr>
                        <!-- <td>{{ $loop->iteration }}</td> -->
                        <td>{{ $loop->iteration + ($bills->currentPage() - 1) * $bills->perPage() }}</td>
                        <td>
                            <nobr>{{ $row->invoice_no }}</nobr>
                        </td>
                        <td>{{ $row->customer ? $row->customer->customer_name : '-' }}</td>
                        <td>{{ $row->qty ? $row->qty : '-' }}</td>
                        <td>{{ \App\Models\Settings::priceFormat($row->unit_price_vat) }}</td>
                        <td>{{ $row->vat_percent }}</td>
                        <td>{{ \App\Models\Settings::priceFormat($row->total_amount) }}</td>
                        <td>{{ $row->bill_type ? $row->bill_type : '-' }}</td>
                        <td>
                            <a data-size="lg" class="btn btn-info btn-sm text-white cursor-pointer"
                                data-url="{{ route('instantInvoice.show', $row->id) }}" data-ajax-popup="true"
                                data-title="View Bill" data-bs-toggle="tooltip" title="View"
                                data-original-title="View">View</a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        <div class="row">
            <div class="col-md-12 d-flex justify-content-between">
                <div>
                    Showing {{ $bills->firstItem() }} to {{ $bills->lastItem() }} of {{ $bills->total() }} entries
                </div>
                <div>
                    {{ $bills->appends(['per_page' => $perPage])->links('vendor.pagination.custom-pagination') }}
                </div>
            </div>
        </div>

    </div>

    <style>
        {
            display: inline-block;
            position: absolute;
            z-index: 2;
        }
    </style>

<style>
    body {
        margin: 0;
        padding: 0;
        height: 100vh; 
        display: flex;
        flex-direction: column;
    }

    .container {
        flex: 1; 
        overflow-y: auto; 
    }

    .row {
        flex-grow: 1;
    }

    .table-responsive {
        max-height: calc(100vh - 250px); 
        overflow-y: auto;
    }
</style>

@endsection
