@extends('layouts.app')

@section('title')
    GL Head
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Manage GL Head</h4>
        </div>
        <div class="col-md-6 text-right">
            <a class="btn btn-primary text-light cursor-pointer" data-url="{{ route('gl-head.create') }}"
                data-ajax-popup="true" data-title="Create GL Head" data-bs-toggle="tooltip" title="Create"
                data-original-title="Create">Add New</a>
        </div>
    </div>

            <form action="{{ route('gl-head.index') }}" method="GET" class="num_filter px-4">
                <label for="per_page">Show</label>
                <select name="per_page" id="per_page" onchange="this.form.submit()" style="height: 40px; width: 70px; border: 1px solid #ced4da; border-radius: 4px">
                    <option value="25" {{ $perPage == 25 ? 'selected' : '' }}>25</option>
                    <option value="50" {{ $perPage == 50 ? 'selected' : '' }}>50</option>
                    <option value="100" {{ $perPage == 100 ? 'selected' : '' }}>100</option>
                    <option value="{{ $glHeads->total() }}" {{ $perPage == $glHeads->total() ? 'selected' : '' }}>All</option>
                </select>
                Entries
            </form>

    <div class="row">
        <table id="datatable-buttons" class="table table-striped table-bordered" style="width:100%">
            <thead>
                <tr>
                    <th>Sl No</th>
                    <th>GL Code</th>
                    <th>GL Subject</th>
                    <th>Created</th>
                    <th>Action</th>
                </tr>
            </thead>

            <tbody>
                @foreach ($glHeads as $row)
                    <tr>
                        <!-- <td>{{ $loop->iteration }}</td> -->
                        <td>{{ $loop->iteration + ($glHeads->currentPage() - 1) * $glHeads->perPage() }}</td>
                        <td>{{ $row->gl_code }}</td>
                        <td>{{ $row->gl_subject }}</td>
                        <td>{{ \Carbon\Carbon::parse($row->created_at)->format('d F, Y') }}</td>
                        <td>
                            <a class="btn btn-success btn-sm text-white cursor-pointer"
                                data-url="{{ route('gl-head.edit', $row->id) }}" data-ajax-popup="true"
                                data-title="Edit GL Head" data-bs-toggle="tooltip" title="Edit"
                                data-original-title="Edit">Edit</a>

                            <form id="delete-form-{{ $row->id }}" class="d-inline"
                                action="{{ route('gl-head.destroy', $row->id) }}" method="POST">
                                @csrf
                                @method('DELETE')
                                <a class="btn btn-danger btn-sm alert-btn text-white cursor-pointer">Delete</a>
                            </form>

                        </td>
                    </tr>
                @endforeach

            </tbody>
        </table>

        <div class="row">
            <div class="col-md-12 d-flex justify-content-between">
                <div>
                    Showing {{ $glHeads->firstItem() }} to {{ $glHeads->lastItem() }} of {{ $glHeads->total() }} entries
                </div>
                <div>
                    {{ $glHeads->appends(['per_page' => $perPage])->links('vendor.pagination.custom-pagination') }}
                </div>
            </div>
        </div>

    </div>

    <style>
        {
            display: inline-block;
            position: absolute;
            z-index: 2;
        }
    </style>

    <style>
        body {
            margin: 0;
            padding: 0;
            height: 100vh; 
            display: flex;
            flex-direction: column;
        }

        .container {
            flex: 1; 
            overflow-y: auto; 
        }

        .row {
            flex-grow: 1;
        }

        .table-responsive {
            max-height: calc(100vh - 250px); 
            overflow-y: auto;
        }
    </style>


@endsection
