<!DOCTYPE html>
<html>

<head>
    <title>Your {{ $billProcess->bill_type }} Bill</title>
    <style>
        @import url('https://fonts.googleapis.com/css2?family=Nunito:wght@400;700&display=swap');

        body {
            font-family: 'Nunito', sans-serif;
            background-color: #f8f9fa;
            color: #333;
            margin: 0;
            padding: 0;
        }

        .container {
            width: 100%;
            max-width: 90%;
            margin: 0 auto;
            background-color: #fff;
            padding: 10px;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }

        .header {
            background-color: #112f6f;
            color: #fff;
            padding: 15px;
            text-align: center;
            border-radius: 10px 10px 0 0;
        }

        .header h1 {
            margin: 0;
            font-size: 20px;
        }

        .content {
            padding: 20px;
            background-color: #fafafa;
        }

        .invoice-header {
            margin-bottom: 20px;
        }

        .invoice-header h2 {
            font-size: 18px;
            margin: 0;
            display: inline-block;
        }

        .invoice-number {
            font-size: 15px;
            color: #828282;
            float: right;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            font-size: 14px;
        }

        table,
        th,
        td {
            border: 1px solid #ddd;
        }

        th,
        td {
            padding: 8px;
            text-align: left;
        }

        th {
            background-color: #112f6f;
            color: white;
            font-size: 14px;
        }

        .footer {
            background-color: #f1f1f1;
            text-align: center;
            padding: 10px;
            border-radius: 0 0 10px 10px;
            font-size: 12px;
            color: #666;
        }

        .footer p {
            margin: 5px 0;
        }

        .text-primary {
            color: #112f6f !important;
        }

        .border {
            border: 1px solid #dee2e6;
        }

        .p-2 {
            padding: .5rem !important;
        }

        .mb-1 {
            margin-bottom: 5px;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="header">
            <h1>{{ $billProcess->bill_type }} Bill</h1>
        </div>
        <div class="content">
            <div class="invoice-header">
                <h2 class="text-primary">Hello {{ $billProcess->customer->customer_name }},</h2>
                <span class="invoice-number">#{{ $billProcess->invoice_no }}</span>
            </div>
            <p>Here is your bill for the month of {{ $billProcess->month }}, {{ $billProcess->year }}</p>
            <p><strong class="text-primary">Bill Subject:</strong> {{ $billProcess->billSubject->bill_subject }}</p>

            <table>
                <thead>
                    <tr>
                        <th>Bill No</th>
                        <th>Bill Type</th>
                        <th>Payment Type</th>
                        <th>Amount</th>
                        <th>VAT</th>
                        <th>Total Amount</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>{{ str_pad($billProcess->bill_id, 5, '0', STR_PAD_LEFT) }}</td>
                        <td>{{ $billProcess->bill_type }}</td>
                        <td>{{ $billProcess->payment_type }}</td>
                        <td>{{ \App\Models\Settings::priceFormat($billProcess->total_amount) }}</td>
                        <td>{{ \App\Models\Settings::priceFormat($billProcess->vat_status == 1 ? ($billProcess->total_amount * $billProcess->vat_percent) / 100 : 0) }}
                        </td>
                        <td><b>{{ \App\Models\Settings::priceFormat($billProcess->total_amount_vat) }}</b></td>
                    </tr>
                </tbody>
            </table>

            <p><strong class="text-primary">Total (In Word):</strong>
                {{ ucwords(\App\Models\Settings::convertToWords($billProcess->total_amount_vat)) . ' ' . $settings['currency'] }}
                Only</p>

            <p class="mb-1"><strong class="text-primary">For Bank Transfer:</strong></p>
            <div class="border p-2">
                <strong>Account Name:</strong> {{ $settings['bank_account_name'] }}<br />
                <strong>Account No:</strong> {{ $settings['bank_account_no'] }}<br />
                <strong>Bank Name:</strong> {{ $settings['bank_name'] }}<br />
                <strong>Branch Name:</strong> {{ $settings['branch_name'] }}<br />
                <strong>Routing No:</strong> {{ $settings['routing_no'] }}<br />
            </div>

            <p>If you have any questions or concerns about your bill, please don't hesitate to <a
                    href="mailto:{{ env('MAIL_FROM_ADDRESS') }}">contact our support team</a>.</p>
            <p>Thank you for your business with us!</p>
        </div>
        <div class="footer">
            <p>&copy; {{ date('Y') }} {{ $settings['company_name'] }}. All rights reserved.</p>
            <p>{{ $settings['company_name'] }}, {{ $settings['company_address'] }}, {{ $settings['company_city'] }},
                {{ $settings['company_zip'] }}</p>
        </div>
    </div>
</body>

</html>
