@extends('layouts.app')

@section('title')
    Deals
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Deal Details</h4>
        </div>
    </div>

    <div class="row">
        <table id="datatable-buttons" class="table table-striped table-bordered" style="width:100%">
            <thead>
                <tr>
                    <th>Sl</th>
                    <th>Deal Name</th>
                    <th>Price</th>
                    <th>Expense<br>from Lead</th>
                    <th>Expense<br>from Deals</th>
                    <th>Collection</th>
                    <th>Remaining</th>
                    <th>Action</th>
                </tr>
            </thead>

            <tbody>
                @if($deals)

                @php
                    $grandPrice = 0;
                    $grandLeadExpense = 0;
                    $grandDealExpense = 0;
                    $grandCollection = 0;
                    $grandRemaining = 0;
                @endphp
                @foreach ($deals as $row)
                    @php
                        $totalMainExpenseAmt = 0;
                        $totalOtherExpenseAmt = 0;
                        $totalCollectionAmt = 0;
                        $totalRemainingAmt = 0;
                        $dealPrice = $row->price;
                        $dealId = $row->id;

                        $grandPrice = $grandPrice+$dealPrice;
                        $grandLeadExpense = $grandLeadExpense+$row->lead_expense;
                    @endphp
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ $row->name }}</td>
                        <td class="text-right">{{ \App\Models\Settings::priceFormat($row->price) }}</td>
                        <td class="text-right">{{ \App\Models\Settings::priceFormat($row->lead_expense) }}</td>
                        <td class="text-right">
                            @php
                                $projects = DB::table('projects')->where('deal_id',$row->id)->get();
                            @endphp

                            @if($projects)
                                @foreach($projects as $row)

                                    @php
                                        $projectId = $row->id;
                                        $projectBudget = $row->budget;

                                        // $totalMainExpenseAmt = 0;
                                        $expenseInfo = DB::table('bills')->where('project_id', $row->id)->get();
                                        $otherExpenseInfo = DB::table('other_expenses')->where('module_id', $projectId)->where('module', 'project')->get();
                                        $collectionInfo = DB::table('collection_chds')->where('project_id', $projectId)->get();
                                    @endphp

                                    @if($expenseInfo)
                                        @foreach($expenseInfo as $row)
                                            @php
                                                $expensePay = DB::table('bill_payments')->where('bill_id', $row->id)->first();
                                            @endphp

                                            @if($expensePay)
                                                @php
                                                    $totalMainExpenseAmt = $totalMainExpenseAmt + $expensePay->amount;
                                                @endphp
                                            @endif
                                        @endforeach
                                    @endif

                                    @if($otherExpenseInfo)
                                        @foreach($otherExpenseInfo as $row)
                                            @php
                                                $totalOtherExpenseAmt = $totalOtherExpenseAmt + $row->amount;
                                            @endphp
                                        @endforeach
                                    @endif

                                    @if($collectionInfo)
                                        @foreach($collectionInfo as $row)
                                            @php
                                                $totalCollectionAmt = $totalCollectionAmt + $row->collection_amount;
                                            @endphp

                                        @endforeach
                                    @endif

                                @endforeach
                            @endif
                            @php
                                $totalExpense = $totalMainExpenseAmt+$totalOtherExpenseAmt;
                                $totalRemainingAmt = $dealPrice-($totalCollectionAmt+$totalExpense);

                                $grandDealExpense = $grandDealExpense+$totalExpense;
                                $grandCollection = $grandCollection+$totalCollectionAmt;
                                $grandRemaining = $grandRemaining+$totalRemainingAmt;
                            @endphp

                             {{ \App\Models\Settings::priceFormat(sprintf("%.2f", $totalExpense)) }}

                        </td>
                        <td class="text-right">{{\App\Models\Settings::priceFormat(sprintf("%.2f", $totalCollectionAmt))}}</td>
                        <td class="text-right">{{\App\Models\Settings::priceFormat(sprintf("%.2f", $totalRemainingAmt))}}</td>
                        <td>
                            @if(count($projects)>0)
                            <a data-size="lg" class="btn btn-info btn-sm text-white cursor-pointer"
                                data-url="{{ route('deal.details.project', $dealId) }}" data-ajax-popup="true"
                                data-title="View Projects" data-bs-toggle="tooltip" title="View"
                                data-original-title="View">View</a>
                            @endif
                        </td>
                    </tr>
                @endforeach
                @else
                <tr>
                    <td colspan="8">No data found</td>
                </tr>
                @endif
            </tbody>
        </table>
    </div>
@endsection
