@extends('layouts.app')

@php
    $settings = App\Models\Settings::get_settings();
@endphp

@section('title')
    Dashboard
@endsection

@section('content')
<style>
    .summary-count .x_panel .count{
        font-size: 30px !important;
        font-weight: 500;
        text-align: right;
    }
    .summary-count .count_top{
        font-size: 15px !important;
        font-weight: 500;
    }
    .summary-count .count_top, .summary-count .count{
        color: #fff;
    }
    .summary-count .x_panel{
        border: none;
    }
    .state-bg-red{
        background: #FF5370 !important;
    }
    .state-bg-blue{
        background: #4099FF !important;
    }
    .state-bg-green{
        background: #2ED8B6 !important;
    }
    .state-bg-orange{
        background: #FFB64D !important;
    }
</style>
    <div class="row summary-count mb-2">
        <div class="col-md-3 col-sm-6">
            <div class="x_panel rounded state-bg-red">
                <span class="count_top"><i class="fa fa-users"></i> Total Customers</span>
                <div class="count">{{ priceFormat($customerCount) }}</div>
            </div>
        </div>
        <div class="col-md-3 col-sm-6">
            <div class="x_panel rounded state-bg-blue">
                <span class="count_top"><i class="fa fa-money"></i> Total Bills</span>
                <div class="count">{{ priceFormat($activeBillCount + $inactiveBillCount) }}</div>
            </div>
        </div>
        <div class="col-md-3 col-sm-6">
            <div class="x_panel rounded state-bg-green">
                <span class="count_top"><i class="fa fa-file-text"></i> Total Invoices</span>
                <div class="count">{{ priceFormat($invoiceCount) }}</div>
            </div>
        </div>
        <div class="col-md-3 col-sm-6">
            <div class="x_panel rounded state-bg-orange">
                <span class="count_top"><i class="fa fa-usd"></i> Month Collection Cash</span>
                <div class="count">{{ priceFormat($monthCollectionAmount ?? 0) }}</div>
            </div>
        </div>
    </div>

    <div class="row mb-3" style="display: none;">
        <div class="tile_count">
            {{-- <div class="col-md-3 col-sm-4  tile_stats_count">
                <span class="count_top text-info"><i class="fa fa-user text-warning"></i> Total Users</span>
                <div class="count text-primary">{{ $userCount }}</div>
            </div> --}}
            <div class="col-md-3 col-sm-3  tile_stats_count">
                <span class="count_top text-info"><i class="fa fa-users text-warning"></i> Total Customers</span>
                <div class="count text-primary">{{ $customerCount }}</div>
            </div>
            {{-- <div class="col-md-3 col-sm-4  tile_stats_count">
                <span class="count_top text-info"><i class="fa fa-money text-warning"></i> Total Approved Bills</span>
                <div class="count green text-primary">{{ $approvedBillCount }}</div>
            </div>
            <div class="col-md-3 col-sm-4  tile_stats_count">
                <span class="count_top text-info"><i class="fa fa-money text-warning"></i> Total Rejected Bills</span>
                <div class="count green text-primary">{{ $rejectedBillCount }}</div>
            </div> --}}
            <div class="col-md-3 col-sm-3  tile_stats_count">
                <span class="count_top text-info"><i class="fa fa-money text-warning"></i> Total Bills</span>
                <div class="count green text-primary">{{ $activeBillCount + $inactiveBillCount }}</div>
            </div>
            {{-- <div class="col-md-4 col-sm-4  tile_stats_count">
                <span class="count_top text-info"><i class="fa fa-money text-warning"></i> Total Ative Bills</span>
                <div class="count green text-primary">{{ $activeBillCount }}</div>
            </div> --}}
            {{-- <div class="col-md-3 col-sm-4  tile_stats_count">
                <span class="count_top text-info"><i class="fa fa-money text-warning"></i> Total Inactive Bills</span>
                <div class="count green text-primary">{{ $inactiveBillCount }}</div>
            </div> --}}
            <div class="col-md-3 col-sm-3  tile_stats_count">
                <span class="count_top text-info"><i class="fa fa-file-text text-warning"></i> Total Invoices</span>
                <div class="count text-primary">{{ $invoiceCount }}</div>
            </div>
            <div class="col-md-3 col-sm-3  tile_stats_count">
                <span class="count_top text-info"><i class="fa fa-file-text text-warning"></i> Month Collection</span>
                <div class="count text-primary">{{ number_format($monthCollectionAmount ?? 0, 2);  }}</div>
            </div>
            {{-- <div class="col-md-3 col-sm-4  tile_stats_count">
                <span class="count_top text-info"><i class="fa fa-usd text-warning"></i> Total Collections</span>
                <div class="count text-primary">{{ $collectionCount }}</div>
            </div> --}}
        </div>
    </div>
    <!-- /top tiles -->

    <div class="row">
        <div class="col-md-6 col-sm-6">
            <div class="x_panel tile rounded pt-3">
                <div class="x_title">
                    <h5 class="text-primary">Invoice Summary</h5>
                </div>
                <div class="x_content">
                    <table class="" style="width:100%">
                        <tr>
                            <th>Visual</th>
                            <th>Invoice</th>
                            <th>Percentage</th>
                        </tr>
                        <tr>
                            <td>
                                <canvas class="invoiceChart" width="140" style="margin: 10px"></canvas>
                            </td>
                            <td>
                                <table class="tile_info">
                                    <tr>
                                        <td>
                                            <p><i class="fa fa-square blue"></i>Paid </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <p><i class="fa fa-square red"></i>Unpaid </p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <p><i class="fa fa-square yellow"></i>Partially Paid </p>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                            <td>
                                <table class="tile_info">
                                    <tr>
                                        <td>
                                            <p class="text-primary">{{ $invoiceStats['paidPercentage'] }}%</p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <p class="text-primary">{{ $invoiceStats['unpaidPercentage'] }}%</p>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <p class="text-primary">{{ $invoiceStats['partialPaidPercentage'] }}%</p>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>

            <div class="x_panel tile rounded pt-3">
                <div class="x_title">
                    <h5 class="text-primary">Latest Invoices</h5>
                </div>
                <div class="x_content">
                    <table class="" style="width:100%">
                        <tr>
                            <th>Invoice</th>
                            <th>Bill No</th>
                            <th>Date</th>
                        </tr>
                        @foreach ($invoices->sortByDesc('created_at')->take(5) as $invoice)
                            <tr class="border-bottom">
                                <td class="text-primary">{{ $invoice->invoice_no }}</td>
                                <td>{{ $invoice->bill_id ?? '-' }}</td>
                                <td>{{ $invoice->created_at->diffForHumans() }}</td>
                                {{-- <td><a href="{{ route('invoices.show', $invoice->id) }}"
                                        class="btn btn-info btn-sm">View</a></td> --}}
                            </tr>
                        @endforeach
                    </table>
                </div>
            </div>

        </div>

        <div class="col-md-6 col-sm-6">
            <div class="x_panel tile rounded pt-3" style="padding-bottom: 50px;">
                <div class="x_title">
                    <h5 class="text-primary">Collection Summary (Last 30 days)</h5>
                </div>
                <div class="x_content">
                    <div id="lineChartCollection" class="demo-placeholder"></div>
                </div>
            </div>
            <div class="x_panel tile rounded pt-3">
                <div class="x_title">
                    <h5 class="text-primary">Latest Collections</h5>
                </div>
                <div class="x_content">
                    <table class="" style="width:100%">
                        <tr>
                            <th>Ref No</th>
                            <th>Amount</th>
                            <th>Date</th>
                            {{-- <th>Action</th> --}}
                        </tr>
                        @foreach ($collectionAmount->sortByDesc('created_at')->take(3) as $collection)
                            <tr class="border-bottom">
                                <td class="text-primary">{{ $collection->ref_no ? $collection->ref_no : '-' }}</td>
                                <td class="text-primary">{{ $collection->total_coll_amount ? priceFormat($collection->total_coll_amount) : '-' }}</td>
                                <td>{{ $collection->created_at->diffForHumans() }}</td>
                                {{-- <td><a data-size="lg" class="btn btn-info btn-sm text-white cursor-pointer"
                                        data-url="{{ route('collection.show', $collection->id) }}" data-ajax-popup="true"
                                        data-title="View Collection" data-bs-toggle="tooltip" title="View"
                                        data-original-title="View">View</a></td> --}}
                            </tr>
                        @endforeach
                    </table>
                </div>
            </div>
        </div>

    </div>
@endsection

@section('script')
    <script>
        var chart_doughnut_settings = {
            type: 'doughnut',
            tooltipFillColor: "rgba(51, 51, 51, 0.55)",
            data: {
                labels: [
                    "Paid",
                    "Unpaid",
                    "Partial Paid"
                ],
                datasets: [{
                    data: [{{ $invoiceStats['paidPercentage'] }}, {{ $invoiceStats['unpaidPercentage'] }},
                        {{ $invoiceStats['partialPaidPercentage'] }}
                    ],
                    backgroundColor: [
                        "#2b96cc",
                        "#e74c3c",
                        "#f1c40f"
                    ],
                    hoverBackgroundColor: [
                        "#208fc6",
                        "#c23e30",
                        "#caa50d"
                    ]
                }]
            },
            options: {
                legend: true,
                responsive: false
            }
        }

        var chart_element = $('.invoiceChart');
        var chart_doughnut = new Chart(chart_element, chart_doughnut_settings);
    </script>

    <script>
        var lineData = [];
        @foreach ($collections as $collection)
            {
                let parts = "{{ $collection['date'] }}".split('/');
                let jsDate = new Date(parts[2], parts[1] - 1, parts[0]);

                lineData.push([jsDate.getTime(), {{ $collection['amount'] }}]);
            }
        @endforeach

        var chart_plot_02_settings = {
            grid: {
                show: true,
                aboveData: true,
                color: "#3f3f3f",
                labelMargin: 10,
                axisMargin: 0,
                borderWidth: 0,
                borderColor: null,
                minBorderMargin: 5,
                clickable: true,
                hoverable: true,
                autoHighlight: true,
                mouseActiveRadius: 100
            },
            series: {
                lines: {
                    show: true,
                    fill: true,
                    lineWidth: 2,
                    steps: false
                },
                points: {
                    show: true,
                    radius: 4.5,
                    symbol: "circle",
                    lineWidth: 2.0
                }
            },
            legend: {
                position: "ne",
                margin: [0, -25],
                noColumns: 0,
                labelBoxBorderColor: null,
                labelFormatter: function(label, series) {
                    return label + '&nbsp;&nbsp;';
                },
                width: 40,
                height: 1
            },
            colors: ['#2b96cc'],
            shadowSize: 0,
            tooltip: true,
            tooltipOpts: {
                content: "%s: %y.0",
                xDateFormat: "%d/%m",
                shifts: {
                    x: -30,
                    y: -50
                },
                defaultTheme: false
            },
            yaxis: {
                min: 0,
                tickFormatter: function(val, axis) {
                    // return "{{ $settings['currency_symbol'] }}" + val;
                    return "{{ $settings['currency_symbol'] }}" + val.toFixed(1); // fix (0.6000000000000001)
                }
            },
            xaxis: {
                mode: "time",
                minTickSize: [1, "day"],
                timeformat: "%d/%m/%y",
                min: lineData[0][0],
                max: lineData[29][0],
            }
        };

        if ($("#lineChartCollection").length) {
            $.plot($("#lineChartCollection"),
                [{
                    // label: "Bill Collections ({{ $settings['currency'] }})",
                    label: "Bill Collections",
                    data: lineData,
                    lines: {
                        fillColor: "rgba(43, 150, 204, 0.12)"
                    },
                    points: {
                        fillColor: "#fff"
                    }
                }], chart_plot_02_settings);

            $("#lineChartCollection .flot-x-axis .flot-tick-label").css({
                'white-space': 'nowrap',
                'transform': 'rotate(-90deg)',
                'transform-origin': 'left top',
                'margin-top': '60px',
                'margin-left': '15px'
            });

        }
    </script>
@endsection
