<form action="{{ route('customer-bank.update', $customerBank->id) }}" method="POST" autocomplete="off">
    @csrf
    @method('PATCH')

    <div class="modal-body">
        <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <label for="customer_id">Customer* :</label>
                    <select id="customer_id" name="customer_id" class="form-control select2" required>
                        <option value="">--Select Customer--</option>
                        @foreach ($customers as $customer)
                            <option value="{{$customer->id}}"  {{ $customerBank->customer_id == $customer->id ? 'selected' : '' }}>{{$customer->customer_name}}</option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="bank_id">Bank ID*</label>
                    <input type="text" class="form-control" id="bank_id" name="bank_id" placeholder="Enter Bank ID" value="{{ $customerBank->bank_id }}" required>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="bank_name">Bank Name*</label>
                    <input type="text" class="form-control" id="bank_name" name="bank_name" placeholder="Enter Bank Name" value="{{ $customerBank->bank_name }}" required>
                </div>
            </div>
            <div class="col-md-12">
                <div class="form-group">
                    <label for="address">Address*</label>
                    <textarea class="form-control" id="address" name="address" rows="3" placeholder="Enter Address" required>{{ $customerBank->address }}</textarea>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="email">Email*</label>
                    <input type="email" class="form-control" id="email" name="email" placeholder="Enter Email" value="{{ $customerBank->email }}" required>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label for="phone">Phone*</label>
                    <input type="number" class="form-control" id="phone" name="phone" placeholder="Enter Phone" value="{{ $customerBank->phone }}" required>
                </div>
            </div>
            <div class="col-md-12">
                <div class="form-group">
                    <label for="fax">Fax</label>
                    <input type="number" class="form-control" id="fax" name="fax" placeholder="Enter Fax" value="{{ $customerBank->fax }}">
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <input type="button" value="{{ __('Cancel') }}" class="btn btn-danger" data-dismiss="modal">
        <input type="submit" value="{{ __('Update') }}" class="btn btn-primary">
    </div>
</form>
<script>
    $('.select2').select2({
        dropdownParent: $('#commonModal')
    });
</script>
