@extends('layouts.app')

@section('title')
Customers
@endsection

@section('content')
<div class="row d-flex align-items-center mb-3">
    <div class="col-md-6">
        <h4 class="text-primary mb-0">Manage Customers</h4>
    </div>
    @can('Create Customer')
        <div class="col-md-6 text-right">
            <a href="{{ route('customers.create') }}" class="btn btn-primary">Add New</a>
        </div>
    @endcan
</div>


<div>
    <form action="{{ route('customers.index') }}" method="GET" class="mb-3" autocomplete="off">
        <div class="input-group col-md-5">
            <input type="text" name="search" class="form-control search-input" placeholder="Customer name or ID" value="{{ request('search') }}">
            <div class="input-group-append">
                <button style="height: 41px" type="submit" class="btn btn-primary">Search</button>
            </div>
            <a href="{{ route('customers.index') }}" style="height: 41px; border-radius:initial;" class="btn btn-danger">Clear</a>
        </div>
    </form>

    <form action="{{ route('customers.index') }}" method="GET" class="num_filter px-4">
        <label for="per_page">Show</label>
        <select name="per_page" id="per_page" onchange="this.form.submit()" style="height: 40px; width: 70px; border: 1px solid #ced4da; border-radius: 4px">
            <option value="25" {{ $perPage == 25 ? 'selected' : '' }}>25</option>
            <option value="50" {{ $perPage == 50 ? 'selected' : '' }}>50</option>
            <option value="100" {{ $perPage == 100 ? 'selected' : '' }}>100</option>
            <option value="{{ $customers->total() }}" {{ $perPage == $customers->total() ? 'selected' : '' }}>All</option>
        </select>
        Entries
    </form>
</div>



<div class="row">
    <table id="datatable-buttons" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th>Sl No</th>
                <th>Customer ID</th>
                <th>Customer Name</th>
                <th>Phone</th>
                <th>BIN No</th>
                <th>Attention Person</th>
                <th>AutoAC No</th>
                <th>Status</th>
                <th>Action</th>
            </tr>
        </thead>

        <tbody>
            @php
                $currentPage = $customers->currentPage();
                $perPage = $customers->perPage();
                $startNumber = ($currentPage - 1) * $perPage + 1;
            @endphp

            @foreach ($customers as $index => $customer)
                <tr>
                    <td>{{ $startNumber + $index }}</td>
                    <td>{{ $customer->id }}</td>
                    <td>{{ $customer->customer_name }}</td>
                    <td>{{ $customer->phone }}</td>
                    <td>{{ $customer->bin_no }}</td>
                    <td>{{ $customer->attentionPerson->attention_name ?? '' }}</td>
                    <td>{{ $customer->autoAcNo }}</td>
                    <td>
                        @if ($customer->status=='Inactive')
                            <span style="color:red"><b>{{$customer->status}}</b></span>
                        @else
                            {{$customer->status}}
                        @endif
                    </td>
                    <td>
                        <a data-size="lg" class="btn btn-info btn-sm text-white cursor-pointer"
                            data-url="{{ route('customers.show', $customer->id) }}" data-ajax-popup="true"
                            data-title="View Customer" data-bs-toggle="tooltip" title="View"
                            data-original-title="View">View</a>

                        @can('Edit Customer')
                            <a href="{{ route('customers.edit', $customer->id) }}" class="btn btn-success btn-sm">Edit</a>
                        @endcan

                        @can('Delete Customer')
                            <form id="delete-form-{{ $customer->id }}" class="d-inline"
                                action="{{ route('customers.destroy', $customer->id) }}" method="POST">
                                @csrf
                                @method('DELETE')
                                <a class="btn btn-danger btn-sm alert-btn text-white cursor-pointer">Delete</a>
                            </form>
                        @endcan
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <div class="row">
        <div class="col-md-12 d-flex justify-content-between">
            <div>
                Showing {{ $customers->firstItem() }} to {{ $customers->lastItem() }} of {{ $customers->total() }}
                entries
            </div>
            <div>
                {{ $customers->appends(['per_page' => $perPage])->links('vendor.pagination.custom-pagination') }}
            </div>
        </div>
    </div>
</div>

<style>
    {
        display: inline-block;
        position: absolute;
        z-index: 2;
    }
</style>

<style>
    body {
        margin: 0;
        padding: 0;
        height: 100vh;
        display: flex;
        flex-direction: column;
    }

    .container {
        flex: 1;
        overflow-y: auto;
    }

    .row {
        flex-grow: 1;
    }

    .table-responsive {
        max-height: calc(100vh - 250px);
        overflow-y: auto;
    }
</style>


@endsection
