@extends('layouts.app')

@section('title')
    Customer Name Fixing
@endsection

@section('content')
<div class="row d-flex align-items-center mb-3">
    <div class="col-md-6">
        <h4 class="text-primary mb-0">Customer Name Fixing</h4>
    </div>
</div>

<form action="{{ route('customer-name-fixing-update') }}" method="POST" id="customerNameFixForm">
    @csrf

    <div class="row">
        <h6>Total Customers: {{ $customers->count() }}</h6>

        <table class="table table-striped table-bordered" style="width:100%">
            <thead>
                <tr>
                    <th>Sl</th>
                    <th>AutoAcNo</th>
                    <th>Customer ID</th>
                    <th>Customer Name</th>
                    <th>Check</th>
                    <th>Customer New Name</th>
                </tr>
            </thead>

            <tbody>
                @foreach ($customers as $row)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $row->autoAcNo }}</td>
                    <td>
                        {{ $row->id }}
                        <input type="hidden" name="customer_ids[]" value="{{ $row->id }}">
                    </td>
                    <td class="customer_name">{{ $row->customer_name }}</td>

                    <td style="background: #fff; text-align:center;width:20px;vertical-align:middle">
                        <input type="checkbox" class="custom-checkbox customer-check"
                            id="selected_customers_{{ $row->id }}" name="selected_customers[]" value="{{ $row->id }}">
                        <label for="selected_customers_{{ $row->id }}"></label>
                    </td>

                    <td>
                        <input type="text" class="form-control customer_new_name"
                            name="customer_new_name[{{ $row->id }}]" value="" disabled>
                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>

        <div class="submit-btn-wrapper d-none" style="text-align: center; width:100%">
            <button type="submit" class="btn btn-primary mt-3">
                Update Customer Name
            </button>
        </div>

    </div>
</form>

<script>
$(document).ready(function () {

    // ------------------------------------------
    // 1️⃣ SHOW submit button after full page loads
    // ------------------------------------------
    $('.submit-btn-wrapper').removeClass('d-none');


    // ------------------------------------------
    // 2️⃣ Prevent form submit with ENTER key
    // ------------------------------------------
    $('#customerNameFixForm').on('keypress', function (e) {
        if (e.key === "Enter") {
            e.preventDefault();
            return false;
        }
    });

    // ------------------------------------------
    // 3️⃣ Auto enable input + fill name on checkbox check
    // ------------------------------------------
    $(document).on('change', '.customer-check', function () {

        let row = $(this).closest('tr');
        let name = row.find('.customer_name').text().trim();
        let input = row.find('.customer_new_name');

        if ($(this).is(':checked')) {
            input.prop('disabled', false);
            input.val(name);
        } else {
            input.prop('disabled', true);
            input.val('');
        }
    });


    // ------------------------------------------
    // 4️⃣ FORM VALIDATION + prevent multiple submit
    // ------------------------------------------
    let formSubmitting = false;

    $('#customerNameFixForm').on('submit', function (e) {

        if (formSubmitting) {
            e.preventDefault();
            return false;
        }

        // Check if any checkbox is checked
        let checked = $('.customer-check:checked');
        if (checked.length === 0) {
            alert("Please select at least one customer to update.");
            e.preventDefault();
            return false;
        }

        // Validate each checked row
        let invalidInput = null;

        checked.each(function () {
            let row = $(this).closest('tr');
            let input = row.find('.customer_new_name');
            let value = input.val().trim();

            if (value === "" || value === null) {
                invalidInput = input;  // store first empty input
                return false; // break loop
            }
        });

        if (invalidInput) {
            alert("Customer new name cannot be empty!");
            invalidInput.focus();
            e.preventDefault();
            return false;
        }

        // All good → block further submissions
        formSubmitting = true;
        $(this).find("button[type=submit]").attr("disabled", true).text("Processing…");
    });

});
</script>


@endsection
