@extends('layouts.app')
@section('title')
    Customer Create
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Customer Create</h4>
        </div>
        <div class="col-md-6 text-right">
            <a href="{{ route('customers.index') }}" class="btn btn-primary">Customers</a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_content" style="padding:0">

                    <form id="customerForm" autocomplete="off">
                        @csrf

                        <div class="row">
                            <div class="col-md-6">
                                <label for="customer_name">Customer Name* :</label>
                                <input type="text" id="customer_name" class="form-control" name="customer_name"
                                    required />
                            </div>
                            <div class="col-md-6">
                                <label for="divCode">Department* :</label>
                                <select id="divCode" name="divCode" class="form-control" required>
                                    <option value="000">Common</option>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label for="phone">Phone/Telephone* :</label>
                                <input type="text" id="phone" class="form-control" name="phone" required />
                            </div>
                            <div class="col-md-6">
                                <label for="attention_person">Attention Person :</label>
                                <input type="text" id="attention_person" class="form-control" name="attention_person" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label for="bin_no">BIN No* :</label>
                                <input type="text" id="bin_no" class="form-control" name="bin_no" required />
                            </div>
                            <div class="col-md-6">
                                <label for="autoAcNo">Account Customer* :</label>
                                <select id="autoAcNo" name="autoAcNo" class="form-control select2" required>
                                    <option value="">--Select Account Customer--</option>
                                    @if ($acCustomers)
                                        @foreach ($acCustomers as $row)
                                        <option value="{{$row['autoAcNo']}}">{{$row['udAcName']}}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <label for="address">Address :</label>
                                <textarea id="address" class="form-control" name="address"></textarea>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <h5 class="mb-0 text-primary">Billing Contact</h5>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label for="billing_name">Billing Name* :</label>
                                <input type="text" id="billing_name" class="form-control" name="billing_name" required />
                            </div>
                            <div class="col-md-6">
                                <label for="billing_phone">Billing Phone/Telephone* :</label>
                                <input type="text" id="billing_phone" class="form-control" name="billing_phone"
                                    required />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <label for="billing_email">Billing Email* :</label>
                                <input type="email" id="billing_email" class="form-control" name="billing_email"
                                    required />
                            </div>
                            <div class="col-md-6">
                                <label for="status">Status* :</label>
                                <select id="status" name="status" class="form-control" required>
                                    <option value="Active">Active</option>
                                    <option value="Inactive">Inactive</option>
                                </select>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <br />
                                <a href="{{ route('customers.index') }}" class="btn btn-info">Cancel</a>
                                <a class="btn btn-primary" id="btnSubmit" style="color:#fff">Submit</a>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
    <style>
        form label {
            margin-bottom: 2px;
            margin-top: 8px;
        }
    </style>

    <script>
        $('#btnSubmit').click(function() {
            let valid = true;

            $('#customerForm').find('input[required]').each(function() {
                if (!$(this).val()) {
                    valid = false;
                    show_toastr('error', 'Missing required field');
                    $(this).focus();
                    return false;
                }
            });

            if (valid) {
                // const phoneRegex = /^01[3-9][0-9]{8}$/;

                // const phone = $('#phone').val();
                // const billingPhone = $('#billing_phone').val();
                // const accountPhone = $('#account_phone').val();

                // if (!phoneRegex.test(phone)) {
                //     valid = false;
                //     show_toastr('error', 'Phone number must be valid.');
                //     $('#phone').focus();
                //     return false;
                // }

                // if (!phoneRegex.test(billingPhone)) {
                //     valid = false;
                //     show_toastr('error', 'Billing phone must be valid.');
                //     $('#billing_phone').focus();
                //     return false;
                // }

                if (valid) {
                    var autoAcNo = $('#autoAcNo').val();
                    if (autoAcNo == '') {
                        show_toastr('error', 'Missing required field');
                        return false;
                    } else {
                        $.ajax({
                            type: 'GET',
                            url: '{{url("checkAccountCustomer")}}/0/' + autoAcNo,
                            success: function(data) {
                                if (data == '1') {
                                    $('#customerForm').attr("method", "post");
                                    $('#customerForm').attr("action", "{{ route('customers.store') }}");
                                    $('#customerForm').submit();
                                } else {
                                    show_toastr('error', 'Account Customer already used, please select another');
                                    return false;
                                }
                            }
                        });
                    }
                }
            }
        });
    </script>



@endsection
