@extends('layouts.app')

@section('title')
AIT & VDS List
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">AIT & VDS List</h4>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_content" style="padding:0">
                    <form action="{{ route('collection.ait') }}" method="GET">
                        <div class="row d-flex align-items-end">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="type">Certificate :</label>
                                    <select id="type" name="type" class="form-control">
                                        <option value="2" {{ (request('type')=='2')? 'selected':'' }}>Not Submitted</option>
                                        <option value="1" {{ (request('type')=='1')? 'selected':'' }}>Submitted</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="start_date">Start Date</label>
                                    <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                        <input type="text" class="form-control has-feedback-left custom-datepicker"
                                            name="start_date" id="start_date" value="{{ request('start_date') }}"
                                            placeholder="dd/mm/yyyy" autocomplete="off">
                                        <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                        <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="end_date">End Date</label>
                                    <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                        <input type="text" class="form-control has-feedback-left custom-datepicker"
                                            name="end_date" id="end_date" value="{{ request('end_date') }}"
                                            placeholder="dd/mm/yyyy" autocomplete="off">
                                        <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                        <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-1 px-1">
                                <div class="form-group">
                                    <button class="btn btn-primary btn-block" type="submit">Filter</button>
                                </div>
                            </div>
                            <div class="col-md-1 px-1">
                                <div class="form-group">
                                    <a href="{{ route('collection.ait') }}" class="btn btn-danger btn-block">Clear</a>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @if(request('type')!='')

    <form action="{{ route('collection.index') }}" method="GET" class="num_filter px-4">
        <label for="per_page">Show</label>
        <select name="per_page" id="per_page" onchange="this.form.submit()" style="height: 40px; width: 70px; border: 1px solid #ced4da; border-radius: 4px">
            <option value="25" {{ $perPage == 25 ? 'selected' : '' }}>25</option>
            <option value="50" {{ $perPage == 50 ? 'selected' : '' }}>50</option>
            <option value="100" {{ $perPage == 100 ? 'selected' : '' }}>100</option>
            <option value="{{ $collections->total() }}" {{ $perPage == $collections->total() ? 'selected' : '' }}>All</option>
        </select>
        Entries
        @foreach (request()->except('per_page', 'page') as $key => $value)
            <input type="hidden" name="{{ $key }}" value="{{ $value }}">
        @endforeach
    </form>



    <div class="row">
        <table id="datatable-buttons" class="table table-striped table-bordered" style="width:100%">
            <thead>
                <tr>
                    <th>Sl No</th>
                    <th>Ref No</th>
                    <th>Posting Date</th>
                    <th>Customer</th>
                    <th>TDS Amount</th>
                    <th>VDS Amount</th>
                    <th>TDS Certificate</th>
                    <th>VDS Certificate</th>
                    @if(request('type')==2)
                    <th>Action</th>
                    @endif
                </tr>
            </thead>

            <tbody>
                @foreach ($collections as $row)
                    <tr>
                        <td>{{ $loop->iteration + ($collections->currentPage() - 1) * $collections->perPage() }}</td>
                        <td>{{ $row->ref_no ? $row->ref_no : '-' }}</td>
                        <td>{{ $row->bank_deposit_date ? $row->bank_deposit_date : '-' }}</td>
                        <td>{{ $row->customer ? $row->customer->customer_name : '-' }}</td>
                        <td>{{ \App\Models\Settings::priceFormat($row->tds_amount) }}</td>
                        <td>{{ \App\Models\Settings::priceFormat($row->vat_amount) }}</td>
                        <td>
                            @if($row->tds_certificate!='')
                                @php
                                    $tdsUrl = asset('storage/vds-certificate/' . $row->tds_certificate);
                                @endphp
                                <a href="{{$tdsUrl}}" target="_blank" title="view"><u>{{$row->tds_certificate}}</u></a>
                            @endif
                        </td>
                        <td>
                            @if($row->vds_certificate!='')
                                @php
                                    $vdsUrl = asset('storage/vds-certificate/' . $row->vds_certificate);
                                @endphp
                                <a href="{{$vdsUrl}}" target="_blank" title="view"><u>{{$row->vds_certificate}}</u></a>
                            @endif
                        </td>
                        @if(request('type')==2)
                        <td>
                            <a data-size="lg" class="btn btn-info btn-sm text-white cursor-pointer"
                                data-url="{{ route('vds.upload.page', $row->id) }}" data-ajax-popup="true"
                                data-title="Upload Certificate" data-bs-toggle="tooltip" title="View"
                                data-original-title="Upload">Upload</a>
                        </td>
                        @endif
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>

    <div class="row">
        <div class="col-md-12 d-flex justify-content-between">
            <div>
                Showing {{ $collections->firstItem() }} to {{ $collections->lastItem() }} of {{ $collections->total() }} entries
            </div>
            <div>
                {{ $collections->appends(request()->except('page'))->links('vendor.pagination.custom-pagination') }}
            </div>
        </div>
    </div>

    @endif


    <style>
        {
            display: inline-block;
            position: absolute;
            z-index: 2;
        }
    </style>

    <style>
        body {
            margin: 0;
            padding: 0;
            height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .container {
            flex: 1;
            overflow-y: auto;
        }

        .row {
            flex-grow: 1;
        }

        .table-responsive {
            max-height: calc(100vh - 250px);
            overflow-y: auto;
        }
    </style>


@endsection
