@if ($bills)
<table id="datatable-buttonsqq" class="table table-striped table-bordered gridTable" style="width:100%">
    <thead>
        <tr>
            <th></th>
            <th>Invoice<br>No</th>
            <th class="text-right">Invoice<br>Value</th>
            <th class="text-right">Collected<br>Amount</th>
            <th class="text-right">Remaining<br>Amount</th>
            <th class="text-right">Collection<br>Amount</th>
            <th></th>
        </tr>
    </thead>

    <tbody id="showBillList">
            @foreach ($bills as $row)
                @php
                    $billId = $row->id;
                    $totalPaid = 0;
                    $paidInfo = DB::selectOne("SELECT IFNULL(SUM(CAST(collection_amount AS DOUBLE)),0) AS total_paid
                    FROM collection_chds
                    WHERE bill_process_id=$billId AND delete_flag=0");
                    if ($paidInfo) {
                        $totalPaid = $paidInfo->total_paid;
                    }
                @endphp
                <tr>
                    <td class="text-center" width="45px">
                        <input type="checkbox" class="custom-checkbox" onchange="changeAmount($(this))" id="selected_bills_{{ $row->id }}"
                            name="selected_bills[]" value="{{ $row->id }}" /><label
                            for="selected_bills_{{ $row->id }}"></label>
                    </td>
                    <td style="padding: 0px 10px !important">
                        <input type="hidden" class="form-control billId" name="billId[]"
                            value="{{ $row->id }}">
                        <nobr>{{ $row->invoice_no }}</nobr>
                    </td>
                    <td><input type="text" class="form-control totalAmt readmode" name="totalAmt[]"
                            value="{{ $row->total_amount_vat }}"></td>
                    <td><input type="text" class="form-control collectedAmt readmode"
                            name="collectedAmt[]" value="{{ $totalPaid }}"></td>
                    <td><input type="text" class="form-control remainingAmt readmode"
                            name="remainingAmt[]" value="{{ $row->total_amount_vat - $totalPaid }}"></td>
                    <td><input type="text" class="form-control collectionAmt readmode"
                            name="collectionAmt[]"></td>

                    <td style="width:38px;text-align:center;font-size:20px;">
                        <span class="flagPaid" style="display:none;"><i class="fa fa-check"
                                style="color:#0bbd0b;"></i></span>
                        @if ($row->payment_status != 'Paid' || ($row->payment_status = '' || $row->payment_status == null))
                            <span class="flagUnpaid"><i class="fa fa-close"
                                    style="color:#FF0000;"></i></span>
                        @endif
                        <input type="hidden" class="form-control flagStatus" name="flagStatus[]"
                            value="{{ $row->payment_status }}">
                    </td>

                </tr>
            @endforeach
    </tbody>
</table>
<div class="row">
    <div class="col-md-12 text-center">
        <br />
        <a href="{{ route('collection.index') }}" class="btn btn-info">Cancel</a>
        <button class="btn btn-primary" id="btnSubmit">Collection Submit</button>
    </div>
</div>

<script>
    $('#btnSubmit').click(function() {

        if ($('#customer_id').val() == '') {
            show_toastr('error', 'Missing Customer');
            return false;
        }

        var Xadvance_amount = parseFloat($('#advance_amount').val());
        if (isNaN(Xadvance_amount) || Xadvance_amount == "") { Xadvance_amount = 0; }

        var Xdeducted_amount = parseFloat($('#deducted_amount').val());
        if (isNaN(Xdeducted_amount) || Xdeducted_amount == "") { Xdeducted_amount = 0; }

        if($('#set_adjustment').is(":checked")){
            if(Xdeducted_amount>Xadvance_amount){
                show_toastr('error', 'Deducted amount is grater than advanced amount');
                return false;
            }
        }

        var Xtotal_remaining = parseFloat($('#total_remaining').val());
        if (isNaN(Xtotal_remaining) || Xtotal_remaining == "") { Xtotal_remaining = 0; }

        if(Xtotal_remaining>0){
            show_toastr('error', 'Collection amount is greater than total bill amount');
            return false;
        }

        if ($('#bank_deposit_date').val() == '') {
            show_toastr('error', 'Missing Posting Date');
            return false;
        }

        // Check negative number
        var negate = false;
        var NEGdeducted_amount = parseFloat($('#deducted_amount').val());
        if (!isNaN(NEGdeducted_amount) && NEGdeducted_amount<0) { negate = true; }

        var NEGtotalRcvAmt = parseFloat($('#received_amount').val());
        if (!isNaN(NEGtotalRcvAmt) && NEGtotalRcvAmt<0) { negate = true; }

        var NEGtotalTdsAmt = parseFloat($('#tds_amount').val());
        if (!isNaN(NEGtotalTdsAmt) && NEGtotalTdsAmt<0) { negate = true; }

        var NEGtotalVatAmt = parseFloat($('#vat_amount').val());
        if (!isNaN(NEGtotalVatAmt) && NEGtotalVatAmt<0) { negate = true; }

        var NEGtotalAdjAmt = parseFloat($('#adjust_amount').val());
        if (!isNaN(NEGtotalAdjAmt) && NEGtotalAdjAmt<0) { negate = true; }

        if(negate){
            show_toastr('error', 'Amount should not be negative');
            return false;
        }


        var totalRcvAmt = parseFloat($('#received_amount').val());
        if (isNaN(totalRcvAmt) || totalRcvAmt == "") { totalRcvAmt = 0; }

        var totalTdsAmt = parseFloat($('#tds_amount').val());
        if (isNaN(totalTdsAmt) || totalTdsAmt == "") { totalTdsAmt = 0; }

        var totalVatAmt = parseFloat($('#vat_amount').val());
        if (isNaN(totalVatAmt) || totalVatAmt == "") { totalVatAmt = 0; }

        var totalAdjAmt = parseFloat($('#adjust_amount').val());
        if (isNaN(totalAdjAmt) || totalAdjAmt == "") { totalAdjAmt = 0; }

        var totalAmt = totalRcvAmt + totalTdsAmt + totalVatAmt;


        // only advanced amount
        if(totalAmt==0 && totalAdjAmt==0 && Xdeducted_amount>0){
            // proceed to submit
            $('#collectionForm').attr('method', 'post');
            $('#collectionForm').attr('action', '{{ route('collection.store') }}');
            $("#collectionForm").submit();
            $('#btnSubmit').prop('disabled', true);
            $('#btnSubmit').html(
                        '<span class="spinner-border spinner-border-sm mb-1" role="status" aria-hidden="true"></span> Processing...'
                    );
            return false;
        }

        // only bad depts
        if((totalAmt==0 && totalAdjAmt>0) || totalAmt>0){
            if ($('#instrument_mode').val() == '') {
                show_toastr('error', 'Missing Instrument Mode');
                return false;
            }

            if ($('#instrument_mode').val() == 'Cheque' || $('#instrument_mode').val()=='BEFTN' || $('#instrument_mode').val()=='Pay Order'){
                // if ($('#instrument_no').val() == '') {
                //     show_toastr('error', 'Missing Instrument No');
                //     return false;
                // }

                // if ($('#instrument_date').val() == '') {
                //     show_toastr('error', 'Missing Instrument Date');
                //     return false;
                // }

                if ($('#bank_id').val() == '') {
                    show_toastr('error', 'Missing Customer Bank');
                    return false;
                }
                if ($('#dep_bank_id').val() == '') {
                    show_toastr('error', 'Missing Depository Account Name');
                    return false;
                }

            }else if ($('#instrument_mode').val() == 'Cash') { // mode = cash
                if ($('#dep_cash_id').val() == '') {
                    show_toastr('error', 'Missing Depository Account Name');
                    return false;
                }
            }else{}

        }

        if(totalAdjAmt>0){
            if ($('#adj_remarks').val().trim() == '') {
                show_toastr('error', 'Missing Adjustment Remarks');
                return false;
            }
        }

        var totalColAmt = parseFloat($('#total_coll_amount').val());
        if (isNaN(totalColAmt) || totalColAmt == "" || totalColAmt == 0) {
            show_toastr('error', 'Missing Collection Amount');
            return false;
        } else {
            // proceed to submit

            // alert('SUBMIT');
            // return false;
            $('#collectionForm').attr('method', 'post');
            $('#collectionForm').attr('action', '{{ route('collection.store') }}');
            $("#collectionForm").submit();
            $('#btnSubmit').prop('disabled', true);
            $('#btnSubmit').html(
                        '<span class="spinner-border spinner-border-sm mb-1" role="status" aria-hidden="true"></span> Processing...'
                    );
        }

    });
</script>
<style>
    .text-center{
        text-align: center;
    }
</style>
@else

@endif
