@extends('layouts.app')

@php
    use Illuminate\Support\Facades\DB;
@endphp

@section('title')
    Collection & Receive
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Collection & Receive Form:</h4>
        </div>
        <div class="col-md-6 text-right">
            <a href="{{ route('collection.index') }}" class="btn btn-primary">Collection List</a>
        </div>
    </div>

    <form name="collectionForm" id="collectionForm" autocomplete="off" enctype="multipart/form-data">
        @csrf
        <div class="row">
            <div class="col-md-12">
                <div class="x_panel p-10">
                    <div class="x_content collectionBox" style="padding:0">
                        <div class="row">
                            <div class="col-md-6">
                                <label for="customer_id">Customer* :</label>
                                <select id="customer_id" name="customer_id" class="form-control select2" required>
                                    <option value="">--Select Customer--</option>
                                    @foreach ($customers as $customer)
                                        <option value="{{ $customer->autoAcNo }}">{{ $customer->customer_name }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="advance_amount">Advance Amount :</label>
                                <input type="text" id="advance_amount" class="form-control readmode" name="advance_amount"/>
                            </div>
                            <div class="col-md-3">
                                <label for="deducted_amount">Deducted Amount :</label>
                                <div style="width:90%;float:left">
                                    <input type="number" id="deducted_amount" class="form-control readmode" name="deducted_amount"
                                        onkeyup="calcAmount()"/>
                                </div>
                                <div style="width:10%;float:right">
                                    <input type="checkbox" id="set_adjustment" name="set_adjustment"
                                        onchange="setAdjustment()" value="1"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-3">
                                <label for="department_id">Department :</label>
                                <select id="department_id" name="department_id" class="form-control readmode" required>
                                    {{-- <option value="">--Select Department--</option> --}}
                                    @foreach ($departments as $row)
                                    @if($row['divCode']=='001')
                                    <option value="{{$row['divCode']}}">{{$row['divName']}}</option>
                                    @endif
                                    @endforeach
                                </select>
                                <input type="hidden" id="depDivName" name="depDivName" value="P & A">
                            </div>
                            <div class="col-md-3">
                                <label for="instrument_mode">Instrument Mode :</label>
                                <select id="instrument_mode" name="instrument_mode" class="form-control">
                                    <option value="">--Select Mode--</option>
                                    <option value="Cheque">Cheque</option>
                                    <option value="Cash">Cash</option>
                                    <option value="BEFTN">BEFTN/RTGS</option>
                                    <option value="Pay Order">Pay Order</option>
                                </select>
                            </div>
                            <div class="col-md-3 instrumentBox">
                                <label for="instrument_no" class="instrument_no_label">Instrument No :</label>
                                <input type="text" id="instrument_no" class="form-control" name="instrument_no" />
                            </div>
                            <div class="col-md-3 instrumentBox">
                                <label for="instrument_date" class="instrument_date_label">Instrument Date :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker"
                                        name="instrument_date" id="instrument_date" placeholder="dd/mm/yyyy"
                                        autocomplete="off">
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                        </div>

                        <div class="row" style="text-align:center">
                            <div class="col-md-6 attachment-box" style="display: none; margin:auto">
                                <label for="attachment">Cheque/BEFTN/Pay Order Attachment :</label>
                                <input type="file" name="attachment" class="form-control">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <label for="bank_id" class="bank_id_label">Bank Name* :</label>
                                <select id="bank_id" name="bank_id" class="form-control select2">
                                    <option value="">--Select Bank--</option>
                                    @if ($banks)
                                        @foreach ($banks as $row)
                                            <option value="{{ $row->id }}">{{ $row->bank_name }}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                            <div class="col-md-6 dep_bank">
                                <label for="dep_bank_id">Depository Bank Name* :</label>
                                <select id="dep_bank_id" name="dep_bank_id" class="form-control select2">
                                    <option value="">--Select Depository Bank Name--</option>
                                    @if ($depBanks)
                                        @foreach ($depBanks as $row)
                                            <option value="{{$row['autoAcNo']}}">{{$row['udAcName']}}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                            <div class="col-md-6 dep_cash" style="display:none">
                                <label for="dep_cash_id">Depository Account Name* :</label>
                                <select id="dep_cash_id" name="dep_cash_id" class="form-control select2">
                                    <option value="">--Select Depository Account Name--</option>
                                    @if ($depCash)
                                        @foreach ($depCash as $row)
                                            <option value="{{$row['autoAcNo']}}">{{$row['udAcName']}}</option>
                                        @endforeach
                                    @endif
                                </select>
                            </div>
                            <input type="hidden" id="account_name" name="account_name">
                        </div>

                        <div class="row">
                            <div class="col-md-3">
                                <label for="received_amount">Received Amount :</label>
                                <input type="number" id="received_amount" class="form-control" name="received_amount"
                                    onkeyup="calcAmount()" />
                            </div>
                            <div class="col-md-3">
                                <label for="tds_amount">TDS Amount :
                                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Is Received&nbsp;
                                <input type="checkbox" id="set_tds" name="set_tds"
                                    onchange="showTDSCertificate()" value="1"/></label>

                                <input type="number" id="tds_amount" class="form-control" name="tds_amount"
                                    onkeyup="calcAmount()" />
                            </div>
                            <div class="col-md-3">
                                <label for="vat_amount">VDS Amount :
                                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Is Received&nbsp;
                                    <input type="checkbox" id="set_vds" name="set_vds"
                                        onchange="showVDSCertificate()" value="1"/></label>

                                <input type="number" id="vat_amount" class="form-control" name="vat_amount"
                                    onkeyup="calcAmount()" />
                            </div>
                            <div class="col-md-3">
                                <label for="adjust_amount">Adjust Amount :</label>
                                <input type="number" id="adjust_amount" class="form-control" name="adjust_amount"
                                    onkeyup="calcAmount()" />
                            </div>
                        </div>
                        <div class="row" style="text-align:center">
                            <div class="col-md-6 tds-certificate-box" style="display: none; margin:auto">
                                <label for="tds_certificate">TDS Certificate :</label>
                                <input type="file" name="tds_certificate" class="form-control">
                            </div>
                            <div class="col-md-6 vds-certificate-box" style="display: none; margin:auto">
                                <label for="vds_certificate">VDS Certificate :</label>
                                <input type="file" name="vds_certificate" class="form-control">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <label for="total_coll_amount">Total Collection Amount :</label>
                                <input type="number" id="total_coll_amount" class="form-control readmode"
                                    name="total_coll_amount" />
                                <input type="hidden" id="total_remaining" class="form-control readmode"
                                    name="total_remaining" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-3">
                                <label for="money_receipt_no">Money Receipt No :</label>
                                <input type="text" id="money_receipt_no" class="form-control"
                                    name="money_receipt_no" />
                            </div>
                            <div class="col-md-3">
                                <label for="money_receipt_date">Money Receipt Date :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker"
                                        name="money_receipt_date" id="money_receipt_date" placeholder="dd/mm/yyyy"
                                        autocomplete="off" value="{{date('d/m/Y')}}">
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <label for="bank_slip_no" class="bank_slip_no_label">Bank Slip No :</label>
                                <input type="text" id="bank_slip_no" class="form-control" name="bank_slip_no" />
                            </div>
                            <div class="col-md-3">
                                <label for="bank_deposit_date" class="bank_deposit_date_label">Posting Date* :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker"
                                        name="bank_deposit_date" id="bank_deposit_date" placeholder="dd/mm/yyyy"
                                        autocomplete="off">
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <label for="adj_remarks">Adjustment Remarks :</label>
                                <textarea id="adj_remarks" class="form-control" name="adj_remarks"></textarea>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>


        {{-- grid table  --}}
        <div class="col-md-12">
            <div class="row" id="resultBox" style="width:100%">
            </div>
        </div>
    </form>

    <style>
        form label {
            margin-bottom: 2px;
            margin-top: 8px;
        }

        .collectionBox label {
            color: #2c2b2b;
        }

        .collectionBox input,
        .collectionBox select {
            padding: 3px 7px;
            height: 38px;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            height: 38px;
        }

        .select2-container--default .select2-selection--single,
        .select2-container--default .select2-selection--multiple {
            min-height: 38px;
        }

        .gridTable thead th {
            padding: 5px;
        }

        .gridTable tbody td {
            padding: 0px !important;
            vertical-align: middle !important;
        }

        .gridTable tbody td input {
            height: 38px;
            text-align: right;
        }
    </style>

    <style>
        #set_adjustment{
            width: 20px;
            height: 20px;
            float: right;
            margin-top: 7px;
        }
        #set_tds, #set_vds{
            width: 16px;
            height: 16px;
            float: right;
            margin-top: 5px;
        }
    </style>

@endsection

@section('script')
    <script>
         // Customer changing function
        $('#customer_id').change(function() {
            $('#resultBox').html('');
            $('#ref_no').val('');
            $('#instrument_mode').val('');
            $('#instrument_no').val('');
            $('#instrument_date').val('');
            $('#bank_id').val('').trigger('change');
            $('#received_amount').val('');
            $('#tds_amount').val('');
            $('#vat_amount').val('');
            $('#adjust_amount').val('');
            $('#total_coll_amount').val('');
            $('#total_remaining').val(0);
            $('#money_receipt_no').val('');
            $('#bank_slip_no').val('');
            $('#bank_deposit_date').val('');
            $('#dep_cash_id').val('').trigger('change');
            $('#dep_bank_id').val('').trigger('change');
            $('#advance_amount').val(0);

            var customerID = $(this).val();
            if (customerID!='') {
                $('.ajaxLoaderFormLoad').show();
                $.ajax({
                    type: 'GET',
                    url: '{{url("user-advance-amount")}}/' + customerID,
                    success: function(data) {
                        $('#advance_amount').val(data);
                    }
                });

                // List customer bill list
                $.ajax({
                    type: 'GET',
                    url: '{{url("user-bill-list-by-id")}}/' + customerID,
                    success: function(data) {
                        if ($.trim(data) === '') {
                            alert('No bills found for this customer.');
                            $('.ajaxLoaderFormLoad').hide();
                            return false;
                        } else {
                            $('.ajaxLoaderFormLoad').hide();
                            var $data = $(data);
                            $data.find('#notificationElementId').remove(); // Replace #notificationElementId with the actual ID or class of the notification element
                            $('#resultBox').html($data);
                            $('html, body').animate({
                                scrollTop: $("#resultBox").offset().top
                            }, 1000);
                        }
                    }
                });

            }else{
                show_toastr('error', 'Customer AutoAC No is not linked');
                return false;
            }
        });

        $('#department_id').change(function(){
            var selOption = $(this).children('option:selected');
            var selText = selOption.text();
            $('#depDivName').val(selText);
        });
    </script>


    <script>
        // By Salaquzzaman @ 24-05-2024

        function paidTick(x, ropo) {
            if (x == 1) {
                ropo.find('.flagPaid').show();
                ropo.find('.flagUnpaid').hide();
            } else {
                ropo.find('.flagPaid').hide();
                ropo.find('.flagUnpaid').show();
            }
        }

        function calcAmount() {
            // $('#set_adjustment').prop('checked', false);
            // $('#deducted_amount').val(0);

            // main form total calculation
            var ddktAmt = parseFloat($('#deducted_amount').val());
            if (isNaN(ddktAmt) || ddktAmt == "") {
                ddktAmt = 0;
            }

            var rcvAmt = parseFloat($('#received_amount').val());
            var tdsAmt = parseFloat($('#tds_amount').val());
            var vatAmt = parseFloat($('#vat_amount').val());
            var adjAmt = parseFloat($('#adjust_amount').val());
            if (isNaN(rcvAmt) || rcvAmt == "") {
                rcvAmt = 0;
            }
            if (isNaN(tdsAmt) || tdsAmt == "") {
                tdsAmt = 0;
            }
            if (isNaN(vatAmt) || vatAmt == "") {
                vatAmt = 0;
            }
            if (isNaN(adjAmt) || adjAmt == "") {
                adjAmt = 0;
            }
            var totalColAmt = (rcvAmt + tdsAmt + vatAmt + adjAmt + ddktAmt);
            $('#total_coll_amount').val(totalColAmt.toFixed(2));
            $('#total_remaining').val(0);
            $('#total_remaining').val(totalColAmt);

            // grid value changes
            var remainingAmt = 0;
            var total_remaining = 0;

            $(".totalAmt").each(function() {

                var thisRow = $(this).closest('tr');

                var collectedAmt = parseFloat(thisRow.find('.collectedAmt').val());
                var totalAmt = parseFloat(this.value) - collectedAmt;
                if (isNaN(this.value) || this.value == "") {
                    totalAmt = 0;
                }

                thisRow.find('.collectionAmt').val(0);
                thisRow.find('.remainingAmt').val(0);
                total_remaining = parseFloat($('#total_remaining').val());

                if (total_remaining > totalAmt) {
                    total_remaining = total_remaining - totalAmt;
                    $('#total_remaining').val(total_remaining);
                    thisRow.find('.collectionAmt').val(totalAmt.toFixed(2));
                    thisRow.find('.remainingAmt').val(0);
                } else {
                    // total_remaining = $('#total_remaining').val();
                    $('#total_remaining').val(0);
                    thisRow.find('.collectionAmt').val(total_remaining.toFixed(2));
                    remainingAmt = totalAmt - total_remaining;
                    thisRow.find('.remainingAmt').val(remainingAmt.toFixed(2));
                }

            });

            $(".collectionAmt").each(function() {
                var thisRow = $(this).closest('tr');
                if(this.value>0){
                    thisRow.find('.custom-checkbox').prop('checked', true);
                }else{
                    thisRow.find('.custom-checkbox').prop('checked', false);
                }
            });

            // Payment Status Update
            $(".totalAmt").each(function() {
                var thisRow = $(this).closest('tr');
                var collectedAmt = parseFloat(thisRow.find('.collectedAmt').val());
                var totalAmt = parseFloat(this.value)
                if (isNaN(this.value) || this.value == "") {
                    totalAmt = 0;
                }
                var fTotal = totalAmt - collectedAmt;
                var remainingAmt = parseFloat(thisRow.find('.remainingAmt').val());

                if (remainingAmt <= 0) {
                    thisRow.find('.flagStatus').val('Paid');
                    paidTick(1, thisRow);
                } else {
                    thisRow.find('.flagStatus').val('Partial Paid');
                    paidTick(0, thisRow);
                }
                var collectionAmt = parseFloat(thisRow.find('.collectionAmt').val());
                if (isNaN(collectionAmt) || collectionAmt == "") {
                    thisRow.find('.flagStatus').val('Unpaid');
                    paidTick(0, thisRow);
                }

            });

        }

        function changeAmount(e){
            var thisRow = e.closest('tr');

            var collectionAmt = parseFloat(thisRow.find('.collectionAmt').val());
            var total_remaining = parseFloat($('#total_remaining').val());
            var total_coll_amount = parseFloat($('#total_coll_amount').val());

            if (isNaN(total_coll_amount) || total_coll_amount == "") {
                show_toastr('error', 'Please, enter amount');
                thisRow.find('.custom-checkbox').prop('checked', false);
                return false;
            }
            var totalAmt = thisRow.find('.totalAmt').val();
            var collectedAmt = thisRow.find('.collectedAmt').val();
            var remainingAmt = thisRow.find('.remainingAmt').val();

            if(thisRow.find('.custom-checkbox').is(":checked")){
                if(remainingAmt>=total_remaining){
                    var newRemainingAmt = remainingAmt-total_remaining;
                    thisRow.find('.remainingAmt').val(newRemainingAmt);
                    thisRow.find('.collectionAmt').val(total_remaining);
                    $('#total_remaining').val(0);
                }else{
                    var newRemaining = total_remaining-remainingAmt;
                    thisRow.find('.remainingAmt').val(0);
                    thisRow.find('.collectionAmt').val(remainingAmt);
                    $('#total_remaining').val(newRemaining);
                }
            }else{ // not checked
                $('#total_remaining').val(total_remaining+collectionAmt);
                thisRow.find('.remainingAmt').val(totalAmt-collectedAmt);
                thisRow.find('.collectionAmt').val(0);
            }

            setTickStatus();
        }

        function setTickStatus(){

            $(".remainingAmt").each(function() {
                var thisRow = $(this).closest('tr');
                var totalAmt = parseFloat(thisRow.find('.totalAmt').val());
                var collectedAmt = parseFloat(thisRow.find('.collectedAmt').val());
                var remainingAmt = parseFloat(thisRow.find('.remainingAmt').val());

                if(remainingAmt<1){
                    thisRow.find('.flagStatus').val('Paid');
                    paidTick(1, thisRow);
                }else{
                    if(totalAmt>(collectedAmt+remainingAmt)){
                        thisRow.find('.flagStatus').val('Partial Paid');
                    }else{
                        thisRow.find('.flagStatus').val('Unpaid');
                    }
                    paidTick(0, thisRow);
                }
            });
        }

        $('#instrument_mode').change(function(){
            $('#dep_bank_id').val(null).trigger('change');
            $('#dep_cash_id').val(null).trigger('change');
            $('#account_name').val('');
            if($('#instrument_mode').val()=='Cheque' || $('#instrument_mode').val()=='BEFTN' || $('#instrument_mode').val()=='Pay Order'){
                $('.bank_id_label').html('Bank Name* :');
                $('.dep_bank').show();
                $('.dep_cash').hide();
                // $('.instrument_no_label').html('Instrument No* :');
                // $('.instrument_date_label').html('Instrument Date* :');
                $('.instrumentBox').show();
                $('.attachment-box').show();
            }else if($('#instrument_mode').val()=='Cash'){
                $('.bank_id_label').html('Bank Name :');
                $('.dep_bank').hide();
                $('.dep_cash').show();
                // $('.instrument_no_label').html('Instrument No :');
                // $('.instrument_date_label').html('Instrument Date :');
                $('.instrumentBox').hide();
                $('.attachment-box').hide();
            }else{}
        });

        function setAdjustment(){
            if($('#customer_id').val()==''){
                show_toastr('error', 'Please, select customer');
                $('#set_adjustment').prop('checked', false);
                return false;
            }
            $('#deducted_amount').val('');
            calcAmount();
            if($('#set_adjustment').is(":checked")){
                $('#deducted_amount').removeClass('readmode');
            }else{
                $('#deducted_amount').addClass('readmode');
            }
        }
    </script>

    <script>
        function showTDSCertificate(){
            if($('#set_tds').is(":checked")){
                $('.tds-certificate-box').show();
            }else{
                $('.tds-certificate-box').hide();
            }
        }
        function showVDSCertificate(){
            if($('#set_vds').is(":checked")){
                $('.vds-certificate-box').show();
            }else{
                $('.vds-certificate-box').hide();
            }
        }
    </script>

    <script>
        $('#dep_bank_id').change(function(){
            var selOption = $(this).children('option:selected');
            var selText = selOption.text();
            $('#account_name').val(selText);
        });
        $('#dep_cash_id').change(function(){
            var selOption = $(this).children('option:selected');
            var selText = selOption.text();
            $('#account_name').val(selText);
        });
    </script>

@endsection
