
<div class="modal-body">
    <div class="row">
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Customer:</b></div>
            <p class="text-muted mb-3">{{ $customerNames[$advancedcollection->customer] ?? 'Unknown' }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Department:</b></div>
            <p class="text-muted mb-3">{{ $advancedcollection->depDivName ?? '-' }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Instrument Mode:</b></div>
            <p class="text-muted mb-3">{{ $advancedcollection->instrument_mode }}</p>
        </div>
        @if($advancedcollection->instrument_mode=='Bank')
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Bank:</b></div>
            <p class="text-muted mb-3">{{ $bankNames[$advancedcollection->bank] ?? '-' }}</p>
        </div>
        @else
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Account:</b></div>
            <p class="text-muted mb-3 accountName"></p>
        </div>
        @endif
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Instrument No:</b></div>
            <p class="text-muted mb-3">{{ $advancedcollection->instrument_no }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Instrument Date:</b></div>
            <p class="text-muted mb-3">{{ $advancedcollection->instrument_date }}</p>
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Attachment:</b></div>
            @if($advancedcollection->attachment)
                @php
                    $fileUrl = asset('storage/vds-certificate/' . $advancedcollection->attachment);
                @endphp
                <div style="display: flex; align-items: center; margin-bottom: 10px;">
                    <a href="{{ $fileUrl }}" target="_blank" title="view file">
                        <u>{{ $advancedcollection->attachment }}</u>
                    </a>
                </div>
            @else
                <p class="text-muted mb-3">-</p>
            @endif
        </div>
        <div class="col-md-6">
            <div class="form-control-label text-primary"><b>Amount:</b></div>
            <p class="text-muted mb-3">{{ $advancedcollection->amount }}</p>
        </div>
    </div>
</div>

<div class="modal-footer">
    <input type="button" value="Close" class="btn btn-danger" data-dismiss="modal">
</div>

@if($advancedcollection->instrument_mode=='Cash')
<script>

    getDeptResult({{$advancedcollection->bank}})

    // Get department name by key value - salaquzzaman @ 05-06-2024
    function getDeptResult(targetDept){
        // The encoded JSON string
        var depts = "{{ $depCash }}";

        var decodedDepts = decodeHtmlEntities(depts);
        var json = JSON.parse(decodedDepts);

        var divInfo = getDataByKeyValue(json,"autoAcNo", targetDept);
        if(divInfo!=null){
            $('.accountName').text(divInfo["udAcName"]);
        }
    }

    // Function to decode HTML entities
    function decodeHtmlEntities(text) {
        var parser = new DOMParser();
        var dom = parser.parseFromString('<!doctype html><body>' + text, 'text/html');
        return dom.body.textContent;
    }

    // Function to get data by key-value
    function getDataByKeyValue(list,key, value) {
        var result = null;
        $.each(list, function(index, product) {
            if (product[key] === value) {
            result = product;
            return false;
            }
        });
        return result;
    }

</script>
@endif
