@extends('layouts.app')
@section('title')
    Advanced Collection Edit
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0"> Advanced Collection Edit </h4>
        </div>
        <div class="col-md-6 text-right">
            <a href="{{ route('advanced.collection') }}" class="btn btn-primary">Advanced Collection</a>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_title">
                    <h5> Advanced Collection Edit </h5>
                    <div class="clearfix"></div>
                </div>
                <div class="x_content" style="padding:0">


                    <form action="{{ route('advanced.collection.update', $collection->id) }}" method="POST" autocomplete="off">
                        @csrf
                        @method('PUT')

                        <div class="row">
                            <div class="col-md-6">
                                <label for="customer_id">Customer* :</label>
                                <select id="customer_id" name="customer_id" class="form-control select2" required>
                                    <option value="">--Select Customer--</option>
                                    @foreach ($customers as $row)
                                        <option value="{{$row['autoAcNo']}}" {{ $autoAcNo == $row['autoAcNo'] ? 'selected' : '' }} data-extra="{{$row['divCode']}}">
                                            {{$row['udAcName']}}
                                        </option>
                                    @endforeach
                                </select>
                                <input type="hidden" id="customerName" name="customerName">
                            </div>

                            <div class="col-md-6">
                                <label for="amount">Amount* :</label>
                                <input type="number" id="amount" min="1" class="form-control" name="amount" required value="{{ $collection->amount }}" />
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <label for="dep_bank_id">Bank* :</label>
                                <select id="dep_bank_id" name="dep_bank_id" class="form-control select2">
                                    <option value="">--Select Bank--</option>
                                    @foreach ($depBanks as $row)
                                        <option value="{{ $row['autoAcNo'] }}" {{ $bankautoAcNo == $row['autoAcNo'] ? 'selected' : '' }} data-extra="{{ $row['divCode'] }}">
                                            {{ $row['udAcName'] }}
                                        </option>
                                    @endforeach
                                </select>
                                <input type="hidden" id="bankName" name="bankName">
                                <input type="hidden" id="bankDivCode" name="bankDivCode">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <br />
                                <a href="{{ route('advanced.collection') }}" class="btn btn-info">Cancel</a>
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
    <style>
        form label {
            margin-bottom: 2px;
            margin-top: 8px;
        }
    </style>

    <script>
        $('#customer_id').change(function(){
            var selOption = $(this).children('option:selected');
            var selText = selOption.text();
            $('#customerName').val(selText);
            var divCode = selOption.data('extra');
            $('#department_id').val(divCode).trigger('change');
        });

        $('#dep_bank_id').change(function() {
            var selOption = $(this).children('option:selected');
            var selText = selOption.text();
            $('#bankName').val(selText);
            var divCode = selOption.data('extra');
            $('#bankDivCode').val(divCode);
        });
    </script>
@endsection
