<form action="{{route('bill-subject.store')}}" method="POST" autocomplete="off">
    <div class="modal-body">
        <div class="row">
            <div class="col-12">
                @csrf
                <div class="form-group">
                    <label for="bill_subject">Bill Subject*</label>
                    <input type="text" class="form-control" id="bill_subject" name="bill_subject"
                        placeholder="Enter Bill Subject" required>
                </div>
                <div class="form-group">
                    <label for="hs_code">HS Code</label>
                    <input type="text" class="form-control" id="hs_code" name="hs_code"
                        placeholder="Enter HS Code">
                </div>
                <div class="form-group">
                    <label for="divCode">Department* :</label>
                    <select id="divCode" name="divCode" class="form-control select2" required>
                        <option value="">--Select Department--</option>
                        @foreach ($departments as $row)
                        @if($row['divCode']!='000')
                        <option value="{{$row['divCode']}}">{{$row['divName']}}</option>
                        @endif
                        @endforeach
                    </select>
                    <input type="hidden" id="divName" name="divName">
                </div>

                <div class="form-group">
                    <label for="gl_code">GL Subject*</label>
                    <select id="gl_code" name="gl_code" class="form-control select2" required>
                        <option value="">--Select GL Subject--</option>
                    </select>
                    <input type="hidden" id="gl_subject" name="gl_subject">
                    <input type="hidden" id="autoAcNo" name="autoAcNo">
                </div>
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <input type="button" value="{{ __('Cancel') }}" class="btn btn-danger" data-dismiss="modal">
        <input type="submit" value="{{ __('Create') }}" class="btn btn-primary">
    </div>
</form>
<script>
    $('#gl_code').change(function(){
        var selOption = $(this).children('option:selected');
        var selText = selOption.text();
        $('#gl_subject').val(selText);
        $('#autoAcNo').val($('#gl_code').val());
    });
    $('#divCode').change(function(){
        var selOption = $(this).children('option:selected');
        var selText = selOption.text();
        $('#divName').val(selText);
    });
    $('#divCode').change(function(){
        var chartDepId = $(this).val();
        $.ajax({
            type: 'GET',
            url: '{{url("income-list-by-divcode")}}/'+chartDepId,
            success: function(data) {
                $('#gl_code').html(data);
            }
        });
    });
    $('.select2').select2({
        dropdownParent: $('#commonModal')
    });
</script>
