<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
<div class="modal-body">
    <div class="row">
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Bill No:</b></div>
            <p class="text-muted mb-3">{{ $bill->id ? str_pad($bill->id, 5, '0', STR_PAD_LEFT) : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Customer:</b></div>
            <p class="text-muted mb-3">{{ $bill->customer ? $bill->customer->customer_name : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Particulars:</b></div>
            <p class="text-muted mb-3">{{ $bill->particulars ? $bill->particulars : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Currency:</b></div>
            <p class="text-muted mb-3">{{ $bill->currency ? $bill->currency : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Currency Rate:</b></div>
            <p class="text-muted mb-3">{{ $bill->currency_rate ? $bill->currency_rate : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Quantity:</b></div>
            <p class="text-muted mb-3">{{ $bill->qty ? $bill->qty : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Unit Price:</b></div>
            <p class="text-muted mb-3">
                {{ $bill->unit_price_vat ? \App\Models\Settings::priceFormat($bill->unit_price_vat) : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Total Amount:</b></div>
            <p class="text-muted mb-3">
                {{ $bill->total_amount ? \App\Models\Settings::priceFormat($bill->total_amount) : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Convertion Total Amount <br>(Currency Rate*Total Amount):</b></div>
            <p class="text-muted mb-3">
                {{ $bill->convertion_total_amount ? \App\Models\Settings::priceFormat($bill->convertion_total_amount) : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Bill Subject:</b></div>
            <p class="text-muted mb-3">{{ $bill->billSubject ? $bill->billSubject->bill_subject : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Bin Number:</b></div>
            <p class="text-muted mb-3">{{ $bill->bin_number ? $bill->bin_number : '-' }}</p>
        </div>

        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>VAT Refund:</b></div>
            <p class="text-muted mb-3">
                @if($bill->vat_refund == 1)
                    Yes
                @elseif($bill->vat_refund == 0)
                    No
                @else
                    -
                @endif
            </p>
        </div>

        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Ref No:</b></div>
            <p class="text-muted mb-3">{{ $bill->ref_no ? $bill->ref_no : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Ref Date:</b></div>
            <p class="text-muted mb-3">{{ $bill->ref_date ? $bill->ref_date : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Installation Date:</b></div>
            <p class="text-muted mb-3">{{ $bill->installation_date ? $bill->installation_date : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Activation Date:</b></div>
            <p class="text-muted mb-3">{{ $bill->activation_date ? $bill->activation_date : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Start Date:</b></div>
            <p class="text-muted mb-3">{{ $bill->start_date ? $bill->start_date : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>End Date:</b></div>
            <p class="text-muted mb-3">{{ $bill->end_date ? $bill->end_date : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Department:</b></div>
            <p class="text-muted mb-3">{{ $bill->billDivName ? $bill->billDivName : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Bill Group:</b></div>
            <p class="text-muted mb-3">{{ $bill->bill_group ? $bill->bill_group : '-' }}</p>
        </div>

        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>VAT Status:</b></div>
            <p class="text-muted mb-3">{{ $bill->vat_status == 1 ? 'Yes' : 'No' }}</p>
        </div>

        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>VAT Percent:</b></div>
            <p class="text-muted mb-3">{{ $bill->vat_percent !== null ? $bill->vat_percent . '%' : '-' }}</p>

        </div>

        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Bill Type:</b></div>
            <p class="text-muted mb-3">{{ $bill->bill_type ? $bill->bill_type : '-' }}</p>
        </div>

        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Total Amount with VAT:</b></div>
            <p class="text-muted mb-3">{{ $bill->total_amount_vat ? \App\Models\Settings::priceFormat($bill->total_amount_vat) : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Yearly Increase Percent:</b></div>
            <p class="text-muted mb-3">{{ $bill->yearly_increase_percent ? $bill->yearly_increase_percent . '%' : '-' }}
            </p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Increase Start Date:</b></div>
            <p class="text-muted mb-3">{{ $bill->increase_start_date ? $bill->increase_start_date : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Order SL No:</b></div>
            <p class="text-muted mb-3">{{ $bill->order_sl_no ? $bill->order_sl_no : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Status:</b></div>
            <p class="text-muted mb-3">{{ $bill->status ? $bill->status : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Approval: </b></div>
            <p class="text-muted mb-3">{{ $bill->approval == 1 ? 'Yes' : 'No' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Created at:</b></div>
            <p class="text-muted mb-3">
                {{ $bill->created_at ? \Carbon\Carbon::parse($bill->created_at)->format('d-m-Y') : '-' }}</p>
        </div>



            <div class="col-md-3">
                <div class="form-control-label text-primary"><b>Work Order / PO:</b></div>
                @if($bill->workorder_file)
                    @php
                        $fileUrl = asset('storage/workorders/' . $bill->workorder_file);
                        $fileExtension = pathinfo($fileUrl, PATHINFO_EXTENSION);
                        $iconClass = '';

                        switch($fileExtension) {
                            case 'pdf':
                                $iconClass = 'fas fa-file-pdf fa-3x';
                                break;

                            case 'png':
                            case 'jpeg':
                            case 'jpg':
                            case 'gif':
                                // No icon needed for images
                                break;
                        }
                    @endphp
                    <div style="display: flex; align-items: center; margin-bottom: 10px;">
                        @if(in_array($fileExtension, ['jpg', 'jpeg', 'png', 'gif']))
                            <img src="{{ $fileUrl }}" alt="Work Order" class="img-thumbnail" style="width: 50px; height: 50px; margin-right: 10px;">
                        @else
                            <i class="{{ $iconClass }}" style="width: 50px; height: 50px; margin-right: 10px;"></i>
                        @endif
                        <a href="{{ $fileUrl }}" download="{{ $bill->workorder_file }}" target="_blank" title="view file">
                            {{ $bill->workorder_file }}
                        </a>
                    </div>
                @else
                    <p class="text-muted mb-3">-</p>
                @endif
            </div>




            <div class="col-md-3">
                <div class="form-control-label text-primary"><b>Installation / UAT:</b></div>
                @if($bill->instalation_file)
                    @php
                        $fileUrl = asset('storage/installation/' . $bill->instalation_file);
                        $fileExtension = pathinfo($fileUrl, PATHINFO_EXTENSION);
                        $iconClass = '';


                        switch($fileExtension) {
                                    case 'pdf':
                                        $iconClass = 'fas fa-file-pdf fa-3x';
                                        break;

                                    case 'png':
                                    case 'jpeg':
                                    case 'jpg':
                                    case 'gif':
                                        // No icon needed for images
                                        break;
                        }
                    @endphp
                    <div style="display: flex; align-items: center; margin-bottom: 10px;">
                        @if(in_array($fileExtension, ['jpg', 'jpeg', 'png', 'gif']))
                            <img src="{{ $fileUrl }}" alt="Installation UAT" class="img-thumbnail" style="width: 50px; height: 50px; margin-right: 10px;">
                        @else
                            <i class="{{ $iconClass }}" style="width: 50px; height: 50px; margin-right: 10px;"></i>
                        @endif
                        <a href="{{ $fileUrl }}" download="{{ $bill->instalation_file }}" target="_blank" title="view file">
                            {{ $bill->instalation_file }}
                        </a>
                    </div>
                @else
                    <p class="text-muted mb-3">-</p>
                @endif
            </div>




            <div class="col-md-3">
                <div class="form-control-label text-primary"><b>Delivery Challan:</b></div>
                @if($bill->deliverychallan_file)
                    @php
                        $fileUrl = asset('storage/deliverychallan/' . $bill->deliverychallan_file);
                        $fileExtension = pathinfo($fileUrl, PATHINFO_EXTENSION);
                        $iconClass = '';

                        switch($fileExtension) {
                                    case 'pdf':
                                        $iconClass = 'fas fa-file-pdf fa-3x';
                                        break;

                                    case 'png':
                                    case 'jpeg':
                                    case 'jpg':
                                    case 'gif':
                                        // No icon needed for images
                                        break;
                        }

                    @endphp
                    <div style="display: flex; align-items: center; margin-bottom: 10px;">
                        @if(in_array($fileExtension, ['jpg', 'jpeg', 'png', 'gif']))
                            <img src="{{ $fileUrl }}" alt="Delivery Challan" class="img-thumbnail" style="width: 50px; height: 50px; margin-right: 10px;">
                        @else
                            <i class="{{ $iconClass }}" style="width: 50px; height: 50px; margin-right: 10px;"></i>
                        @endif
                        <a href="{{ $fileUrl }}" download="{{ $bill->deliverychallan_file }}" target="_blank" title="view file">
                            {{ $bill->deliverychallan_file }}
                        </a>
                    </div>
                @else
                    <p class="text-muted mb-3">-</p>
                @endif
            </div>


    </div>
</div>

<div class="modal-footer">
    <input type="button" value="Close" class="btn btn-danger" data-dismiss="modal">
    @can('Edit Bill')
    @if($bill->approval!=1)
        {{-- <a href="{{ route('bills.edit', $bill->id) }}" class="btn btn-success">Edit</a> --}}
    @endif
    @endcan
</div>

