<div class="modal-body">
    <div class="row">
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Bill No:</b></div>
            <p class="text-muted mb-3">{{ $bill->id ? str_pad($bill->id, 5, '0', STR_PAD_LEFT) : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Customer:</b></div>
            <p class="text-muted mb-3">{{ $bill->customer ? $bill->customer->customer_name : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Bin Number:</b></div>
            <p class="text-muted mb-3">{{ $bill->customer ? $bill->customer->bin_no : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Particulars:</b></div>
            <p class="text-muted mb-3">{{ $bill->particulars ? $bill->particulars : '-' }}</p>
        </div>

        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Bill Type:</b></div>
            <p class="text-muted mb-3">{{ $bill->bill_type ? $bill->bill_type : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Attention Person:</b></div>
            <p class="text-muted mb-3">{{ $bill->attention_person ? $bill->attention_person : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Currency & Rate:</b></div>
            <p class="text-muted mb-3">{{ $bill->currency }} ({{$bill->currency_rate}})</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Quantity:</b></div>
            <p class="text-muted mb-3">{{ $bill->qty ? $bill->qty : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Unit Price:</b></div>
            <p class="text-muted mb-3">
                {{ $bill->unit_price_vat ? \App\Models\Settings::priceFormat($bill->unit_price_vat) : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Net Amount:</b></div>
            <p class="text-muted mb-3">
                {{ $bill->total_amount ? \App\Models\Settings::priceFormat($bill->total_amount) : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>VAT Amount:</b></div>
            <p class="text-muted mb-3">
                {{ $bill->vat_amount ? \App\Models\Settings::priceFormat($bill->vat_amount) : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Total Amount:</b></div>
            <p class="text-muted mb-3">{{ $bill->total_amount_vat ? \App\Models\Settings::priceFormat($bill->total_amount_vat) : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Convertion Total Amount:</b></div>
            <p class="text-muted mb-3">
                {{ $bill->convertion_total_amount_vat ? \App\Models\Settings::priceFormat($bill->convertion_total_amount_vat) : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Department:</b></div>
            <p class="text-muted mb-3">{{ $bill->billDivName ? $bill->billDivName : '-' }}</p>
        </div>


        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Ref No:</b></div>
            <p class="text-muted mb-3">{{ $bill->ref_no ? $bill->ref_no : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Ref Date:</b></div>
            <p class="text-muted mb-3">{{ $bill->ref_date ? $bill->ref_date : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Installation Date:</b></div>
            <p class="text-muted mb-3">{{ $bill->installation_date ? $bill->installation_date : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Activation Date:</b></div>
            <p class="text-muted mb-3">{{ $bill->activation_date ? $bill->activation_date : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Start Date:</b></div>
            <p class="text-muted mb-3">{{ $bill->start_date ? $bill->start_date : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>End Date:</b></div>
            <p class="text-muted mb-3">{{ $bill->end_date ? $bill->end_date : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Bill Subject:</b></div>
            <p class="text-muted mb-3">{{ $bill->billSubject ? $bill->billSubject->bill_subject : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Bill Group:</b></div>
            <p class="text-muted mb-3">{{ $bill->bill_group ? $bill->bill_group : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>VAT Stamp:</b></div>
            <p class="text-muted mb-3">
                @if($bill->vat_refund == 1)
                    Yes
                @elseif($bill->vat_refund == 0)
                    No
                @else
                    -
                @endif
            </p>
        </div>

        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>VAT Status:</b></div>
            <p class="text-muted mb-3">{{ $bill->vat_status == 1 ? 'Yes' : 'No' }}</p>
        </div>

        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>VAT Percent:</b></div>
            <p class="text-muted mb-3">{{ $bill->vat_percent !== null ? $bill->vat_percent . '%' : '-' }}</p>

        </div>

        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Yearly Increase Percent:</b></div>
            <p class="text-muted mb-3">{{ $bill->yearly_increase_percent ? $bill->yearly_increase_percent . '%' : '-' }}
            </p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Increase Start Date:</b></div>
            <p class="text-muted mb-3">{{ $bill->increase_start_date ? $bill->increase_start_date : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Increase Period:</b></div>
            <p class="text-muted mb-3">
                @if($bill->increase_period == '3')
                    3 Months
                @elseif($bill->increase_period == '6')
                    0.5 Year
                @elseif($bill->increase_period == '12')
                    1 Year
                @elseif($bill->increase_period == '24')
                    2 Years
                @elseif($bill->increase_period == '36')
                    3 Years
                @elseif($bill->increase_period == '48')
                    4 Years
                @elseif($bill->increase_period == '60')
                    5 Years
                @elseif($bill->increase_period == '120')
                    10 Years
                @else
                    -
                @endif
            </p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Order SL No:</b></div>
            <p class="text-muted mb-3">{{ $bill->order_sl_no ? $bill->order_sl_no : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Status:</b></div>
            <p class="text-muted mb-3">{{ $bill->status ? $bill->status : '-' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Approval: </b></div>
            <p class="text-muted mb-3">{{ $bill->approval == 1 ? 'Yes' : 'No' }}</p>
        </div>
        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Created at:</b></div>
            <p class="text-muted mb-3">
                {{ $bill->created_at ? \Carbon\Carbon::parse($bill->created_at)->format('d-m-Y') : '-' }}</p>
        </div>

        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Work Order / PO:</b></div>
            @if($bill->workorder_file)
                @php
                    $fileUrl = asset('storage/workorders/' . $bill->workorder_file);
                @endphp
                <div style="display: flex; align-items: center; margin-bottom: 10px;">
                    <a href="{{ $fileUrl }}" target="_blank" title="view file">
                        <u>{{ $bill->workorder_file }}</u>
                    </a>
                </div>
            @else
                <p class="text-muted mb-3">-</p>
            @endif
        </div>

        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>Installation / Delivery Challan:</b></div>
            @if($bill->instalation_file)
                @php
                    $fileUrl = asset('storage/installation/' . $bill->instalation_file);
                @endphp
                <div style="display: flex; align-items: center; margin-bottom: 10px;">
                    <a href="{{ $fileUrl }}" target="_blank" title="view file">
                        <u>{{ $bill->instalation_file }}</u>
                    </a>
                </div>
            @else
                <p class="text-muted mb-3">-</p>
            @endif
        </div>

        <div class="col-md-3">
            <div class="form-control-label text-primary"><b>UAT:</b></div>
            @if($bill->deliverychallan_file)
                @php
                    $fileUrl = asset('storage/deliverychallan/' . $bill->deliverychallan_file);
                @endphp
                <div style="display: flex; align-items: center; margin-bottom: 10px;">
                    <a href="{{ $fileUrl }}" target="_blank" title="view file">
                        <u>{{ $bill->deliverychallan_file }}</u>
                    </a>
                </div>
            @else
                <p class="text-muted mb-3">-</p>
            @endif
        </div>



    </div>
</div>

<div class="modal-footer">
    <input type="button" value="Close" class="btn btn-danger" data-dismiss="modal">
    @can('Edit Bill')
    @if($bill->approval!=1)
        <a href="{{ route('bills.edit', $bill->id) }}" class="btn btn-success">Edit</a>
    @endif
    @endcan
</div>

