@extends('layouts.app')

@section('title')
    Pending Bills
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Pending Bills</h4>
        </div>
        <div class="col-md-6 text-right">
            @can('Create Bill')
                <a href="{{ route('bills.create') }}" class="btn btn-primary">Add New Bill</a>
            @endcan
        </div>
    </div>


            <form action="{{ route('bills.pending') }}" method="GET" class="num_filter px-4">
                <label for="per_page">Show</label>
                <select name="per_page" id="per_page" onchange="this.form.submit()" style="height: 40px; width: 70px; border: 1px solid #ced4da; border-radius: 4px">
                    <option value="25" {{ $perPage == 25 ? 'selected' : '' }}>25</option>
                    <option value="50" {{ $perPage == 50 ? 'selected' : '' }}>50</option>
                    <option value="100" {{ $perPage == 100 ? 'selected' : '' }}>100</option>
                    <option value="{{ $bills->total() }}" {{ $perPage == $bills->total() ? 'selected' : '' }}>All</option>
                </select>
                Entries
            </form>

<form id="billListForm">
    @csrf
    <div class="row">
        <table id="datatable-buttons" class="table table-striped table-bordered" style="width:100%">
            <thead>
                <tr>
                    <th class="text-center"><input type="checkbox" class="custom-checkbox" id="select-all" /><label
                            for="select-all">
                        </label></th>
                    <th>Sl</th>
                    <th>Bill No</th>
                    <th>Customer</th>
                    <th>Bill Group</th>
                    <th>Qty</th>
                    <th>Currency</th>
                    <th>Net Amount</th>
                    <th>VAT Amount</th>
                    <th>Total Amount</th>
                    <th>Bill Type</th>
                    <th>Status</th>
                    <th style="width:100px;">Action</th>
                </tr>
            </thead>

            <tbody>
                @foreach ($bills as $row)
                    <tr>
                        <td class="text-center">
                            <input type="checkbox" class="custom-checkbox" id="selected_bills_{{ $row->id }}"
                                name="selected_bills[]" value="{{ $row->id }}" /><label
                                for="selected_bills_{{ $row->id }}"></label>
                        </td>
                        <!-- <td>{{ $loop->iteration }}</td> -->
                        <td>{{ $loop->iteration + ($bills->currentPage() - 1) * $bills->perPage() }}</td>
                        <td>{{ str_pad($row->id, 5, '0', STR_PAD_LEFT) }}</td>
                        <td>{{ $row->customer ? $row->customer->customer_name : '-' }}</td>
                        <td>{{ $row->bill_group ? $row->bill_group : '-' }}</td>
                        <td class="text-right">{{ $row->qty }}</td>
                        <td>{{ $row->currency }}</td>
                        <td class="text-right">{{ \App\Models\Settings::priceFormat($row->total_amount) }}</td>
                        <td class="text-right">{{ \App\Models\Settings::priceFormat($row->vat_amount) }}</td>
                        <td class="text-right">{{ \App\Models\Settings::priceFormat($row->total_amount_vat) }}</td>
                        <td>{{ $row->bill_type ? $row->bill_type : '-' }}</td>
                        <td>{{ ($row->bill_edited==1)? 'Submitted':'' }}</td>
                        <td>
                            {{-- <a data-size="lg" class="btn btn-info btn-sm text-white cursor-pointer"
                                data-url="{{ route('bills.show', $row->id) }}" data-ajax-popup="true"
                                data-title="View Bill" data-bs-toggle="tooltip" title="View"
                                data-original-title="View">View</a> --}}

                                @can('Edit Bill')
                                    <a href="{{ route('bills.edit', $row->id) }}" class="btn btn-success btn-sm">Edit</a>
                                @endcan

                            @can('Delete Bill')
                                {{-- <a data="{{ route('bills.single.delete', [$row->id,'pending']) }}"
                                    class="btn btn-danger btn-sm delete-btn text-white cursor-pointer">Reject</a> --}}
                            @endcan

                            {{-- <a href="{{ route('bills.statusChange', ['id' => $row->id, 'status' => 1]) }}" class="btn btn-primary btn-sm">Approve</a>
                            <a onclick="showRejectNoteModal({{ $row->id }})" class="btn btn-warning btn-sm text-dark">Back</a> --}}


                            @php
                                $notes = \App\Models\BillNote::where('bill_id',$row->id)->first();
                            @endphp

                            @if($notes)
                            <a data-size="lg" class="btn btn-info btn-sm text-white cursor-pointer"
                                data-url="{{ route('bills.reject.note', $row->id) }}" data-ajax-popup="true"
                                data-title="View Reject Note" data-bs-toggle="tooltip" title="View Reject Note"
                                data-bs-custom-class="custom-tooltip">
                                <i class="fa fa-info-circle"></i>
                            </a>
                            @endif

                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    <input type="hidden" id="status" name="status">
</form>


    <div class="row mt-3">
        <div class="col-md-12 d-flex justify-content-between">
            <div>
                Showing {{ $bills->firstItem() }} to {{ $bills->lastItem() }} of {{ $bills->total() }} entries
            </div>
            <div>
                {{ $bills->appends(['per_page' => $perPage])->links('vendor.pagination.custom-pagination') }}
            </div>
        </div>
    </div>


    <div class="row mt-3">
        <div class="col-md-12 text-center">
            @if (count($bills) > 0)
                @can('Approve Bill')
                    <a onclick="statusChangeBatch(1)" class="btn btn-primary text-white">Approve</a>
                @endcan
                @can('Approve Bill')
                    <!-- <a onclick="statusChangeBatch(2)" class="btn btn-warning text-dark">Back</a> -->
                    <a onclick="showAllRejectNoteModal()" class="btn btn-warning text-dark">Back</a>
                @endcan
                @can('Delete Bill')
                <a onclick="statusChangeBatch(0)" class="btn btn-danger text-white cursor-pointer">Reject</a>
                @endcan
            @endif
        </div>
    </div>


<!-- Reject Note Modal -->
<div class="modal fade" id="rejectNoteModal" tabindex="-1" role="dialog" aria-labelledby="rejectNoteModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <form id="rejectNoteForm">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="rejectNoteModalLabel">Reject Note</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label for="reject_note_text">Please provide a reason for rejection:</label>
                        <textarea id="reject_note_text" name="reject_note_text" class="form-control" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <!-- <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button> -->
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
            </div>
        </form>
    </div>
</div>



<!-- All selected reject modal -->
<div class="modal fade" id="allRejectNoteModal" tabindex="-1" aria-labelledby="allRejectNoteModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="allRejectNoteForm" method="GET" action="{{ route("bills.statusChange", ["id" => ":id", "status" => ":status"]) }}">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title" id="allRejectNoteModalLabel">Reject Note</h5>
                    <!-- <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button> -->
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="all_reject_note_text" class="form-label">Please provide a reason for rejection:</label>
                        <textarea class="form-control" id="all_reject_note_text" name="reject_note" required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">Submit</button>
                    <!-- <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button> -->
                </div>
            </form>
        </div>
    </div>
</div>




    <script>
        $('#select-all').click(function() {
            $('input[name="selected_bills[]"]').prop('checked', this.checked);
        });

        function showRejectNoteModal(billId) {
            $('#rejectNoteForm').off('submit').on('submit', function(e) {
                e.preventDefault();
                var rejectNote = $('#reject_note_text').val();
                var actionUrl = '{{ route("bills.statusChange", ["id" => ":id", "status" => 0]) }}';
                actionUrl = actionUrl.replace(':id', billId);
                $('#billListForm').attr('action', actionUrl);
                $('#billListForm').append('<input type="hidden" name="reject_note" value="' + rejectNote + '">'); // Add reject_note to form
                $('#billListForm').submit();
            });
            $('#rejectNoteModal').modal('show');
        }


        function showAllRejectNoteModal() {
            var selectedBills = $('input[name="selected_bills[]"]:checked');

            if (selectedBills.length > 0) {
                $('#allRejectNoteModal').modal('show');

                $('#allRejectNoteForm').off('submit').on('submit', function(e) {
                    e.preventDefault();
                    var rejectNote = $('#all_reject_note_text').val();

                    // Process each selected bill
                    selectedBills.each(function() {
                        var billId = $(this).val();
                        var status = 'rejected'; // Example status, set as needed

                        // Build the correct action URL for each bill
                        var actionUrl = '{{ route("bills.statusChange", ["id" => ":id", "status" => ":status"]) }}'
                            .replace(':id', billId)
                            .replace(':status', status);

                        // Update the form action dynamically
                        $('#allRejectNoteForm').attr('action', actionUrl);

                        // Append hidden inputs for the current bill
                        $('#allRejectNoteForm').append('<input type="hidden" name="selected_bills[]" value="' + billId + '">');
                    });

                    // Append the reject_note to the form
                    $('#allRejectNoteForm').append('<input type="hidden" name="reject_note" value="' + rejectNote + '">');

                    // Submit the form for the first selected bill (as an example)
                    $('#allRejectNoteForm')[0].submit();
                });

            } else {
                show_toastr('error', 'Please, check bill from bill list');
            }
        }


        function statusChangeBatch(status){
            var checkedCount = $('input[name="selected_bills[]"]:checked').length;
            if(checkedCount>0){
                $('#status').val(status);
                $('#billListForm').attr("method","post");
                $('#billListForm').attr("action","{{ route('bills.pendingBatch') }}");
                $('#billListForm').submit();
            }else{
                show_toastr('error', 'Please, check bill from bill list');
            }
        }

        $(document).on("click", ".delete-btn", function () {
            var hrefValue = $(this).attr('data');
            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: "btn btn-success",
                    cancelButton: "btn btn-danger",
                },
                buttonsStyling: false,
            });
            swalWithBootstrapButtons
                .fire({
                    title: "Are you sure?",
                    text: "You won't be able to revert this!",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonText: "Yes, Reject it!",
                    cancelButtonText: "No, cancel!",
                    reverseButtons: true,
                })
                .then((result) => {
                    if (result.isConfirmed) {
                        window.location.replace(hrefValue);
                    } else if (result.dismiss === Swal.DismissReason.cancel) {
                    }
                });
        });
    </script>

<style>
    {
        display: inline-block;
        position: absolute;
        z-index: 2;
    }
</style>

<style>
    body {
        margin: 0;
        padding: 0;
        height: 100vh;
        display: flex;
        flex-direction: column;
    }

    .container {
        flex: 1;
        overflow-y: auto;
    }

    .row {
        flex-grow: 1;
    }

    .table-responsive {
        max-height: calc(100vh - 250px);
        overflow-y: auto;
    }
</style>


@endsection
