@extends('layouts.app')

@section('title')
    Bill Ending Warning List
@endsection

@section('content')

    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Bill endings in: </h4>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">

<div class="x_content" style="padding:0">
  <div class="col-md-12 mb-2">

    <!-- Line 1: Select2 dropdown -->
    <div class="mb-2">
      <select name="customer_id" id="customer_id" class="form-control select2" style="width:300px;">
        <option value="">Select Customer</option>
        @foreach ($customers as $customer)
          <option value="{{ $customer->id }}" {{ $customer_id == $customer->id ? 'selected' : '' }}>
            {{ $customer->customer_name }}
          </option>
        @endforeach
      </select>
    </div>

    <!-- Line 2: Radios and buttons -->
    <div class="d-flex align-items-center flex-wrap">
      <div class="d-flex align-items-center mr-3">
        <div class="form-check form-check-inline mb-0">
          <input class="form-check-input" type="radio" name="month_no" id="month_no1" value="1" {{($month_no==1)? 'checked' : ''}}>
          <label class="form-check-label" for="month_no1">This month</label>
        </div>
        <div class="form-check form-check-inline mb-0">
          <input class="form-check-input" type="radio" name="month_no" id="month_no2" value="2" {{($month_no==2)? 'checked' : ''}}>
          <label class="form-check-label" for="month_no2">{{date('F-Y', strtotime('+1 month'))}}</label>
        </div>
        <div class="form-check form-check-inline mb-0">
          <input class="form-check-input" type="radio" name="month_no" id="month_no3" value="3" {{($month_no==3)? 'checked' : ''}}>
          <label class="form-check-label" for="month_no3">{{date('F-Y', strtotime('+2 month'))}}</label>
        </div>
        <div class="form-check form-check-inline mb-0">
          <input class="form-check-input" type="radio" name="month_no" id="month_no4" value="4" {{($month_no==4)? 'checked' : ''}}>
          <label class="form-check-label" for="month_no4">{{date('F-Y', strtotime('+3 month'))}}</label>
        </div>
      </div>

      <!-- Buttons -->
      <a class="btn btn-primary text-white mr-2 btn-search">Search</a>
      <a href="{{ route('report.endingBills') }}" class="btn btn-danger">Clear</a>
    </div>

  </div>
</div>




                {{-- <div class="x_content" style="padding:0">
                    <div class="col-md-5 mb-2">
                        <div class="d-flex">

                            <select name="customer_id" id="customer_id" class="form-control select2">
                                <option value="">Select Customer</option>
                                @foreach ($customers as $customer)
                                    <option value="{{ $customer->id }}"
                                        {{ $id == $customer->id ? 'selected' : '' }}>
                                        {{ $customer->customer_name }}</option>
                                @endforeach
                            </select>

                            <div class="mb-4">
                            <label class="font-weight-bold">Inline radios:</label>
                            <div>
                                <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="month_no" id="month_no1" value="a" checked>
                                <label class="form-check-label" for="month_no1">This month</label>
                                </div>
                                <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="month_no" id="month_no2" value="b">
                                <label class="form-check-label" for="month_no2">Next month</label>
                                </div>
                                <div class="form-check form-check-inline">
                                <input class="form-check-input" type="radio" name="month_no" id="month_no3" value="c">
                                <label class="form-check-label" for="month_no3">Next+ month</label>
                                </div>
                            </div>
                            </div>

                                &nbsp;&nbsp;
                            <a class="btn btn-primary ms-2 text-white btn-search">Search</a>
                            <a href="{{ route('active.inactive.bills') }}" class="btn btn-danger ms-2">Clear</a>
                        </div>
                    </div>

                    @if($customerInfo)
                    <div class="row">
                        <div class="col-md-12">
                            <h6><span class="text-dark">Address:</span> {{ $customerInfo->address }}</h6>
                        </div>
                    </div>
                    @endif
                </div> --}}
            </div>
        </div>
    </div>

    <div class="row">
        @if(count($bills)>0)
        <table class="table table-striped table-bordered" style="width:100%">
            <thead>
                <tr>
                    <th>Sl</th>
                    <th>Bill No</th>
                    <th>Customer</th>
                    <th>Particulars</th>
                    <th>End Date</th>
                    {{-- <th>Active Status</th> --}}
                    <th>VAT<br>(%)</th>
                    <th>Net<br>Amount</th>
                    <th>VAT<br>Amount</th>
                    <th>Total<br>Amount</th>
                    <th>Bill<br>Type</th>
                    <th></th>
                </tr>
            </thead>

            <tbody>
                @foreach ($bills as $row)
                    <tr>
                        <td>{{ $loop->iteration }}</td>
                        <td>{{ str_pad($row->id, 5, '0', STR_PAD_LEFT) }}</td>
                        <td>{{ $row->customer ? $row->customer->customer_name : '-' }}</td>
                        <td>{{ $row->particulars }}</td>
                        <td><b>{{ $row->end_date }}</b></td>
                        {{-- <td>
                            <input type="checkbox" class="circle-nicelabel btn-status" id="{{$row->id}}"
                                value="{{$row->id}}" {{($row->status=='Active')? 'checked':''}}/>
                        </td> --}}
                        <td class="text-right">{{ $row->vat_percent }}</td>
                        <td class="text-right">{{ priceFormat($row->total_amount) }}</td>
                        <td class="text-right">{{ priceFormat($row->vat_amount) }}</td>
                        <td class="text-right">{{ priceFormat($row->total_amount_vat) }}</td>
                        <td>{{ $row->bill_type }}</td>
                        <td>
                            <a data-size="xl" class="btn btn-success btn-sm text-white cursor-pointer"
                                data-url="{{ route('bills.show', $row->id) }}" data-ajax-popup="true"
                                data-title="View Bill" data-bs-toggle="tooltip" title="View"
                                data-original-title="View"><i class="fa fa-eye"></i></a>
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
        @else
        <div style="width:100%;text-align:center">No data found.</div>
        @endif
    </div>

    <style>
        {
            display: inline-block;
            position: absolute;
            z-index: 2;
        }
    </style>

    <style>
        body {
            margin: 0;
            padding: 0;
            height: 100vh;
            display: flex;
            flex-direction: column;
        }

        .container {
            flex: 1;
            overflow-y: auto;
        }

        .row {
            flex-grow: 1;
        }

        .table-responsive {
            max-height: calc(100vh - 250px);
            overflow-y: auto;
        }
    </style>

    {{-- <script>
        $('.btn-search').click(function(){
            // var month_no = $('#month_no').val();
            var month_no = 1;
            var customer_id = $('#customer_id').val();
            customer_id = customer_id.trim();
            if(customer_id!=''){
                let url = "{{ url('/ending-bills') }}/" + month_no + "/" + customer_id;
            }else{
                let url = "{{ url('/ending-bills') }}/" + month_no;
            }
            window.location.href = url;
        });
    </script> --}}

    <script>
    $('.btn-search').click(function() {
        var month_no = $('input[name="month_no"]:checked').val();
        var customer_id = $('#customer_id').val().trim();
        var url = "{{ url('report/ending-bills') }}/" + month_no;

        if (customer_id !== '') {
            url += "/" + customer_id;
        }

        window.location.href = url;
    });
    </script>


@endsection
