@extends('layouts.app')

@section('title')
    Bill Edit
@endsection

@section('content')
{{-- <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css"> --}}
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Edit Bill (No- {{ str_pad($bill->id, 5, '0', STR_PAD_LEFT) }})</h4>
        </div>
        {{-- <div class="col-md-6 text-right">
            <a href="{{ route('bills.index') }}" class="btn btn-primary">Bills</a>
        </div> --}}
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_content" style="padding:0">

                    <form id="billForm" action="{{ route('bills.update', $bill->id) }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')

                        <div class="row">
                            <div class="col-md-4">
                                <label for="customer_id">Customer* :&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    <span class="binNo" style="color:#000;display:none">BIN No: {{$bill->bin_number}}</span></label>
                                <select id="customer_id" name="customer_id" class="form-control readmode" required readonly>
                                    <option value="">--Select Customer--</option>
                                    @foreach ($customers as $row)
                                    <option value="{{$row->autoAcNo}}" {{ $autoAcNo == $row->autoAcNo ? 'selected' : '' }}
                                        data-extra="{{$row->bin_no}}">{{$row->customer_name}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="bin_number">Bin Number :</label>
                                <input type="text" id="bin_number" class="form-control" name="bin_number" value="{{$binNo}}" readonly/>
                            </div>
                            <div class="col-md-4">
                                <label for="department_id">Department* :</label>
                                <select id="department_id" name="department_id" class="form-control readmode" required readonly>
                                    <option value="">--Select Department--</option>
                                    @foreach ($departments as $row)
                                        @if($row['divCode']!='000')
                                        <option value="{{$row['divCode']}}" {{ $bill->department_id == $row['divCode'] ? 'selected' : '' }}>{{$row['divName']}}</option>
                                        @endif
                                    @endforeach
                                </select>
                                <input type="hidden" id="billDivName" name="billDivName" value="{{ $bill->billDivName }}">
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <label for="particular">Particulars :</label>
                                <input type="text" id="particulars" class="form-control" name="particulars" value="{{ $bill->particulars }}" />
                            </div>
                            <div id="currency-container" class="col-md-4">
                                <label for="currency">Currency* :</label>
                                <select id="currency" name="currency" class="form-control select2" required>
                                    <option value="BDT" {{ $bill->currency == 'BDT' ? 'selected' : '' }}>BDT</option>
                                    <option value="USD" {{ $bill->currency == 'USD' ? 'selected' : '' }}>USD</option>
                                </select>
                            </div>

                            <div class="col-md-4">
                                <label for="currency_rate">Currency Rate* :</label>
                                <input type="number" id="currency_rate" class="form-control" name="currency_rate" min="1" required value="{{ old('currency_rate', $bill->currency_rate) }}"/>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <label for="qty">Bill Qty* :</label>
                                <input type="number" id="qty" min="1" class="form-control" name="qty" value="{{ $bill->qty }}" required />
                            </div>
                            <div class="col-md-4">
                                <label for="unit_price_vat">Unit Price* :</label>
                                <input type="number" id="unit_price_vat" min="1" step="0.01" class="form-control" name="unit_price_vat" value="{{ $bill->unit_price_vat }}" required />
                            </div>
                            <div class="col-md-4">
                                <label for="unit_total">Unit Total :</label>
                                <input type="number" id="unit_total" value="{{ $bill->unit_total }}" class="form-control"
                                    name="unit_total" readonly />
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <label for="vat_status">VAT Status :</label>
                                <select id="vat_status" name="vat_status" class="form-control">
                                    <option value="1" {{ $bill->vat_status == '1' ? 'selected' : '' }}>Yes</option>
                                    <option value="0" {{ $bill->vat_status == '0' ? 'selected' : '' }}>No</option>
                                </select>
                            </div>
                           <div class="col-md-4">
                                <label for="vat_percent">VAT (%)* :</label>
                                <select id="vat_percent" name="vat_percent" class="form-control">
                                    <option value="">--Select VAT--</option>
                                    @foreach ($vatsetup as $vatsetups)
                                        <option value="{{ $vatsetups->vat }}" {{ $bill->vat_percent == $vatsetups->vat ? 'selected' : '' }}>
                                            {{ $vatsetups->vat }}
                                        </option>
                                    @endforeach
                                </select>
                                <input type="hidden" id="vat_percent_hidden" name="vat_percent_hidden" value="">
                            </div>
                            <div class="col-md-4">
                                <label for="vat_type">VAT Type* :</label>
                                <select id="vat_type" name="vat_type" class="form-control" >
                                    <option value="Excluded" {{($bill->vat_type=='Excluded')? 'selected':''}}>Excluded VAT</option>
                                    <option value="Included" {{($bill->vat_type=='Included')? 'selected':''}}>Included VAT</option>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <label for="vat_amount">VAT Amount :</label>
                                <input type="number" id="vat_amount" value="{{ $bill->vat_amount}}" class="form-control"
                                    name="vat_amount" readonly />
                            </div>
                            <div class="col-md-4">
                                <label for="total_amount">Net Amount :</label>
                                <input type="number" id="total_amount" class="form-control"
                                    name="total_amount" value="{{ number_format($bill->total_amount, 2, '.', '') }}" readonly />
                            </div>
                            <div class="col-md-4">
                                <label for="total_amount_vat">Total Amount:</label>
                                <input type="number" id="total_amount_vat" class="form-control"
                                    name="total_amount_vat" value="{{ number_format($bill->total_amount_vat, 2, '.', '') }}" readonly />
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <label for="ref_no">Bill Ref. No* :</label>
                                <input type="text" id="ref_no" class="form-control" name="ref_no" value="{{ $bill->ref_no }}" required/>
                            </div>
                            <div class="col-md-4">
                                <label for="ref_date">Bill Ref. Date* :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker" name="ref_date" id="ref_date" value="{{ $bill->ref_date }}" placeholder="dd/mm/yyyy" autocomplete="off" required>
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="installation_date">Date of Installation* :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker" name="installation_date" id="installation_date" value="{{ $bill->installation_date }}" placeholder="dd/mm/yyyy" autocomplete="off" required>
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <label for="start_date">Bill Start Date* :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker" name="start_date" id="start_date" value="{{ $bill->start_date }}" placeholder="dd/mm/yyyy" autocomplete="off" required>
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="end_date">Bill End Date* :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker" name="end_date" id="end_date" value="{{ $bill->end_date }}" placeholder="dd/mm/yyyy" autocomplete="off" required>
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="activation_date">Activation Date* :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker" name="activation_date" id="activation_date" value="{{ $bill->activation_date }}" placeholder="dd/mm/yyyy" autocomplete="off" required>
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <label for="bill_subject_id">Bill Subject* :&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    <span class="hsCode" style="color:#000;"></span></label>
                                <select id="bill_subject_id" name="bill_subject_id" class="form-control select2" required>
                                    <option value="">--Select Bill Subject--</option>
                                    @foreach ($billSubjects as $billSubject)
                                        <option value="{{ $billSubject->id }}"
                                            {{ $bill->bill_subject_id == $billSubject->id ? 'selected' : '' }}>
                                                {{ $billSubject->bill_subject }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <script>
                                let subjectArr = {};
                                subjectArr[''] = '';

                                @foreach ($billSubjects as $billSub)
                                subjectArr[{{$billSub->id}}] = "{{$billSub->hs_code}}";
                                @endforeach

                                $('#bill_subject_id').change(function(){
                                    var subjectID = $(this).val();
                                    $('.hsCode').text('HS Code: '+subjectArr[subjectID]);
                                });
                            </script>


                            <div class="col-md-4">
                                <label for="bill_group">Bill Group* :</label>
                                <input type="text" id="bill_group" class="form-control" required name="bill_group" value="{{ $bill->bill_group }}" />
                            </div>
                            <div class="col-md-4">
                                <label for="order_sl_no">Bill Order Sl. No :</label>
                                <input type="number" id="order_sl_no" class="form-control" required name="order_sl_no" value="{{ $bill->order_sl_no }}" readonly />
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <label for="increase_start_date">Increase Start Date :</label>
                                <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                    <input type="text" class="form-control has-feedback-left custom-datepicker" name="increase_start_date" id="increase_start_date" value="{{ $bill->increase_start_date }}" placeholder="dd/mm/yyyy" autocomplete="off">
                                    <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                    <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <label for="yearly_increase_percent">Yearly Increase (%) :</label>
                                <input type="number" id="yearly_increase_percent" class="form-control" name="yearly_increase_percent" value="{{ $bill->yearly_increase_percent }}" />
                            </div>
                            <div class="col-md-4">
                                <label for="increase_period">Increase Period :</label>
                                <select id="increase_period" class="form-control select2" name="increase_period">
                                    <option value="">--Select Increase Period--</option>
                                    <option value="3" {{ $bill->increase_period == '3' ? 'selected' : '' }}>3 months</option>
                                    <option value="6" {{ $bill->increase_period == '6' ? 'selected' : '' }}>0.5 years</option>
                                    <option value="12" {{ $bill->increase_period == '12' ? 'selected' : '' }}>1 year</option>
                                    <option value="24" {{ $bill->increase_period == '24' ? 'selected' : '' }}>2 years</option>
                                    <option value="36" {{ $bill->increase_period == '36' ? 'selected' : '' }}>3 years</option>
                                    <option value="48" {{ $bill->increase_period == '48' ? 'selected' : '' }}>4 years</option>
                                    <option value="60" {{ $bill->increase_period == '60' ? 'selected' : '' }}>5 years</option>
                                    <option value="72" {{ $bill->increase_period == '72' ? 'selected' : '' }}>6 years</option>
                                    <option value="120" {{ $bill->increase_period == '120' ? 'selected' : '' }}>10 years</option>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <label for="bill_type">Bill Type* :</label>
                                <select id="bill_type" name="bill_type" class="form-control select2" required>
                                    <option value="">--Select Bill Type--</option>
                                    <option value="One Time" {{ $bill->bill_type == 'One Time' ? 'selected' : '' }}> One Time</option>
                                    <option value="Monthly" {{ $bill->bill_type == 'Monthly' ? 'selected' : '' }}>Monthly</option>
                                    <option value="Quarterly" {{ $bill->bill_type == 'Quarterly' ? 'selected' : '' }}>Quarterly</option>
                                    <option value="Half Yearly" {{ $bill->bill_type == 'Half Yearly' ? 'selected' : '' }}>Half Yearly</option>
                                    <option value="Yearly" {{ $bill->bill_type == 'Yearly' ? 'selected' : '' }}>Yearly</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <label for="vat_refund">VAT Stamp* :</label>
                                <select id="vat_refund" name="vat_refund" class="form-control select2">
                                    <option value="1" {{ $bill->vat_refund == '1' ? 'selected' : '' }}>Yes</option>
                                    <option value="0" {{ $bill->vat_refund == '0' ? 'selected' : '' }}>No</option>
                                </select>
                                {{-- This will happen before first editing --}}
                                @if($bill->bill_subject_id=='' && $bill->vat_refund=='0')
                                <script>
                                    $("#vat_refund").val(1);
                                </script>
                                @endif
                            </div>
                            <div class="col-md-4">
                                <label for="status">Status* :</label>
                                <select id="status" name="status" class="form-control select2">
                                    <option value="Active" {{ $bill->status == 'Active' ? 'selected' : '' }}>Active</option>
                                    <option value="Inactive" {{ $bill->status == 'Inactive' ? 'selected' : '' }}>Inactive</option>
                                </select>
                            </div>
                        </div>

                        <div class="row">
                            <div class="form-group col-md-4">
                                <label for="work_order">Work order / PO* :</label>
                                @if($bill->workorder_file)
                                    <div class="existing-file">
                                        <a href="{{ asset('storage/workorders/' . $bill->workorder_file) }}" target="_blank" title="view file">
                                            <u>{{ $bill->workorder_file }}</u>
                                        </a>

                                        <button type="button" class=" btn-danger btn-sm delete-file" data-file="work_order"
                                        style="width: 20px; height: 20px; line-height: 16px; font-size: 14px; text-align: center; padding: 0; border-radius: 50%;">x</button>
                                    </div>
                                @endif
                                <input type="file" id="work_order" name="work_order" class="form-control" accept=".jpg, .jpeg, .png, .pdf">
                                <input type="hidden" id="delete_work_order" name="delete_work_order" value="0">
                                <span style="color: red; ">(jpg, .jpeg, .png, .pdf)</span>
                            </div>

                            <div class="form-group col-md-4">
                                <label for="installation_uat">Installation / Delivery Challan* :</label>
                                @if($bill->instalation_file)
                                    <div class="existing-file">
                                        <a href="{{ asset('storage/installation/' . $bill->instalation_file) }}" target="_blank" title="view file">
                                            <u>{{ $bill->instalation_file }}</u>
                                        </a>

                                        <button type="button" class=" btn-danger btn-sm delete-file" data-file="installation_uat" style="width: 20px; height: 20px; line-height: 16px; font-size: 14px; text-align: center; padding: 0; border-radius: 50%;">x</button>
                                    </div>
                                @endif
                                <input type="file" id="installation_uat" name="installation_uat" class="form-control" accept=".jpg, .jpeg, .png, .pdf">
                                <input type="hidden" id="delete_installation_uat" name="delete_installation_uat" value="0">
                                <span style="color: red; ">(jpg, .jpeg, .png, .pdf)</span>
                            </div>

                            <div class="form-group col-md-4">
                                <label for="delivery_challan">UAT :</label>
                                @if($bill->deliverychallan_file)
                                    <div class="existing-file">
                                        <a href="{{ asset('storage/deliverychallan/' . $bill->deliverychallan_file) }}" target="_blank" title="view file">
                                            <u>{{ $bill->deliverychallan_file }}</u>
                                        </a>

                                        <button type="button" class=" btn-danger btn-sm delete-file" data-file="delivery_challan" style="width: 20px; height: 20px; line-height: 16px; font-size: 14px; text-align: center; padding: 0; border-radius: 50%;">x</button>
                                    </div>
                                @endif
                                <input type="file" id="delivery_challan" name="delivery_challan" class="form-control" accept=".jpg, .jpeg, .png, .pdf">
                                <input type="hidden" name="delete_delivery_challan" id="delete_delivery_challan" value="0">
                                <span style="color: red; ">(jpg, .jpeg, .png, .pdf)</span>
                            </div>

                         </div>

                        <div class="row">
                            <div class="col-md-12">
                                <br />
                                <input type="hidden" name="approve" id="billApprove">
                                {{-- <a href="{{ route('bills.index') }}" class="btn btn-info">Cancel</a> --}}
                                <a href="{{ url()->previous() }}" class="btn btn-info">Cancel</a>
                                <button type="submit" class="btn btn-success" id="btnBillSubmit">Submit</button>

                                {{-- When from rejected page --}}
                                @if($bill->approval=='0')
                                    {{-- @can('Edit Bill') --}}
                                        <a class="btn btn-warning text-dark cursor-pointer" id="btnBillRequestApproval">Request Approval</a>
                                    {{-- @endcan --}}
                                    @can('Delete Bill')
                                        <a data="{{ route('bills.single.delete', [$bill->id,'rejected']) }}"
                                            class="btn btn-danger delete-btn text-white cursor-pointer">Reject</a>
                                    @endcan
                                @endif


                                {{-- When from pending page --}}
                                @if($bill->approval=='')
                                    @can('Approve Bill')
                                        <a class="btn btn-primary text-white cursor-pointer" id="btnBillApprove">Approve</a>
                                        <script>
                                            $("#btnBillSubmit").hide();
                                        </script>
                                    @endcan
                                    @can('Approve Bill')
                                    <a onclick="showRejectNoteModal({{ $bill->id }})" class="btn btn-warning text-dark">Back</a>
                                    @endcan
                                    @can('Delete Bill')
                                        <a data="{{ route('bills.single.delete', [$bill->id,'pending']) }}"
                                            class="btn btn-danger delete-btn text-white cursor-pointer">Reject</a>
                                    @endcan
                                    @can('Reject From Editor')
                                    <a onclick="showRejectNoteModalEditor({{ $bill->id }})" class="btn btn-warning text-dark">Reject.</a>
                                    @endcan
                                @endif
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>

    <!-- Reject Note Modal -->
    <div class="modal fade" id="rejectNoteModal" tabindex="-1" role="dialog" aria-labelledby="rejectNoteModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form id="rejectNoteForm" method="post" action="{{ route('bills.edit.back', $bill->id) }}">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="rejectNoteModalLabel">Reject Note</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="reject_note_text">Please provide a reason for rejection:</label>
                            <textarea id="reject_note_text" name="reject_note_text" class="form-control" required></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <!-- <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button> -->
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Reject Note Modal From Editor-->
    <div class="modal fade" id="rejectNoteModalEditor" tabindex="-1" role="dialog" aria-labelledby="rejectNoteModalEditorLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form id="rejectNoteFormEditor" method="post" action="{{ route('bills.edit.backEditor', $bill->id) }}">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="rejectNoteModalEditorLabel">Reject Note</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="reject_note_text">Please provide a reason for rejection:</label>
                            <textarea id="reject_note_text" name="reject_note_text" class="form-control" required></textarea>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <!-- <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button> -->
                        <button type="submit" class="btn btn-primary" id="makeRejBtnDisabled">Submit</button>
                    </div>
                    <script>
                        // $(document).ready(function() {
                        //     $('#rejectNoteFormEditor').on('submit', function(event) {
                        //         event.preventDefault(); // Prevents the form from submitting
                        //         //alert('Form submission prevented!');
                        //         // You can add your custom logic here
                        //         if($('#reject_note_text').val()==''){
                        //             $('#makeRejBtnDisabled').hide('');
                        //         }
                        //     });
                        // });

                    </script>
                </div>
            </form>
        </div>
    </div>

    <style>
        form label {
            margin-bottom: 2px;
            margin-top: 8px;
        }
    </style>
@endsection

@section('script')
    <script>
        $('#department_id').change(function(){
            var selOption = $(this).children('option:selected');
            var selText = selOption.text();
            $('#billDivName').val(selText);
        });

        function showRejectNoteModal(billId) {
            $('#rejectNoteModal').modal('show');
        }

        function showRejectNoteModalEditor(billId) {
            $('#rejectNoteModalEditor').modal('show');
        }

        // function calcTotalWithVAT(){
        //     var total_amount = parseFloat($('#total_amount').val());
        //     var vat_status = $('#vat_status').val();
        //     var vat_percent = $('#vat_percent').val();
        //     var total_amount_vat = total_amount;
        //     if(vat_status=='1' && vat_percent!=''){
        //         if(vat_percent>0){
        //             var vatAmt = (total_amount * vat_percent)/100;
        //             total_amount_vat = total_amount + vatAmt;
        //         }
        //     }
        //     $('#total_amount_vat').val(total_amount_vat.toFixed(2));
        // }

        // $(document).ready(function() {
        //     function calculateTotal() {
        //         var qty = parseFloat($('#qty').val()) || 0;
        //         var unitPrice = parseFloat($('#unit_price_vat').val()) || 0;
        //         var total = qty * unitPrice;
        //         $('#total_amount').val(total.toFixed(2));
        //         calcTotalWithVAT();
        //     }

        //     $('#qty, #unit_price_vat').on('input', calculateTotal);
        // });
    </script>



<script>
    // CURRENCY CHANGES
    $(document).ready(function() {
        function updateCurrencyRateField() {
            var selectedCurrency = $('#currency').val();
            var currencyRateField = $('#currency_rate');

            if (selectedCurrency === 'BDT') {
                // Set the value to 1, make it read-only, and ensure it's visible
                currencyRateField.val('1').prop('readonly', true).show();
            } else {
                // Keep existing value, make it editable, and ensure it's visible
                currencyRateField.prop('readonly', false).show();
            }
        }

        // Initial update based on default selected currency
        updateCurrencyRateField();

        // Update field on currency change
        $('#currency').change(function() {
            updateCurrencyRateField();
        });
    });
</script>



<script>
    document.addEventListener('DOMContentLoaded', function () {
        document.querySelectorAll('.delete-file').forEach(function (button) {
            button.addEventListener('click', function () {
                const fileInput = document.querySelector('#' + this.dataset.file);

                if (fileInput) {
                    fileInput.value = '';
                    document.getElementById('delete_' + this.dataset.file).value = '1';

                }

                if (fileInput) {
                    if (this.dataset.file === 'work_order') {
                        // Set the input field to be required if the file is deleted
                        fileInput.required = true;
                    }
                }
                if (fileInput) {
                    if (this.dataset.file === 'installation_uat') {
                        // Set the input field to be required if the file is deleted
                        fileInput.required = true;
                    }
                }

                this.closest('.existing-file').remove();
            });
        });
    });

</script>




<script>
    $(document).ready(function () {
        const startDateInput = $('#start_date');
        const endDateInput = $('#end_date');

        startDateInput.on('change', function () {
            const startDate = startDateInput.val();
            if (startDate) {
                endDateInput.attr('min', startDate);
            }
        });

        endDateInput.on('change', function () {
            const startDate = new Date(startDateInput.val().split('/').reverse().join('-'));
            const endDate = new Date(endDateInput.val().split('/').reverse().join('-'));

            if (endDate < startDate) {
                show_toastr('error', 'End Date must be greater than or equal to Start Date');
                endDateInput.val('');
            }
        });
    });
</script>



<script>
$(document).ready(function() {
    var initialCustomerId = $('#customer_id').val();
    var initialBillSubjectId = $('#bill_subject_id').val();
    var initialVatRefund = $('#vat_refund').val();
    var initialOrderSlNo = $('#order_sl_no').val();

    function updateOrderSlNo() {
        var customerId = $('#customer_id').val();
        var billSubjectId = $('#bill_subject_id').val();
        var vatRefund = $('#vat_refund').val();

        if (customerId && billSubjectId && vatRefund) {
            $.ajax({
                url: '{{ route('getOrderSlNo') }}',
                method: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    customer_id: customerId,
                    bill_subject_id: billSubjectId,
                    vat_refund: vatRefund,
                    initial_customer_id: initialCustomerId,
                    initial_bill_subject_id: initialBillSubjectId,
                    initial_vat_refund: initialVatRefund,
                    current_order_sl_no: initialOrderSlNo
                },
                success: function(response) {
                    if (response.next_order_sl_no !== undefined) {
                        $('#order_sl_no').val(response.next_order_sl_no).prop('readonly', true);
                    } else {
                        console.error('Invalid response:', response);
                    }
                },
                error: function(xhr) {
                    console.error('AJAX request failed:', xhr.responseText);
                }
            });
        }
    }

    $('#customer_id, #bill_subject_id, #vat_refund').change(function() {
        updateOrderSlNo();
    });
});
</script>




<script>
    $(document).ready(function () {
        const $vatStatus = $('#vat_status');
        const $vatPercent = $('#vat_percent');
        const $vatPercentHidden = $('#vat_percent_hidden');
        const $vatPercentError = $('#vat_percent_error');
        const originalOptions = $vatPercent.html(); // Save original options

        function updateVatPercent() {
            if ($vatStatus.val() === '1') { // Yes selected
                $vatPercent.html(originalOptions); // Show all options
                $vatPercent.prop('disabled', false); // Enable the field
                $vatPercent.prop('required', true); // Make it required
                $vatPercentHidden.val(''); // Clear hidden field value
            } else { // No selected
                $vatPercent.html('<option value="">--Select VAT--</option>'); // Show only default option
                $vatPercent.val(''); // Clear the current value
                $vatPercent.prop('disabled', true); // Disable the field
                $vatPercent.prop('required', false); // Remove required
                $vatPercentError.hide(); // Hide any existing error message
                $vatPercentHidden.val('null'); // Set hidden field value to 'null'
            }
        }

        function validateVatPercent() {
            if ($vatStatus.val() === '1' && !$vatPercent.val()) { // If Yes and no value selected
                $vatPercentError.show(); // Show error message
                return false; // Prevent form submission or further actions
            } else {
                $vatPercentError.hide(); // Hide error message
                return true; // Allow form submission or further actions
            }
        }

        $vatStatus.change(function () {
            updateVatPercent();
            validateVatPercent(); // Validate on status change
            calcTotal();
        });

        $vatPercent.change(function () {
            validateVatPercent(); // Validate on VAT% change
            calcTotal();
        });

        // Initialize on page load
        updateVatPercent();

        $('#qty, #unit_price_vat').on('input', calcTotal);
        $('#vat_type').change(function(){
            calcTotal();
        });
        $('#vat_status').change(function(){
            calcTotal();
        });
        $('#vat_percent').change(function(){
            calcTotal();
        });

        function calcTotal(){
            let qty = parseInt($('#qty').val()) || 0;
            let unitPrice = parseFloat($('#unit_price_vat').val()) || 0;
            let vatStatus = $('#vat_status').val();
            let vatPercent = parseFloat($('#vat_percent').val()) || 0;
            let vatType = $('#vat_type').val();
            let vatAmount = 0.00;
            let netAmount = 0.00;
            let totalAmount = 0.00;

            let unitTotal = qty*unitPrice;
            $('#unit_total').val(unitTotal.toFixed(2));

            if(vatStatus==1){
                if(vatType=='Excluded'){
                    vatAmount = unitTotal * (vatPercent/100);
                    totalAmount = unitTotal + vatAmount;
                    $('#total_amount').val((unitTotal).toFixed(2)); //net amount
                    $('#total_amount_vat').val(totalAmount.toFixed(2)); // total amount
                }else{ // included
                    totalAmount = unitTotal/(1+(vatPercent/100));
                    vatAmount = unitTotal - totalAmount;
                    $('#total_amount').val((unitTotal-vatAmount).toFixed(2)); //net amount
                    $('#total_amount_vat').val(unitTotal.toFixed(2)); // total amount
                }
            }else{
                $('#total_amount').val(unitTotal.toFixed(2)); //net amount
                $('#total_amount_vat').val(unitTotal.toFixed(2)); // total amount
            }
            $('#vat_amount').val(vatAmount.toFixed(2));

        }
    });


    $('#btnBillApprove').click(function(){
        $('#billApprove').val(1);
        // $('#btnBillSubmit').click(); -- BAD --
        // $('#billForm').submit();

        const form = $('#billForm')[0];
        if (!form.checkValidity()) {
            form.reportValidity();
            return;
        }
        form.submit();

    });

    $('#btnBillRequestApproval').click(function(){
        $('#billApprove').val(2);
        $('#btnBillSubmit').click();
    });

    $(document).on("click", ".delete-btn", function () {
        var hrefValue = $(this).attr('data');
        const swalWithBootstrapButtons = Swal.mixin({
            customClass: {
                confirmButton: "btn btn-success",
                cancelButton: "btn btn-danger",
            },
            buttonsStyling: false,
        });
        swalWithBootstrapButtons
            .fire({
                title: "Are you sure?",
                text: "You won't be able to revert this!",
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: "Yes, Reject it!",
                cancelButtonText: "No, cancel!",
                reverseButtons: true,
            })
            .then((result) => {
                if (result.isConfirmed) {
                    window.location.replace(hrefValue);
                } else if (result.dismiss === Swal.DismissReason.cancel) {
                }
            });
    });


</script>

@endsection

