@extends('layouts.app')

@section('title')
    Awaiting Bills
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Awaiting Bills</h4>
        </div>
    </div>


            <form action="{{ route('bills.awaiting') }}" method="GET" class="num_filter px-4">
                <label for="per_page">Show</label>
                <select name="per_page" id="per_page" onchange="this.form.submit()" style="height: 40px; width: 70px; border: 1px solid #ced4da; border-radius: 4px">
                    <option value="25" {{ $perPage == 25 ? 'selected' : '' }}>25</option>
                    <option value="50" {{ $perPage == 50 ? 'selected' : '' }}>50</option>
                    <option value="100" {{ $perPage == 100 ? 'selected' : '' }}>100</option>
                    <option value="{{ $bills->total() }}" {{ $perPage == $bills->total() ? 'selected' : '' }}>All</option>
                </select>
                Entries
            </form>

<form id="billListForm">
    @csrf
    <div class="row">
        <table id="datatable-buttons" class="table table-striped table-bordered" style="width:100%">
            <thead>
                <tr>
                    <th class="text-center"><input type="checkbox" class="custom-checkbox" id="select-all" /><label
                            for="select-all">
                        </label></th>
                    <th>Sl</th>
                    <th>Bill No</th>
                    <th>Customer</th>
                    <th>Qty</th>
                    <th>Currency</th>
                    <th>Net Amount</th>
                    <th>VAT Amount</th>
                    <th>Total Amount</th>
                    <th>Bill Type</th>
                    <th style="width:60px;">Action</th>
                </tr>
            </thead>

            <tbody>
                @foreach ($bills as $row)
                    <tr>
                        <td class="text-center">
                            <input type="checkbox" class="custom-checkbox" id="selected_bills_{{ $row->id }}"
                                name="selected_bills[]" value="{{ $row->id }}" /><label
                                for="selected_bills_{{ $row->id }}"></label>
                        </td>
                        <!-- <td>{{ $loop->iteration }}</td> -->
                        <td>{{ $loop->iteration + ($bills->currentPage() - 1) * $bills->perPage() }}</td>
                        <td>{{ str_pad($row->id, 5, '0', STR_PAD_LEFT) }}</td>
                        <td>{{ $row->customer ? $row->customer->customer_name : '-' }}</td>
                        <td class="text-right">{{ $row->qty }}</td>
                        <td>{{ $row->currency }}</td>
                        <td class="text-right">{{ \App\Models\Settings::priceFormat($row->total_amount) }}</td>
                        <td class="text-right">{{ \App\Models\Settings::priceFormat($row->vat_amount) }}</td>
                        <td class="text-right">{{ \App\Models\Settings::priceFormat($row->total_amount_vat) }}</td>
                        <td>{{ $row->bill_type ? $row->bill_type : '-' }}</td>
                        <td>
                            {{-- <a href="{{ route('bills.awaiting.edit', $row->id) }}" class="btn btn-success btn-sm">View</a> --}}

                            <a data-size="xl" class="btn btn-success btn-sm text-white cursor-pointer"
                                data-url="{{ route('bills.awaiting.edit', $row->id) }}" data-ajax-popup="true"
                                data-title="View Bill" data-bs-toggle="tooltip" title="View"
                                data-original-title="View">View</a>

                            @php
                                $notes = \App\Models\BillNote::where('bill_id',$row->id)->first();
                            @endphp

                            @if($notes)
                            <a data-size="lg" class="btn btn-warning btn-sm text-white cursor-pointer"
                                data-url="{{ route('bills.reject.note', $row->id) }}" data-ajax-popup="true"
                                data-title="View Reject Note" data-bs-toggle="tooltip" title="View Reject Note"
                                data-bs-custom-class="custom-tooltip">
                                <i class="fa fa-info-circle"></i>
                            </a>
                            @endif

                            {{-- <a data-size="lg" class="btn btn-info btn-sm text-white cursor-pointer"
                                data-url="{{ route('bills.show', $row->id) }}" data-ajax-popup="true"
                                data-title="View Bill" data-bs-toggle="tooltip" title="View"
                                data-original-title="View">View</a> --}}
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    <input type="hidden" id="status" name="status">
</form>


    <div class="row mt-3">
        <div class="col-md-12 d-flex justify-content-between">
            <div>
                Showing {{ $bills->firstItem() }} to {{ $bills->lastItem() }} of {{ $bills->total() }} entries
            </div>
            <div>
                {{ $bills->appends(['per_page' => $perPage])->links('vendor.pagination.custom-pagination') }}
            </div>
        </div>
    </div>


    <div class="row mt-3">
        <div class="col-md-12 text-center">
            @if (count($bills) > 0)
                <a onclick="statusChangeBatch(200)" class="btn btn-primary text-white">Approve</a>
                <a onclick="statusChangeBatch(3)" class="btn btn-danger text-white cursor-pointer">Reject</a>
            @endif
        </div>
    </div>


    <script>
        $('#select-all').click(function() {
            $('input[name="selected_bills[]"]').prop('checked', this.checked);
        });

        // function showRejectNoteModal(billId) {
        //     $('#rejectNoteForm').off('submit').on('submit', function(e) {
        //         e.preventDefault();
        //         var rejectNote = $('#reject_note_text').val();
        //         var actionUrl = '{{ route("bills.statusChange", ["id" => ":id", "status" => 0]) }}';
        //         actionUrl = actionUrl.replace(':id', billId);
        //         $('#billListForm').attr('action', actionUrl);
        //         $('#billListForm').append('<input type="hidden" name="reject_note" value="' + rejectNote + '">'); // Add reject_note to form
        //         $('#billListForm').submit();
        //     });
        //     $('#rejectNoteModal').modal('show');
        // }


        // function showAllRejectNoteModal() {
        //     var selectedBills = $('input[name="selected_bills[]"]:checked');

        //     if (selectedBills.length > 0) {
        //         $('#allRejectNoteModal').modal('show');

        //         $('#allRejectNoteForm').off('submit').on('submit', function(e) {
        //             e.preventDefault();
        //             var rejectNote = $('#all_reject_note_text').val();

        //             // Process each selected bill
        //             selectedBills.each(function() {
        //                 var billId = $(this).val();
        //                 var status = 'rejected'; // Example status, set as needed

        //                 // Build the correct action URL for each bill
        //                 var actionUrl = '{{ route("bills.statusChange", ["id" => ":id", "status" => ":status"]) }}'
        //                     .replace(':id', billId)
        //                     .replace(':status', status);

        //                 // Update the form action dynamically
        //                 $('#allRejectNoteForm').attr('action', actionUrl);

        //                 // Append hidden inputs for the current bill
        //                 $('#allRejectNoteForm').append('<input type="hidden" name="selected_bills[]" value="' + billId + '">');
        //             });

        //             // Append the reject_note to the form
        //             $('#allRejectNoteForm').append('<input type="hidden" name="reject_note" value="' + rejectNote + '">');

        //             // Submit the form for the first selected bill (as an example)
        //             $('#allRejectNoteForm')[0].submit();
        //         });

        //     } else {
        //         show_toastr('error', 'Please, check bill from bill list');
        //     }
        // }


        function statusChangeBatch(status){
            var checkedCount = $('input[name="selected_bills[]"]:checked').length;
            if(checkedCount>0){

                if(status==3){ // if reject
                    const swalWithBootstrapButtons = Swal.mixin({
                        customClass: {
                            confirmButton: "btn btn-success",
                            cancelButton: "btn btn-danger",
                        },
                        buttonsStyling: false,
                    });
                    swalWithBootstrapButtons
                        .fire({
                            title: "Are you sure to reject it?",
                            text: "You won't be able to revert this!",
                            icon: "warning",
                            showCancelButton: true,
                            confirmButtonText: "Yes, Reject it!",
                            cancelButtonText: "No, cancel!",
                            reverseButtons: true,
                        })
                        .then((result) => {
                            if (result.isConfirmed) {
                                $('#status').val(status);
                                $('#billListForm').attr("method","post");
                                $('#billListForm').attr("action","{{ route('bills.awaiting.statusChangeBatch') }}");
                                $('#billListForm').submit();
                            } else if (result.dismiss === Swal.DismissReason.cancel) {
                            }
                        });
                }else{
                    $('#status').val(status);
                    $('#billListForm').attr("method","post");
                    $('#billListForm').attr("action","{{ route('bills.awaiting.statusChangeBatch') }}");
                    $('#billListForm').submit();
                }


            }else{
                show_toastr('error', 'Please, check bill from bill list');
            }
        }
    </script>

<style>
    {
        display: inline-block;
        position: absolute;
        z-index: 2;
    }
</style>

<style>
    body {
        margin: 0;
        padding: 0;
        height: 100vh;
        display: flex;
        flex-direction: column;
    }

    .container {
        flex: 1;
        overflow-y: auto;
    }

    .row {
        flex-grow: 1;
    }

    .table-responsive {
        max-height: calc(100vh - 250px);
        overflow-y: auto;
    }
</style>


@endsection
