@extends('layouts.app')
@section('title')
    Bill Process
@endsection

@section('content')
    <div class="row d-flex align-items-center mb-3">
        <div class="col-md-6">
            <h4 class="text-primary mb-0">Bill Process</h4>
        </div>
    </div>

    @if (session('error'))
        <div class="alert alert-danger alert-dismissible" style="font-size: 16px;">
            <button type="button" class="close" data-dismiss="alert">&times;</button>
            {{ session('error') }} Check on this:
                <a href="{{ route('report.bill-increase-warning-report') }}" title="Click on this"
                    style="color:yellow;font-size: 16px;"><u>Bill Increase Warning Report</u></a>
        </div>
    @endif

    <div class="row">
        <div class="col-md-12">
            <div class="x_panel p-20 rounded">
                <div class="x_title">
                    <h5>Find Bills</h5>
                    <div class="clearfix"></div>
                </div>
                <div class="x_content" style="padding:0">
                    <form id="reportForm" action="{{ route('bill-process.find') }}" method="POST">
                        @csrf

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="bill_type">Bill Type* :</label>
                                    <select id="bill_type" name="bill_type" class="form-control" required>
                                        <option value="">--Select Bill Type--</option>
                                        <option value="One Time">One Time</option>
                                        <option value="Recurring Service">Recurring Service</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div><label for="month">Bill Month* (MM-YY) :</label></div>
                                    <div class="col-md-6" style="padding: 0">
                                        <select id="month" name="month" class="form-control select2" onchange="setDate()" required>
                                            <option value="January" {{(date('F')=='January')? 'selected':''}}>01</option>
                                            <option value="February" {{(date('F')=='February')? 'selected':''}}>02</option>
                                            <option value="March" {{(date('F')=='March')? 'selected':''}}>03</option>
                                            <option value="April" {{(date('F')=='April')? 'selected':''}}>04</option>
                                            <option value="May" {{(date('F')=='May')? 'selected':''}}>05</option>
                                            <option value="June" {{(date('F')=='June')? 'selected':''}}>06</option>
                                            <option value="July" {{(date('F')=='July')? 'selected':''}}>07</option>
                                            <option value="August" {{(date('F')=='August')? 'selected':''}}>08</option>
                                            <option value="September" {{(date('F')=='September')? 'selected':''}}>09</option>
                                            <option value="October" {{(date('F')=='October')? 'selected':''}}>10</option>
                                            <option value="November" {{(date('F')=='November')? 'selected':''}}>11</option>
                                            <option value="December" {{(date('F')=='December')? 'selected':''}}>12</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6" style="padding: 0">
                                        <select id="year" name="year" class="form-control select2" onchange="setDate()" required>
                                            @for ($year = 2000; $year <= date('Y'); $year++)
                                                @if ($year == date('Y'))
                                                    <option value="{{ $year }}" selected>{{ $year }}</option>
                                                @else
                                                    <option value="{{ $year }}">{{ $year }}</option>
                                                @endif
                                            @endfor
                                        </select>
                                    </div>
                                    <div style="clear:both"></div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="invoice_date">Invoice Date* :</label>

                                    <div class="col-md-12 xdisplay_inputx form-group row has-feedback px-0">
                                        <input type="text" class="form-control has-feedback-left custom-datepicker"
                                            name="invoice_date" id="invoice_date" placeholder="dd/mm/yyyy" value="{{date("t/m/Y")}}" autocomplete="off" required>
                                        <span class="fa fa-calendar-o form-control-feedback left" aria-hidden="true"></span>
                                        <span id="inputSuccess2Status" class="sr-only">(success)</span>
                                    </div>

                                    {{-- <input type="text" class="form-control" name="invoice_date" id="invoice_date" value="{{date("t/m/Y")}}" readonly> --}}
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="vat_refund">VAT Stamp* :</label>
                                    <select id="vat_refund" name="vat_refund" class="form-control select2">
                                        <option value="1">Yes</option>
                                        <option value="0">No</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="remarks">Remarks :</label>
                                    <textarea id="remarks" class="form-control" name="remarks"></textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <br />
                                <a href="{{ route('bill-process.index') }}" class="btn btn-info">Cancel</a>
                                <button type="submit" class="btn btn-primary process-btn">Next</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection


@section('script')
    <script>
        function setDate(){
            var monthName = $('#month').val();
            var year = $('#year').val();
            const lastDate = getLastDateOfMonth(year, monthName);
            // console.log(`The last date of ${monthName} ${year} is ${lastDate}.`);
            $('#invoice_date').val(lastDate+'/'+year);
        }

        function getMonthNumber(monthName) {
            const months = {
                "January": 1,
                "February": 2,
                "March": 3,
                "April": 4,
                "May": 5,
                "June": 6,
                "July": 7,
                "August": 8,
                "September": 9,
                "October": 10,
                "November": 11,
                "December": 12
            };
            return months[monthName] || -1; // Returns -1 if the month name is invalid
        }

        function getLastDateOfMonth(year, monthName) {
            const month = getMonthNumber(monthName);
            if (month === -1) {
                return "Invalid month name!";
            }
            // Month is 1-indexed here, so subtract 1 to get 0-indexed month
            var lastDate = new Date(year, month, 0).getDate();
            var monthNumFixed = String(month).padStart(2, '0');
            return lastDate+'/'+monthNumFixed;
        }
    </script>
    <script>
        $('.process-btn').click(function () {
            const form = $('#reportForm')[0];
            if (!form.checkValidity()) {
                form.reportValidity();
                return;
            }
            $('.ajaxLoaderFormLoad').show();
            form.submit();
        });
    </script>
@endsection
