@extends('layouts.app')

@section('title')
    Unposted Bill Process
@endsection

@section('content')
<script>
    $('.ajaxLoaderFormLoad').show();
</script>

        <div class="row d-flex align-items-center mb-3">
            <div class="col-md-4">
                <h4 class="text-primary mb-0">Unposted Bill Process</h4>
            </div>
            <div class="col-md-4">
                <h5 class="mb-0 text-info text-center">{{ $billfilters->month }}, {{ $billfilters->year }}</h5>
            </div>
            <div class="col-md-4 text-right">
                <a href="{{ route('bill-process-unposted') }}" class="btn btn-primary">Back</a>
                <a class="btn btn-warning print-btn text-dark">
                    <i class="fa fa-print" aria-hidden="true"></i> Print
                </a>
            </div>
            <div>
                Invoice Date: {{ $billfilters->invoice_date }}
            </div>
        </div>

        <form id="unpostedForm">
            @csrf
            <input type="hidden" name="req_month" value="{{ $billfilters->month }}">
            <input type="hidden" name="req_year" value="{{ $billfilters->year }}">
            <input type="hidden" name="req_customer" value="{{ $billfilters->customer }}">
        <div class="row" style="padding:0;overflow:auto">
            <table class="table table-striped table-bordered gridTable" style="width:100%;">
                <thead>
                    <tr>
                        <th>Sl</th>
                        <th>Bill No</th>
                        <th>Customer</th>
                        <th>Subject</th>
                        <th>Bill Group</th>
                        <th>Qty</th>
                        <th>Month<br>Year</th>
                        <th>Unit Price</th>
                        <th>Currency<br>& Rate</th>
                        <th>Nat Amount</th>
                        <th>VAT Amount</th>
                        <th>Total Amount</th>
                        <th>Bill Type</th>
                        <th>Action</th>
                    </tr>
                </thead>

                <tbody>
                    @foreach ($bills as $row)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>
                                {{ $row->id ? str_pad($row->id, 5, '0', STR_PAD_LEFT) : '-' }}
                                <input type="hidden" class="billID" name="billID[]" value="{{$row->id}}">
                                <input type="hidden" class="processStatus" name="processStatus[]" value="">
                                <input type="hidden" class="monthTitle" name="monthTitle[]" value="{{ $billfilters->month }} {{ $billfilters->year }}">
                            </td>
                            <td>{{ $customerInfo->customer_name }}</td>
                            <td>
                                @if(!empty($row->bill_subject_id) && !empty($row->billSubject))
                                {{$row->billSubject->bill_subject}}
                                @endif
                            </td>
                            <td class="text-center">
                                {{$row->bill_group}}
                            </td>
                            <td class="text-right">{{ $row->qty }}</td>
                            <td>
                                {{ $billfilters->month }} <br> {{ $billfilters->year }}
                                <input type="hidden" class="monthNo" value="{{ $billfilters->month }}">
                                <input type="hidden" class="yearNo" value="{{ $billfilters->year }}">
                            </td>
                            <td class="text-right">{{ priceFormat($row->unit_price_vat) }}</td>
                            <td>{{ $row->currency }}({{$row->currency_rate ?? 0}})</td>
                            <td class="text-right">{{ priceFormat($row->total_amount) }}</td>
                            <td class="text-right">{{ priceFormat($row->vat_amount ?? 0) }}</td>
                            <td class="text-right">{{ priceFormat($row->total_amount_vat) }}</td>
                            <td>{{ $row->bill_type ? $row->bill_type : '-' }}</td>
                            <td class="action-col" style="text-align: center; font-weight:bold">
                                {{-- <a data-size="xl" class="btn btn-info btn-sm text-white cursor-pointer"
                                    data-url="{{ route('bills.show', $row->id) }}" data-ajax-popup="true"
                                    data-title="View Bill" data-bs-toggle="tooltip" title="View"
                                    data-original-title="View">View</a> --}}

                                <a href="javascript:void(0)"
                                    class="btn btn-info btn-sm btn-process">
                                    Click to Process</a>

                            </td>
                        </tr>
                    @endforeach
                    @if (count($bills) === 0)
                        <tr>
                            <td colspan="14" class="text-center">No Bills Found!</td>
                        </tr>
                    @endif
                </tbody>
            </table>
        </div>

        <input type="hidden" name="bill_type" value="{{ $billfilters->bill_type }}">
        <input type="hidden" name="payment_type" value="{{ $billfilters->payment_type }}">
        <input type="hidden" name="month" id="month" value="{{ $billfilters->month }}">
        <input type="hidden" name="year" id="year" value="{{ $billfilters->year }}">
        <input type="hidden" name="invoice_date" id="invoice_date" value="{{ $billfilters->invoice_date }}">
        <input type="hidden" id="remarks" name="remarks" value="{{ $billfilters->remarks }}">
        <input type="hidden" name="executionTime" value="{{ $executionTime }}">

        </form>

    <script>

        // Btn Processing
        $('.btn-process').click(function(){

            // confirm check
            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: "btn btn-success",
                    cancelButton: "btn btn-danger",
                },
                buttonsStyling: false,
            });
            swalWithBootstrapButtons
                .fire({
                    title: "Are you sure to process?",
                    text: "",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonText: "Yes, Process it!",
                    cancelButtonText: "No, cancel!",
                    reverseButtons: true,
                })
                .then((result) => {
                    if (result.isConfirmed) {

                        // Do Process
                        var thisRow = $(this).closest('tr');
                        var billID = thisRow.find('.billID').val();
                        var monthNo = thisRow.find('.monthNo').val();
                        var yearNo = thisRow.find('.yearNo').val();
                        var remarks = $('#remarks').val();

                        thisRow.find('.action-col').html('<span class="spinner-border spinner-border-sm mb-1" role="status" aria-hidden="true"></span>');

                        $.ajax({
                            type: 'POST',
                            url: '{{ url("bill-proccess-single-post") }}',
                            data: {
                                billID: billID,
                                month: monthNo,
                                year: yearNo,
                                remarks: remarks,
                                invoice_date: $('#invoice_date').val(),
                                _token: '{{ csrf_token() }}'
                            },
                            success: function(data) {
                                if(data==1){
                                    thisRow.find('.action-col').html('Processed');
                                    thisRow.find('.processStatus').val(1);
                                    show_toastr('success', 'Bill processed successfully');
                                }else{
                                    thisRow.find('.action-col').html('<span style="color:red">Not Done</span>');
                                    show_toastr('error', 'Bill not processed');
                                }
                            },
                            error: function(xhr) {
                                console.error(xhr.responseText); // Handle errors
                            }
                        });


                    } else if (result.dismiss === Swal.DismissReason.cancel) {
                    }
                });


        });

        // PDF Download
        $('.print-btn').click(function(){

            if ($('.processStatus').length > 0) {
                let pdfExport = false;
                $('.processStatus').each(function () {
                    if ($(this).val() === "") {
                        pdfExport = true;
                        return false;
                    }
                });

                if (pdfExport) {
                    $('#unpostedForm').attr('method', 'post');
                    $('#unpostedForm').attr('action', '{{ route('bill-process-pdf-unposted') }}');
                    $("#unpostedForm").submit();
                }else{

                    show_toastr('error', 'No unposted bill found');
                    return false;
                }
            }else{
                show_toastr('error', 'No unposted bill found');
                return false;
            }

        });


    </script>

    <style>
        .gridTable thead th{
            padding: 5px 5px 5px 5px;
        }
        .gridTable tbody td{
            padding: 3px !important;
            vertical-align: middle !important;
        }
        .gridTable tbody td .form-control{
            padding: 3px;
            vertical-align: middle;
        }
        .btn-process{
            padding: 0px 4px;
        }
    </style>

    <script>
        $(document).ready(function(){
            $('.ajaxLoaderFormLoad').hide();
        });
    </script>

@endsection

@section('script')
@endsection
