<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('collections', function (Blueprint $table) {
            $table->id();
            $table->string('ref_no');
            $table->bigInteger('customer_id');
            $table->string('coll_date')->nullable();
            $table->string('instrument_mode')->nullable();
            $table->string('instrument_no')->nullable();
            $table->string('instrument_date')->nullable();
            $table->bigInteger('bank_id')->nullable();
            $table->string('received_amount')->nullable();
            $table->string('tds_amount')->nullable();
            $table->string('vat_amount')->nullable();
            $table->string('adjust_amount')->nullable();
            $table->string('total_coll_amount')->nullable();
            $table->string('advance_amount')->nullable();
            $table->string('excess_amount')->nullable();
            $table->string('money_receipt_no')->nullable();
            $table->string('money_receipt_date')->nullable();
            $table->string('bank_slip_no')->nullable();
            $table->string('bank_deposit_date')->nullable();
            $table->bigInteger('dep_bank_id')->nullable();
            $table->text('adj_remarks')->nullable();
            $table->bigInteger('created_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('collections');
    }
};
