<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bill_processes', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('bill_id');
            $table->string('invoice_no')->nullable();
            $table->bigInteger('sl_no')->nullable();
            $table->bigInteger('customer_id');
            $table->string('particulars')->nullable();
            $table->bigInteger('qty');
            $table->string('unit_price_vat');
            $table->string('total_amount');
            $table->bigInteger('bill_subject_id')->nullable();
            $table->string('ref_no')->nullable();
            $table->string('ref_date')->nullable();
            $table->string('installation_date')->nullable();
            $table->string('activation_date')->nullable();
            $table->string('start_date')->nullable();
            $table->string('end_date')->nullable();
            $table->bigInteger('attention_id')->nullable();
            $table->string('attention_person')->nullable();
            $table->string('department_id')->nullable();
            $table->string('billDivName')->nullable();
            $table->string('bill_group')->nullable();
            $table->string('bill_type')->nullable();
            $table->string('payment_type')->nullable();
            $table->string('vat_percent')->nullable();
            $table->string('vat_status')->nullable();
            $table->string('vat_refund')->nullable();
            $table->string('total_amount_vat')->nullable();
            $table->string('yearly_increase_percent')->nullable();
            $table->string('increase_start_date')->nullable();
            $table->string('payment_status')->nullable();
            $table->string('order_sl_no')->nullable();
            $table->string('month')->nullable();
            $table->string('year')->nullable();
            $table->string('invoice_date')->nullable();
            $table->string('remarks')->nullable();
            $table->bigInteger('processedBy')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bill_processes');
    }
};
