<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('customers', function (Blueprint $table) {
            $table->id();
            $table->string('customer_name');
            $table->text('address')->nullable();
            $table->string('phone');
            $table->string('attention_person')->nullable();
            $table->string('billing_name');
            $table->string('billing_phone');
            $table->string('billing_email');
            $table->string('billing_fax')->nullable();
            $table->string('account_name');
            $table->string('account_phone');
            $table->string('account_email');
            $table->string('account_fax')->nullable();
            $table->string('vat_reg_no')->nullable();
            $table->string('vat_code')->nullable();
            $table->decimal('advance_adjust', 20, 2);
            $table->string('autoAcNo')->nullable();
            $table->string('status');
            $table->string('autoAcNo')->nullable();
            $table->string('divCode')->nullable();
            $table->bigInteger('created_by');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('customers');
    }
};
