<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('bills', function (Blueprint $table) {

            $table->id();
            $table->unsignedBigInteger('project_id');
            $table->bigInteger('customer_id');
            $table->string('invoice_no')->nullable();
            $table->bigInteger('sl_no');
            $table->string('particulars')->nullable();
            $table->string('currency')->nullable();
            $table->decimal('currency_rate', 10, 2);
            $table->bigInteger('qty');
            $table->string('unit_price_vat');
            $table->string('total_amount');
            $table->string('bin_number')->nullable();
            $table->string('milestone')->nullable();
            $table->bigInteger('bill_subject_id')->nullable();
            $table->string('ref_no')->nullable();
            $table->string('ref_date')->nullable();
            $table->string('installation_date')->nullable();
            $table->string('activation_date')->nullable();
            $table->string('start_date')->nullable();
            $table->string('end_date')->nullable();
            $table->bigInteger('attention_id')->nullable();
            $table->string('attention_person')->nullable();
            $table->string('department_id')->nullable();
            $table->string('billDivName')->nullable();
            $table->string('bill_group')->nullable();
            $table->string('bill_type')->nullable();
            $table->string('payment_type')->nullable();
            $table->string('vat_percent')->nullable()->default(null);
            $table->string('vat_amount')->nullable();
            $table->string('conv_vat_amount')->nullable();
            $table->string('increase_period')->nullable();
            $table->string('vat_status')->nullable();
            $table->string('yearly_increase_percent')->nullable();
            $table->string('increase_start_date')->nullable();
            $table->string('status')->nullable();
            $table->string('vat_refund')->nullable();
            $table->string('order_sl_no')->nullable();
            $table->text('bill_note')->nullable()->default(null);
            $table->string('total_amount_vat')->nullable();
            $table->string('workorder_file')->nullable();
            $table->string('instalation_file')->nullable();
            $table->string('deliverychallan_file')->nullable();
            $table->decimal('convertion_total_amount', 10, 2)->nullable();
            $table->decimal('convertion_total_amount_vat', 10, 2)->nullable();
            $table->bigInteger('approval')->nullable();
            $table->bigInteger('approved_by')->nullable();
            $table->string('delete_flag')->default('0');
            $table->text('reject_note')->nullable()->default(null);
            $table->bigInteger('created_by')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('bills');
    }
};
