<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use DateTime;

class Settings extends Model
{
    use HasFactory;

    protected $table='billing_settings';

    protected $fillable = [
        'name',
        'value',
    ];

    public static function get_settings(){
        $data=Settings::all();
        $settings=[];

        foreach ($data as $row) {
            $settings[$row->name] = $row->value;
        }
        return $settings;
    }

    public static function getValue($key)
    {
        return optional(self::select('value')->where('name', $key)->first())->value ?? '';
    }

    public static function priceFormat($price)
    {
        if(trim($price)==''){
            $price = 0;
        }
        $settings = self::get_settings();
        return ($settings['currency_symbol'] ? $settings['currency_symbol'] : ''). number_format($price, $settings['decimal_number'] ? $settings['decimal_number'] : 0);
    }

    public static function invoiceFormat($value)
    {
        $settings = self::get_settings();

        $words = explode(' ', $settings['company_name']);
        $companyCode = '';
        foreach ($words as $word) {
            $companyCode .= substr($word, 0, 1);
        }

        return strtoupper($companyCode).'-AC/'.str_pad($value, 6, '0', STR_PAD_LEFT).'/'. date('y');
    }

    public static function convertToWordsBackup($number)
    {
        $words = [
            'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'ten',
            'eleven', 'twelve', 'thirteen', 'fourteen', 'fifteen', 'sixteen', 'seventeen', 'eighteen', 'nineteen'
        ];

        $tens = ['', '', 'twenty', 'thirty', 'forty', 'fifty', 'sixty', 'seventy', 'eighty', 'ninety'];

        if ($number < 20) {
            return $words[$number];
        } elseif ($number < 100) {
            return $tens[floor($number / 10)] . ($number % 10 !== 0 ? '-' . $words[$number % 10] : '');
        } elseif ($number < 1000) {
            return $words[floor($number / 100)] . ' hundred ' . ($number % 100 !== 0 ? 'and ' . self::convertToWords($number % 100) : '');
        } elseif ($number < 1000000) {
            return self::convertToWords(floor($number / 1000)) . ' thousand ' . ($number % 1000 !== 0 ? self::convertToWords($number % 1000) : '');
        } else {
            return 'Number is too large to convert';
        }
    }

    public static function convertToWords($number)
    {
        $number = (int)$number;
        $words = [
            'zero', 'one', 'two', 'three', 'four', 'five', 'six', 'seven', 'eight', 'nine', 'ten',
            'eleven', 'twelve', 'thirteen', 'fourteen', 'fifteen', 'sixteen', 'seventeen', 'eighteen', 'nineteen'
        ];

        $tens = ['', '', 'twenty', 'thirty', 'forty', 'fifty', 'sixty', 'seventy', 'eighty', 'ninety'];

        if ($number < 20) {
            return $words[$number];
        } elseif ($number < 100) {
            return $tens[floor($number / 10)] . ($number % 10 !== 0 ? '-' . $words[$number % 10] : '');
        } elseif ($number < 1000) {
            return $words[floor($number / 100)] . ' hundred' . ($number % 100 !== 0 ? ' and ' . self::convertToWords($number % 100) : '');
        } elseif ($number < 100000) {
            return self::convertToWords(floor($number / 1000)) . ' thousand' . ($number % 1000 !== 0 ? ' ' . self::convertToWords($number % 1000) : '');
        } elseif ($number < 10000000) { // Handling up to crore (10 million)
            return self::convertToWords(floor($number / 100000)) . ' lakh' . ($number % 100000 !== 0 ? ' ' . self::convertToWords($number % 100000) : '');
        } else {
            return self::convertToWords(floor($number / 10000000)) . ' crore' . ($number % 10000000 !== 0 ? ' ' . self::convertToWords($number % 10000000) : '');
        }
    }

    public static function formatVatPercentage($vatRate) {
        // $vatRate = number_format((float) $vatRate, 2, '.', '');

        return ($vatRate ? $vatRate : '0') . '%';
    }

    public static function dateMaker($dateString,$sourceFormat,$targetFormat) {
        //sample - '11/06/2024', 'd/m/Y', 'Y-m-d'
        $date = DateTime::createFromFormat($sourceFormat, $dateString);
        if ($date !== false) {
            $newDateString = $date->format($targetFormat);
            return $newDateString;
        } else {
            return "Invalid date format.";
        }
    }

    // Random string by Salaquzzaman @ 03-06-2024
    public static function genRandString($length) {
        $characters = 'abcdefghijklmnopqrstuvwxyz';
        $charactersLength = strlen($characters);
        $randomString = '';

        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }

}
