<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BillProcess extends Model
{
    use HasFactory;

    protected $fillable = [
        'bill_id',
        'invoice_no',
        'process_no',
        'process_no_format',
        'process_uuid',
        'sl_no',
        'customer_id',
        'particulars',
        'currency',
        'currency_rate',

        'qty',
        'unit_price_vat',
        'unit_total',
        'conv_unit_total',
        'total_amount',
        'convertion_total_amount',
        'total_amount_vat',
        'convertion_total_amount_vat',
        'vat_type',
        'vat_status',
        'vat_percent',
        'vat_amount',
        'conv_vat_amount',

        'due',
        'bill_subject_id',
        'bill_subject_desc',
        'ref_no',
        'ref_date',
        'installation_date',
        'activation_date',
        'start_date',
        'end_date',
        'attention_id',
        'attention_person',
        'department_id',
        'billDivName',
        'bill_group',
        'bill_type',
        'hs_code',
        'payment_type',
        'vat_refund',
        'yearly_increase_percent',
        'increase_start_date',
        'payment_status',
        'order_sl_no',
        'month',
        'year',
        'invoice_date',
        'remarks',
        'processedBy',
        'is_print',
        'printed_by',
        'printed_date',
        'duplicate_print_count',
        'uuid',
        'delete_flag'
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function department()
    {
        return $this->belongsTo(Department::class);
    }

    public function billSubject()
    {
        return $this->belongsTo(BillSubject::class);
    }

    public function processedBy()
    {
        return $this->belongsTo(User::class, 'processedBy');
    }

    public function generatedBy()
    {
        return $this->belongsTo(User::class, 'challan_gen_by');
    }



}
