<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\BillProcess;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Bill extends Model
{
    use HasFactory;

    protected $table='billing_bills';

    protected $fillable = [
        'customer_id',
        'particulars',
        'currency',
        'currency_rate',

        'qty',
        'unit_price_vat',
        'unit_total',
        'conv_unit_total',
        'total_amount',
        'convertion_total_amount',
        'total_amount_vat',
        'convertion_total_amount_vat',
        'vat_type',
        'vat_status',
        'vat_percent',
        'vat_amount',
        'conv_vat_amount',

        'bin_number',
        'bill_subject_id',
        'ref_no',
        'ref_date',
        'installation_date',
        'activation_date',
        'start_date',
        'end_date',
        'attention_id',
        'attention_person',
        'department_id',
        'billDivName',
        'bill_group',
        'bill_type',
        'hs_code',
        'payment_type',
        'increase_period',
        'yearly_increase_percent',
        'increase_start_date',
        'status',
        'vat_refund',
        'order_sl_no',
        'bill_note',
        'workorder_file',
        'instalation_file',
        'deliverychallan_file',
        'approval',
        'approved_by',
        'awaiting_approved_by',
        'department_head',
        'bill_editor_id',
        'bill_edited',
        'delete_flag',
        'reject_note',
        'bill_no_x',
        'created_by',
    ];

    public function customer()
    {
        return $this->belongsTo(Customer::class);
    }

    public function department()
    {
        return $this->belongsTo(Department::class);
    }

    public function billSubject()
    {
        return $this->belongsTo(BillSubject::class);
    }

    public function departmentHead()
    {
        return $this->belongsTo(User::class,'department_head');
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function billProcesses()
    {
        return $this->hasMany(BillProcess::class, 'bill_id');
    }

    public static function getTableName()
    {
        return (new self())->getTable();
    }

    public static function paid_status($bill_id)
    {
        $bill = BillProcess::where('bill_id',$bill_id)->first();
        if($bill){
            return $bill->payment_status;
        }else{
            return '';
        }
    }

    public function billProcess(): HasMany
    {
        return $this->hasMany(BillProcess::class, 'bill_id', 'id');
    }

}
