<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\UserDept;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Validator;

class UserDeptController extends Controller
{
    // public function index()
    // {
    //     if (!auth()->user()->can('Manage Setup')) {
    //         abort(403, 'Sorry !! You are not authorized!');
    //     }


    //     $UserDepts = UserDept::all();
    //     return view('UserDept.index', compact('UserDepts'));
    // }

    public function index(Request $request)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $perPage = $request->input('per_page', 25);

        $UserDepts = UserDept::paginate($perPage);

        return view('userDept.index', compact('UserDepts', 'perPage'));
    }

    public function create()
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $departments = [];
        $token = session('api_token');
        $api_ip = env("API_IP");
        $company_number = env("COMPANY_NUMBER");

        //get department list from api - salaquzzaman @ 05-06-2024
        try{
            $response2 = Http::withHeaders([
                'Authorization' => 'Bearer ' . $token,
            ])->get($api_ip.'/api/v1/departments/all');

            if ($response2->successful()) {
                $responseData2 = $response2->json();
                if ($responseData2) {
                    $departments = $responseData2;
                }
            }
        }catch (\Exception $e) {
            // Log::error($e->getMessage());
        }

        $users = User::whereNotIn('id', [1,91,94,95,96,97,98,99,100,101,102,103,104,105,108,109,110,111])->get();

        return view('userDept.create',compact('departments','users'));
    }

    public function store(Request $request)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }


        $validator = Validator::make($request->all(), [
            'user_id' => 'required',
            'department_id' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->route('user-dept.index')
                         ->with('error', 'Missing required fields.');
        }

        UserDept::create($request->all());

        return redirect()->route('user-dept.index')
                         ->with('success', 'Data saved successfully.');

    }

    public function edit(UserDept $UserDept)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $departments = [];
        $token = session('api_token');
        $api_ip = env("API_IP");
        $company_number = env("COMPANY_NUMBER");

        //get department list from api - salaquzzaman @ 05-06-2024
        try{
            $response2 = Http::withHeaders([
                'Authorization' => 'Bearer ' . $token,
            ])->get($api_ip.'/api/v1/departments/all');

            if ($response2->successful()) {
                $responseData2 = $response2->json();
                if ($responseData2) {
                    $departments = $responseData2;
                }
            }
        }catch (\Exception $e) {
            // Log::error($e->getMessage());
        }

        $users = User::whereNotIn('id', [1,91,94,95,96,97,98,99,100,101,102,103,104,105,108,109,110,111])->get();

        return view('userDept.edit', compact('UserDept','users','departments'));
    }

    public function update(Request $request, UserDept $UserDept)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }


        $validator = Validator::make($request->all(), [
            'user_id' => 'required',
            'department_id' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->route('user-dept.index')
                         ->with('error', 'Missing required fields.');
        }

        $UserDept->update($request->all());

        return redirect()->route('user-dept.index')
                         ->with('success', 'Data updated successfully.');
    }

    public function destroy(UserDept $UserDept)
    {
        if (!auth()->user()->can('Manage Setup')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $UserDept->delete();

        return redirect()->route('user-dept.index')
                         ->with('success', 'Data deleted successfully.');
    }
}
