<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Settings;
use Illuminate\Support\Facades\Storage;

class SettingsController extends Controller
{
    public function index()
    {
        if (!auth()->user()->can('Manage Settings')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $settings=Settings::get_settings();
        return view('settings.index', compact('settings'));
    }

    public function store(Request $request)
    {
        if (!auth()->user()->can('Manage Settings')) {
            abort(403, 'Sorry !! You are not authorized!');
        }
        
        $fileSettings = ['company_logo_light', 'company_logo_dark', 'company_favicon'];

        foreach ($fileSettings as $file) {
            if ($request->hasFile($file)) {

                $extension = $request->file($file)->getClientOriginalExtension();
                $fileNameToStore = uniqid() . '.' . $extension;
                $path = $request->file($file)->storeAs('logo', $fileNameToStore, 'public');

                $data = Settings::whereName($file)->first();

                if ($data && $data->value) {
                    Storage::disk('public')->delete('logo/' . $data->value);
                }

                if ($data) {
                    $data->update(['value' => $fileNameToStore]);
                }
            }
        }

        foreach ($request->except(array_merge(['_token'], $fileSettings)) as $key => $value) {
            $data = Settings::whereName($key)->first();
            if ($data) {
                $data->update(['value' => $value]);
            }
        }

        return redirect()->route('settings.index')
                         ->with('success', 'Settings updated successfully.');
                         
    }

}
