<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Route;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use DB;

class RoleController extends Controller
{
    public $user;

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $this->user = Auth::guard('web')->user();
            return $next($request);
        });
    }

    public function index()
    {
        // if (!auth()->user()->can('Manage Role')) {
        //     abort(403, 'Sorry !! You are not authorized!');
        // }

        $roles = Role::all();
        return view('role.index', compact('roles'));
    }

    public function create()
    {
        if (!auth()->user()->can('Manage Role')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        return view('role.create');
    }

    public function store(Request $request)
    {
        if (!auth()->user()->can('Manage Role')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $validator = Validator::make($request->all(), [
            'name' => 'required|unique:roles',
        ]);

        if ($validator->fails()) {
            return redirect()->route('roles.index')
                         ->with('error', 'Missing required fields.');
        }

        Role::create($request->all() + ['guard_name' => 'web']);

        return redirect()->route('roles.index')
                         ->with('success', 'Role created successfully.');
    }

    public function edit(Role $role)
    {
        if (!auth()->user()->can('Manage Role')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        return view('role.edit', compact('role'));
    }

    public function update(Request $request, Role $role)
    {
        if (!auth()->user()->can('Manage Role')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $validator = Validator::make($request->all(), [
            'name' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->route('roles.index')
                         ->with('error', 'Missing required fields.');
        }

        $role->update($request->all());

        return redirect()->route('roles.index')
                         ->with('success', 'Role updated successfully.');
    }

    public function destroy(Role $role)
    {
        if (!auth()->user()->can('Manage Role')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        $role->delete();

        return redirect()->route('roles.index')
                         ->with('success', 'Role deleted successfully.');
    }

    public function permissionList()
    {
        // if (!auth()->user()->can('Manage Role')) {
        //     abort(403, 'Sorry !! You are not authorized!');
        // }

        $roles = Role::all();
        return view('permission.role_list',compact('roles'));
    }

    public function permissionAdd()
    {
        // if (!auth()->user()->can('Manage Role')) {
        //     abort(403, 'Sorry !! You are not authorized!');
        // }

        $all_permissions  = Permission::where('group_name', '!=', null)->where('group_name', '!=', '')->get();
        $permission_groups = User::getpermissionGroups();

        return view('permission.role_add', compact('all_permissions', 'permission_groups'));
    }

    public function storePermissions(Request $request)
    {
        // if (!auth()->user()->can('Manage Role')) {
        //     abort(403, 'Sorry !! You are not authorized!');
        // }

        $request->validate([
            'name' => 'required|max:100|unique:roles'
        ], [
            'name.requried' => 'Please give a role name'
        ]);

        $role = Role::create(['name' => $request->name, 'guard_name' => 'web']);

        $permissions = $request->input('permissions');

        $role->syncPermissions($permissions);

        return redirect()->route('permissions.index')->with('success', 'Permissions added successfully');
    }

    public function permissionEdit($id)
    {
        // if (!auth()->user()->can('Manage Role')) {
        //     abort(403, 'Sorry !! You are not authorized!');
        // }

        $role = Role::findById($id, 'web');
        $all_permissions = Permission::all();
        $permission_groups = User::getpermissionGroups();
        return view('permission.role_edit', compact('role', 'all_permissions', 'permission_groups'));
    }

    public function updatePermission(Request $request, $id)
    {
        // if (!auth()->user()->can('Manage Role')) {
        //     abort(403, 'Sorry !! You are not authorized!');
        // }

        if ($id === 1) {
            return redirect()->back()->with('error', 'Sorry, You are not authorized to edit this role');
        }

        $request->validate([
            'name' => 'required|max:100|unique:roles,name,' . $id
        ], [
            'name.requried' => 'Please give a role name'
        ]);

        $role = Role::findById($id, 'web');
        $permissions = $request->input('permissions');

        $role->name = $request->name;
        $role->save();
        $role->syncPermissions($permissions);

        return redirect()->back()->with('success', 'Permissions updated successfully');
    }

    public function deletePermission($id)
    {
        if (!auth()->user()->can('Manage Role')) {
            abort(403, 'Sorry !! You are not authorized!');
        }

        if ($id === 1) {
            return redirect()->back()->with('error', 'Sorry, You are not authorized to delete this role');
        }

        $role = Role::findById($id, 'web');
        if (!is_null($role)) {
            $role->delete();
        }

        return redirect()->back()->with('success', 'Role deleted successfully');
    }

    public function getPagePermission(Request $request)
    {
        $userId = $request->id;

        $user = User::find($userId);

        $permissionGroups = User::getPermissionGroups($userId); // permissionGroups

        if ($user) {

            $roles = $user->roles;

            $permissions = [];

            foreach ($roles as $role) {

                $permissions = array_merge($permissions, $role->permissions->pluck('name')->toArray());
            }

                $all_permissions  = Permission::all();
                $permission_groups = User::getpermissionGroups();

                ?>


                <form action="<?php echo route('permissions.update', $role->id); ?>" method="POST">

                <?php echo method_field('PUT'); ?>
                <?php echo csrf_field(); ?>
                <input type="hidden" name="_method" value="PUT">
                <input type="hidden" name="_token" value="<?php echo csrf_token(); ?>">

                <input type="hidden" id="name" value="<?php echo htmlspecialchars($role->name); ?>" name="name" placeholder="Enter a Role Name">


                <?php

                foreach ($all_permissions as $permission) {
                    $isChecked = in_array($permission->name, $permissions);

                    echo '<div class="form-check">';
                    echo '<input type="checkbox" class="form-check-input" name="permissions[]" id="checkPermission'.$permission->id.'" value="'.$permission->name.'" '.($isChecked ? 'checked' : '').'>';
                    echo '<label class="form-check-label" for="checkPermission'.$permission->id.'">'.$permission->name.'</label>';
                    echo '</div>';
                }

                ?>
                <br>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save changes</button>
                </div>

                <?php


            return;

        } else {

            return [];
        }

    }

}
